/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import plan.org.h2.JdbcDriverBackwardsCompat;
import plan.org.h2.jdbc.JdbcConnection;
import plan.org.h2.message.DbException;
import plan.org.h2.upgrade.DbUpgrade;

public class Driver
implements java.sql.Driver,
JdbcDriverBackwardsCompat {
    private static final Driver INSTANCE = new Driver();
    private static final String DEFAULT_URL = "jdbc:default:connection";
    private static final ThreadLocal<Connection> DEFAULT_CONNECTION = new ThreadLocal();
    private static boolean registered;

    @Override
    public Connection connect(String string, Properties properties) throws SQLException {
        try {
            if (properties == null) {
                properties = new Properties();
            }
            if (!this.acceptsURL(string)) {
                return null;
            }
            if (string.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get();
            }
            Connection connection = DbUpgrade.connectOrUpgrade(string, properties);
            if (connection != null) {
                return connection;
            }
            return new JdbcConnection(string, properties);
        }
        catch (Exception exception) {
            throw DbException.toSQLException(exception);
        }
    }

    @Override
    public boolean acceptsURL(String string) {
        if (string != null) {
            if (string.startsWith("jdbc:h2:")) {
                return true;
            }
            if (string.equals(DEFAULT_URL)) {
                return DEFAULT_CONNECTION.get() != null;
            }
        }
        return false;
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 4;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }

    public static synchronized Driver load() {
        try {
            if (!registered) {
                registered = true;
                DriverManager.registerDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            DbException.traceThrowable(sQLException);
        }
        return INSTANCE;
    }

    public static synchronized void unload() {
        try {
            if (registered) {
                registered = false;
                DriverManager.deregisterDriver(INSTANCE);
            }
        }
        catch (SQLException sQLException) {
            DbException.traceThrowable(sQLException);
        }
    }

    public static void setDefaultConnection(Connection connection) {
        if (connection == null) {
            DEFAULT_CONNECTION.remove();
        } else {
            DEFAULT_CONNECTION.set(connection);
        }
    }

    public static void setThreadContextClassLoader(Thread thread) {
        try {
            thread.setContextClassLoader(Driver.class.getClassLoader());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        Driver.load();
    }
}

