/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.command;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import plan.org.h2.command.CommandInterface;
import plan.org.h2.engine.Database;
import plan.org.h2.engine.Session;
import plan.org.h2.expression.ParameterInterface;
import plan.org.h2.message.DbException;
import plan.org.h2.message.Trace;
import plan.org.h2.result.ResultInterface;
import plan.org.h2.result.ResultWithGeneratedKeys;
import plan.org.h2.result.ResultWithPaddedStrings;
import plan.org.h2.util.MathUtils;

public abstract class Command
implements CommandInterface {
    protected final Session session;
    protected long startTimeNanos;
    private final Trace trace;
    private volatile boolean cancel;
    private final String sql;
    private boolean canReuse;

    Command(Session session, String string) {
        this.session = session;
        this.sql = string;
        this.trace = session.getDatabase().getTrace(0);
    }

    public abstract boolean isTransactional();

    @Override
    public abstract boolean isQuery();

    public abstract void prepareJoinBatch();

    @Override
    public abstract ArrayList<? extends ParameterInterface> getParameters();

    public abstract boolean isReadOnly();

    public abstract ResultInterface queryMeta();

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n) {
        throw DbException.get(90002);
    }

    @Override
    public final ResultInterface getMetaData() {
        return this.queryMeta();
    }

    void start() {
        if (this.trace.isInfoEnabled() || this.session.getDatabase().getQueryStatistics()) {
            this.startTimeNanos = System.nanoTime();
        }
    }

    void setProgress(int n) {
        this.session.getDatabase().setProgress(n, this.sql, 0, 0);
    }

    protected void checkCanceled() {
        if (this.cancel) {
            this.cancel = false;
            throw DbException.get(57014);
        }
    }

    @Override
    public void stop() {
        long l;
        this.session.setCurrentCommand(null, false);
        if (!this.isTransactional()) {
            this.session.commit(true);
        } else if (this.session.getAutoCommit()) {
            this.session.commit(false);
        } else {
            this.session.unlockReadLocks();
        }
        this.session.endStatement();
        if (this.trace.isInfoEnabled() && this.startTimeNanos > 0L && (l = (System.nanoTime() - this.startTimeNanos) / 1000L / 1000L) > 100L) {
            this.trace.info("slow query: {0} ms", l);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResultInterface executeQuery(int n, boolean bl) {
        boolean bl2;
        this.startTimeNanos = 0L;
        long l = 0L;
        Database database = this.session.getDatabase();
        Object object = database.isMultiThreaded() || database.getStore() != null ? this.session : database;
        this.session.waitIfExclusiveModeEnabled();
        boolean bl3 = true;
        boolean bl4 = bl2 = !this.isReadOnly();
        if (bl2) {
            while (!database.beforeWriting()) {
            }
        }
        Object object2 = object;
        synchronized (object2) {
            this.session.startStatementWithinTransaction();
            this.session.setCurrentCommand(this, false);
            while (true) {
                ResultInterface resultInterface;
                block20: {
                    database.checkPowerOff();
                    resultInterface = this.query(n);
                    boolean bl5 = bl3 = !resultInterface.isLazy();
                    if (!database.getMode().padFixedLengthStrings) break block20;
                    ResultInterface resultInterface2 = ResultWithPaddedStrings.get(resultInterface);
                    return resultInterface2;
                }
                ResultInterface resultInterface3 = resultInterface;
                return resultInterface3;
                {
                    catch (DbException dbException) {
                        l = this.filterConcurrentUpdate(dbException, l);
                        continue;
                    }
                    catch (OutOfMemoryError outOfMemoryError) {
                        bl3 = false;
                        database.shutdownImmediately();
                        throw DbException.convert(outOfMemoryError);
                    }
                    catch (Throwable throwable) {
                        throw DbException.convert(throwable);
                    }
                    {
                        catch (DbException dbException) {
                            DbException dbException2 = dbException.addSQL(this.sql);
                            SQLException sQLException = dbException2.getSQLException();
                            database.exceptionThrown(sQLException, this.sql);
                            if (sQLException.getErrorCode() == 90108) {
                                bl3 = false;
                                database.shutdownImmediately();
                                throw dbException2;
                            }
                            database.checkPowerOff();
                            throw dbException2;
                        }
                    }
                }
                break;
            }
            finally {
                if (bl3) {
                    this.stop();
                }
                if (bl2) {
                    database.afterWriting();
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultWithGeneratedKeys executeUpdate(Object var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long filterConcurrentUpdate(DbException dbException, long l) {
        long l2;
        block6: {
            long l3;
            int n = dbException.getErrorCode();
            if (n != 90131 && n != 90143 && n != 90112) {
                throw dbException;
            }
            l2 = System.nanoTime();
            if (l != 0L && TimeUnit.NANOSECONDS.toMillis(l2 - l) > (long)this.session.getLockTimeout()) {
                throw DbException.get(50200, dbException, new String[0]);
            }
            Database database = this.session.getDatabase();
            if (database.getStore() != null) break block6;
            int n2 = 1 + MathUtils.randomInt(10);
            do {
                try {
                    if (database.isMultiThreaded()) {
                        Thread.sleep(n2);
                        continue;
                    }
                    database.wait(n2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while ((l3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2)) < (long)n2);
        }
        return l == 0L ? l2 : l;
    }

    @Override
    public void close() {
        this.canReuse = true;
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    public String toString() {
        return this.sql + Trace.formatParams(this.getParameters());
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean canReuse() {
        return this.canReuse;
    }

    public void reuse() {
        this.canReuse = false;
        ArrayList<? extends ParameterInterface> arrayList = this.getParameters();
        for (ParameterInterface parameterInterface : arrayList) {
            parameterInterface.setValue(null, true);
        }
    }

    public void setCanReuse(boolean bl) {
        this.canReuse = bl;
    }
}

