/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.constraint;

import java.util.HashSet;
import plan.org.h2.constraint.Constraint;
import plan.org.h2.engine.Session;
import plan.org.h2.index.Index;
import plan.org.h2.result.Row;
import plan.org.h2.schema.Schema;
import plan.org.h2.table.Column;
import plan.org.h2.table.IndexColumn;
import plan.org.h2.table.Table;
import plan.org.h2.util.StringUtils;

public class ConstraintUnique
extends Constraint {
    private Index index;
    private boolean indexOwner;
    private IndexColumn[] columns;
    private final boolean primaryKey;

    public ConstraintUnique(Schema schema, int n, String string, Table table, boolean bl) {
        super(schema, n, string, table);
        this.primaryKey = bl;
    }

    @Override
    public Constraint.Type getConstraintType() {
        return this.primaryKey ? Constraint.Type.PRIMARY_KEY : Constraint.Type.UNIQUE;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.getCreateSQLForCopy(table, string, true);
    }

    private String getCreateSQLForCopy(Table table, String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("ALTER TABLE ");
        table.getSQL(stringBuilder, true).append(" ADD CONSTRAINT ");
        if (table.isHidden()) {
            stringBuilder.append("IF NOT EXISTS ");
        }
        stringBuilder.append(string);
        if (this.comment != null) {
            stringBuilder.append(" COMMENT ");
            StringUtils.quoteStringSQL(stringBuilder, this.comment);
        }
        stringBuilder.append(' ').append(this.getConstraintType().getSqlName()).append('(');
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            this.columns[i].column.getSQL(stringBuilder, true);
        }
        stringBuilder.append(')');
        if (bl && this.indexOwner && table == this.table) {
            stringBuilder.append(" INDEX ");
            this.index.getSQL(stringBuilder, true);
        }
        return stringBuilder.toString();
    }

    @Override
    public String getCreateSQLWithoutIndexes() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true), false);
    }

    @Override
    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.getSQL(true));
    }

    public void setColumns(IndexColumn[] indexColumnArray) {
        this.columns = indexColumnArray;
    }

    public IndexColumn[] getColumns() {
        return this.columns;
    }

    public void setIndex(Index index, boolean bl) {
        this.index = index;
        this.indexOwner = bl;
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.table.removeConstraint(this);
        if (this.indexOwner) {
            this.table.removeIndexOrTransferOwnership(session, this.index);
        }
        this.database.removeMeta(session, this.getId());
        this.index = null;
        this.columns = null;
        this.table = null;
        this.invalidate();
    }

    @Override
    public void checkRow(Session session, Table table, Row row, Row row2) {
    }

    @Override
    public boolean usesIndex(Index index) {
        return index == this.index;
    }

    @Override
    public void setIndexOwner(Index index) {
        this.indexOwner = true;
    }

    @Override
    public HashSet<Column> getReferencedColumns(Table table) {
        HashSet<Column> hashSet = new HashSet<Column>();
        for (IndexColumn indexColumn : this.columns) {
            hashSet.add(indexColumn.column);
        }
        return hashSet;
    }

    @Override
    public boolean isBefore() {
        return true;
    }

    @Override
    public void checkExistingData(Session session) {
    }

    @Override
    public Index getUniqueIndex() {
        return this.index;
    }

    @Override
    public void rebuild() {
    }
}

