/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.engine;

import java.util.HashMap;
import plan.org.h2.engine.SettingsBase;
import plan.org.h2.message.DbException;
import plan.org.h2.util.Utils;

public class DbSettings
extends SettingsBase {
    private static DbSettings defaultSettings;
    public final boolean aliasColumnName = this.get("ALIAS_COLUMN_NAME", false);
    public final int analyzeAuto = this.get("ANALYZE_AUTO", 2000);
    public final int analyzeSample = this.get("ANALYZE_SAMPLE", 10000);
    public final boolean databaseToLower;
    public final boolean databaseToUpper;
    public final boolean caseInsensitiveIdentifiers = this.get("CASE_INSENSITIVE_IDENTIFIERS", false);
    public final boolean dbCloseOnExit = this.get("DB_CLOSE_ON_EXIT", true);
    public final boolean defaultConnection = this.get("DEFAULT_CONNECTION", false);
    public final String defaultEscape = this.get("DEFAULT_ESCAPE", "\\");
    public final boolean defragAlways = this.get("DEFRAG_ALWAYS", false);
    public final boolean dropRestrict = this.get("DROP_RESTRICT", true);
    public final boolean earlyFilter = this.get("EARLY_FILTER", false);
    public final int estimatedFunctionTableRows = this.get("ESTIMATED_FUNCTION_TABLE_ROWS", 1000);
    public final boolean functionsInSchema = this.get("FUNCTIONS_IN_SCHEMA", true);
    public final int lobTimeout = this.get("LOB_TIMEOUT", 300000);
    public final int maxCompactCount = this.get("MAX_COMPACT_COUNT", Integer.MAX_VALUE);
    public final int maxCompactTime = this.get("MAX_COMPACT_TIME", 200);
    public final int maxQueryTimeout = this.get("MAX_QUERY_TIMEOUT", 0);
    public final boolean optimizeDistinct = this.get("OPTIMIZE_DISTINCT", true);
    public final boolean optimizeEvaluatableSubqueries = this.get("OPTIMIZE_EVALUATABLE_SUBQUERIES", true);
    public final boolean optimizeInsertFromSelect = this.get("OPTIMIZE_INSERT_FROM_SELECT", true);
    public final boolean optimizeInList = this.get("OPTIMIZE_IN_LIST", true);
    public final boolean optimizeInSelect = this.get("OPTIMIZE_IN_SELECT", true);
    public final boolean optimizeOr = this.get("OPTIMIZE_OR", true);
    public final boolean optimizeTwoEquals = this.get("OPTIMIZE_TWO_EQUALS", true);
    public final boolean optimizeUpdate = this.get("OPTIMIZE_UPDATE", true);
    public final int pageStoreMaxGrowth = this.get("PAGE_STORE_MAX_GROWTH", 131072);
    public final boolean pageStoreInternalCount = this.get("PAGE_STORE_INTERNAL_COUNT", false);
    public final boolean pageStoreTrim = this.get("PAGE_STORE_TRIM", true);
    public final int queryCacheSize = this.get("QUERY_CACHE_SIZE", 8);
    public final boolean recompileAlways = this.get("RECOMPILE_ALWAYS", false);
    public final int reconnectCheckDelay = this.get("RECONNECT_CHECK_DELAY", 200);
    public final boolean reuseSpace = this.get("REUSE_SPACE", true);
    public final boolean shareLinkedConnections = this.get("SHARE_LINKED_CONNECTIONS", true);
    public final String defaultTableEngine = this.get("DEFAULT_TABLE_ENGINE", null);
    public boolean mvStore = this.get("MV_STORE", true);
    public final boolean compressData = this.get("COMPRESS", false);
    public final boolean standardDropTableRestrict = this.get("STANDARD_DROP_TABLE_RESTRICT", false);

    private DbSettings(HashMap<String, String> hashMap) {
        super(hashMap);
        if (hashMap.get("NESTED_JOINS") != null || Utils.getProperty("h2.nestedJoins", null) != null) {
            throw DbException.getUnsupportedException("NESTED_JOINS setting is not available since 1.4.197");
        }
        boolean bl = this.get("DATABASE_TO_LOWER", false);
        boolean bl2 = this.containsKey("DATABASE_TO_UPPER");
        boolean bl3 = this.get("DATABASE_TO_UPPER", true);
        if (bl && bl3) {
            if (bl2) {
                throw DbException.get(90021, "DATABASE_TO_LOWER & DATABASE_TO_UPPER");
            }
            bl3 = false;
        }
        this.databaseToLower = bl;
        this.databaseToUpper = bl3;
        HashMap<String, String> hashMap2 = this.getSettings();
        hashMap2.put("DATABASE_TO_LOWER", Boolean.toString(bl));
        hashMap2.put("DATABASE_TO_UPPER", Boolean.toString(bl3));
    }

    public static DbSettings getInstance(HashMap<String, String> hashMap) {
        return new DbSettings(hashMap);
    }

    public static DbSettings getDefaultSettings() {
        if (defaultSettings == null) {
            defaultSettings = new DbSettings(new HashMap<String, String>());
        }
        return defaultSettings;
    }
}

