/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.expression;

import java.io.IOException;
import plan.org.h2.expression.ParameterInterface;
import plan.org.h2.message.DbException;
import plan.org.h2.value.Transfer;
import plan.org.h2.value.Value;

public class ParameterRemote
implements ParameterInterface {
    private Value value;
    private final int index;
    private int dataType = -1;
    private long precision;
    private int scale;
    private int nullable = 2;

    public ParameterRemote(int n) {
        this.index = n;
    }

    @Override
    public void setValue(Value value, boolean bl) {
        if (bl && this.value != null) {
            this.value.remove();
        }
        this.value = value;
    }

    @Override
    public Value getParamValue() {
        return this.value;
    }

    @Override
    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    @Override
    public boolean isValueSet() {
        return this.value != null;
    }

    @Override
    public int getValueType() {
        return this.value == null ? this.dataType : this.value.getValueType();
    }

    @Override
    public long getPrecision() {
        return this.value == null ? this.precision : this.value.getType().getPrecision();
    }

    @Override
    public int getScale() {
        return this.value == null ? this.scale : this.value.getType().getScale();
    }

    @Override
    public int getNullable() {
        return this.nullable;
    }

    public void readMetaData(Transfer transfer) throws IOException {
        this.dataType = transfer.readInt();
        this.precision = transfer.readLong();
        this.scale = transfer.readInt();
        this.nullable = transfer.readInt();
    }

    public static void writeMetaData(Transfer transfer, ParameterInterface parameterInterface) throws IOException {
        transfer.writeInt(parameterInterface.getValueType());
        transfer.writeLong(parameterInterface.getPrecision());
        transfer.writeInt(parameterInterface.getScale());
        transfer.writeInt(parameterInterface.getNullable());
    }
}

