/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.expression.condition;

import java.util.ArrayList;
import plan.org.h2.engine.Database;
import plan.org.h2.engine.Session;
import plan.org.h2.expression.Expression;
import plan.org.h2.expression.ExpressionColumn;
import plan.org.h2.expression.ExpressionVisitor;
import plan.org.h2.expression.Parameter;
import plan.org.h2.expression.ValueExpression;
import plan.org.h2.expression.condition.Comparison;
import plan.org.h2.expression.condition.Condition;
import plan.org.h2.expression.condition.ConditionInConstantSet;
import plan.org.h2.expression.condition.ConditionInParameter;
import plan.org.h2.expression.function.TableFunction;
import plan.org.h2.index.IndexCondition;
import plan.org.h2.table.ColumnResolver;
import plan.org.h2.table.TableFilter;
import plan.org.h2.value.Value;
import plan.org.h2.value.ValueBoolean;
import plan.org.h2.value.ValueNull;

public class ConditionIn
extends Condition {
    private final Database database;
    private Expression left;
    private final ArrayList<Expression> valueList;

    public ConditionIn(Database database, Expression expression, ArrayList<Expression> arrayList) {
        this.database = database;
        this.left = expression;
        this.valueList = arrayList;
    }

    @Override
    public Value getValue(Session session) {
        Expression expression;
        Value value = this.left.getValue(session);
        if (value.containsNull()) {
            return ValueNull.INSTANCE;
        }
        int n = this.valueList.size();
        if (n == 1 && (expression = this.valueList.get(0)) instanceof TableFunction) {
            return ConditionInParameter.getValue(this.database, value, expression.getValue(session));
        }
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            Expression expression2 = this.valueList.get(i);
            Value value2 = expression2.getValue(session);
            Value value3 = Comparison.compare(this.database, value, value2, 0);
            if (value3 == ValueNull.INSTANCE) {
                bl = true;
                continue;
            }
            if (value3 != ValueBoolean.TRUE) continue;
            return value3;
        }
        if (bl) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.FALSE;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
        for (Expression expression : this.valueList) {
            expression.mapColumns(columnResolver, n, n2);
        }
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression;
        this.left = this.left.optimize(session);
        boolean bl = this.left.isConstant();
        if (bl && this.left == ValueExpression.getNull()) {
            return this.left;
        }
        int n = this.valueList.size();
        if (n == 1 && (expression = this.valueList.get(0)) instanceof TableFunction) {
            Object object;
            Expression[] expressionArray;
            TableFunction tableFunction = (TableFunction)expression;
            if (tableFunction.getFunctionType() == 233 && (expressionArray = tableFunction.getArgs()).length == 1 && (object = expressionArray[0]) instanceof Parameter) {
                return new ConditionInParameter(this.database, this.left, (Parameter)object);
            }
            if (tableFunction.isConstant()) {
                boolean bl2 = true;
                object = expression.getValue(session).getResult();
                ArrayList<Expression> arrayList = new ArrayList<Expression>(object.getRowCount());
                while (object.next()) {
                    Value value = object.currentRow()[0];
                    if (!value.containsNull()) {
                        bl2 = false;
                    }
                    arrayList.add(ValueExpression.get(value));
                }
                return this.optimize2(session, bl, true, bl2, arrayList);
            }
            return this;
        }
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i = 0; i < n; ++i) {
            Expression expression2 = this.valueList.get(i);
            if ((expression2 = expression2.optimize(session)).isConstant() && !expression2.getValue(session).containsNull()) {
                bl4 = false;
            }
            if (bl3 && !expression2.isConstant()) {
                bl3 = false;
            }
            if (this.left instanceof ExpressionColumn && expression2 instanceof Parameter) {
                ((Parameter)expression2).setColumn(((ExpressionColumn)this.left).getColumn());
            }
            this.valueList.set(i, expression2);
        }
        return this.optimize2(session, bl, bl3, bl4, this.valueList);
    }

    private Expression optimize2(Session session, boolean bl, boolean bl2, boolean bl3, ArrayList<Expression> arrayList) {
        if (bl && bl2) {
            return ValueExpression.get(this.getValue(session));
        }
        if (arrayList.size() == 1) {
            return new Comparison(session, 0, this.left, arrayList.get(0)).optimize(session);
        }
        if (bl2 && !bl3) {
            int n = this.left.getType().getValueType();
            if (n == -1) {
                return this;
            }
            if (n == 25 && !(this.left instanceof ExpressionColumn)) {
                return this;
            }
            Expression expression = new ConditionInConstantSet(session, this.left, arrayList);
            expression = ((Expression)expression).optimize(session);
            return expression;
        }
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            ExpressionVisitor expressionVisitor = ExpressionVisitor.getNotFromResolverVisitor(tableFilter);
            for (Expression expression : this.valueList) {
                if (expression.isEverything(expressionVisitor)) continue;
                return;
            }
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
        for (Expression expression : this.valueList) {
            expression.setEvaluatable(tableFilter, bl);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" IN(");
        ConditionIn.writeExpressions(stringBuilder, this.valueList, bl);
        return stringBuilder.append("))");
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
        for (Expression expression : this.valueList) {
            expression.updateAggregate(session, n);
        }
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        return this.areAllValues(expressionVisitor);
    }

    private boolean areAllValues(ExpressionVisitor expressionVisitor) {
        for (Expression expression : this.valueList) {
            if (expression.isEverything(expressionVisitor)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getCost() {
        int n = this.left.getCost();
        for (Expression expression : this.valueList) {
            n += expression.getCost();
        }
        return n;
    }

    Expression getAdditional(Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null) {
            this.valueList.add(expression);
            return this;
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.left;
        }
        if (n > 0 && n <= this.valueList.size()) {
            return this.valueList.get(n - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

