/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.expression.condition;

import plan.org.h2.engine.Session;
import plan.org.h2.expression.Expression;
import plan.org.h2.expression.ExpressionVisitor;
import plan.org.h2.expression.ValueExpression;
import plan.org.h2.expression.condition.Condition;
import plan.org.h2.table.ColumnResolver;
import plan.org.h2.table.TableFilter;
import plan.org.h2.value.Value;
import plan.org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression expression) {
        this.condition = expression;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return this.condition;
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.condition.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.condition.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression = this.condition.getNotIfPossible(session);
        if (expression != null) {
            return expression.optimize(session);
        }
        Expression expression2 = this.condition.optimize(session);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return ValueExpression.getNull();
            }
            return ValueExpression.get(value.convertTo(1).negate());
        }
        this.condition = expression2;
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.condition.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(NOT ");
        return this.condition.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.condition.updateAggregate(session, n);
    }

    @Override
    public void addFilterConditions(TableFilter tableFilter, boolean bl) {
        if (bl) {
            return;
        }
        super.addFilterConditions(tableFilter, bl);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.condition.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.condition.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.condition;
        }
        throw new IndexOutOfBoundsException();
    }
}

