/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.index;

import plan.org.h2.engine.Session;
import plan.org.h2.index.Cursor;
import plan.org.h2.index.FunctionIndex;
import plan.org.h2.message.DbException;
import plan.org.h2.result.Row;
import plan.org.h2.result.SearchRow;
import plan.org.h2.value.Value;

abstract class AbstractFunctionCursor
implements Cursor {
    private final FunctionIndex index;
    private final SearchRow first;
    private final SearchRow last;
    final Session session;
    Value[] values;
    Row row;

    AbstractFunctionCursor(FunctionIndex functionIndex, SearchRow searchRow, SearchRow searchRow2, Session session) {
        this.index = functionIndex;
        this.first = searchRow;
        this.last = searchRow2;
        this.session = session;
    }

    @Override
    public Row get() {
        if (this.values == null) {
            return null;
        }
        if (this.row == null) {
            this.row = this.session.createRow(this.values, 1);
        }
        return this.row;
    }

    @Override
    public SearchRow getSearchRow() {
        return this.get();
    }

    @Override
    public boolean next() {
        SearchRow searchRow = this.first;
        SearchRow searchRow2 = this.last;
        if (searchRow == null && searchRow2 == null) {
            return this.nextImpl();
        }
        while (this.nextImpl()) {
            int n;
            Row row = this.get();
            if (searchRow != null && (n = this.index.compareRows(row, searchRow)) < 0 || searchRow2 != null && (n = this.index.compareRows(row, searchRow2)) > 0) continue;
            return true;
        }
        return false;
    }

    abstract boolean nextImpl();

    @Override
    public boolean previous() {
        throw DbException.throwInternalError(this.toString());
    }
}

