/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.index;

import plan.org.h2.command.dml.AllColumnsForPlan;
import plan.org.h2.engine.Session;
import plan.org.h2.index.Cursor;
import plan.org.h2.index.IndexType;
import plan.org.h2.index.PageDataIndex;
import plan.org.h2.index.PageIndex;
import plan.org.h2.message.DbException;
import plan.org.h2.result.Row;
import plan.org.h2.result.SearchRow;
import plan.org.h2.result.SortOrder;
import plan.org.h2.store.PageStore;
import plan.org.h2.table.Column;
import plan.org.h2.table.IndexColumn;
import plan.org.h2.table.PageStoreTable;
import plan.org.h2.table.TableFilter;

public class PageDelegateIndex
extends PageIndex {
    private final PageDataIndex mainIndex;

    public PageDelegateIndex(PageStoreTable pageStoreTable, int n, String string, IndexType indexType, PageDataIndex pageDataIndex, boolean bl, Session session) {
        super(pageStoreTable, n, string, IndexColumn.wrap(new Column[]{pageStoreTable.getColumn(pageDataIndex.getMainIndexColumn())}), indexType);
        this.mainIndex = pageDataIndex;
        if (!this.database.isPersistent() || n < 0) {
            throw DbException.throwInternalError(string);
        }
        PageStore pageStore = this.database.getPageStore();
        pageStore.addIndex(this);
        if (bl) {
            pageStore.addMeta(this, session);
        }
    }

    @Override
    public void add(Session session, Row row) {
    }

    @Override
    public boolean canFindNext() {
        return false;
    }

    @Override
    public boolean canGetFirstOrLast() {
        return true;
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) {
        long l = this.mainIndex.getKey(searchRow, Long.MIN_VALUE, Long.MIN_VALUE);
        long l2 = this.mainIndex.getKey(searchRow2, Long.MAX_VALUE, Long.MIN_VALUE);
        return this.mainIndex.find(session, l, l2);
    }

    @Override
    public Cursor findFirstOrLast(Session session, boolean bl) {
        Cursor cursor;
        if (bl) {
            cursor = this.mainIndex.find(session, Long.MIN_VALUE, Long.MAX_VALUE);
        } else {
            long l = this.mainIndex.getLastKey();
            cursor = this.mainIndex.find(session, l, l);
        }
        cursor.next();
        return cursor;
    }

    @Override
    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) {
        throw DbException.throwInternalError(this.toString());
    }

    @Override
    public int getColumnIndex(Column column) {
        if (column.getColumnId() == this.mainIndex.getMainIndexColumn()) {
            return 0;
        }
        return -1;
    }

    @Override
    public boolean isFirstColumn(Column column) {
        return this.getColumnIndex(column) == 0;
    }

    @Override
    public double getCost(Session session, int[] nArray, TableFilter[] tableFilterArray, int n, SortOrder sortOrder, AllColumnsForPlan allColumnsForPlan) {
        return 10L * this.getCostRangeIndex(nArray, this.mainIndex.getRowCount(session), tableFilterArray, n, sortOrder, false, allColumnsForPlan);
    }

    @Override
    public boolean needRebuild() {
        return false;
    }

    @Override
    public void remove(Session session, Row row) {
    }

    @Override
    public void update(Session session, Row row, Row row2) {
    }

    @Override
    public void remove(Session session) {
        this.mainIndex.setMainIndexColumn(-1);
        session.getDatabase().getPageStore().removeMeta(this, session);
    }

    @Override
    public void truncate(Session session) {
    }

    @Override
    public void checkRename() {
    }

    @Override
    public long getRowCount(Session session) {
        return this.mainIndex.getRowCount(session);
    }

    @Override
    public long getRowCountApproximation() {
        return this.mainIndex.getRowCountApproximation();
    }

    @Override
    public long getDiskSpaceUsed() {
        return this.mainIndex.getDiskSpaceUsed();
    }

    @Override
    public void writeRowCount() {
    }
}

