/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.mvstore;

import java.util.Iterator;
import java.util.NoSuchElementException;
import plan.org.h2.mvstore.CursorPos;
import plan.org.h2.mvstore.DataUtils;
import plan.org.h2.mvstore.MVMap;
import plan.org.h2.mvstore.Page;

public class Cursor<K, V>
implements Iterator<K> {
    private final K to;
    private CursorPos cursorPos;
    private CursorPos keeper;
    private K current;
    private K last;
    private V lastValue;
    private Page lastPage;

    public Cursor(Page page, K k) {
        this(page, k, null);
    }

    public Cursor(Page page, K k, K k2) {
        this.cursorPos = Cursor.traverseDown(page, k);
        this.to = k2;
    }

    @Override
    public boolean hasNext() {
        if (this.cursorPos != null) {
            while (this.current == null) {
                Object object;
                int n = this.cursorPos.index;
                Page page = this.cursorPos.page;
                if (n >= (page.isLeaf() ? page.getKeyCount() : page.map.getChildPageCount(page))) {
                    object = this.cursorPos;
                    this.cursorPos = this.cursorPos.parent;
                    ((CursorPos)object).parent = this.keeper;
                    this.keeper = object;
                    if (this.cursorPos == null) {
                        return false;
                    }
                } else {
                    while (!page.isLeaf()) {
                        page = page.getChildPage(n);
                        if (this.keeper == null) {
                            this.cursorPos = new CursorPos(page, 0, this.cursorPos);
                        } else {
                            object = this.keeper;
                            this.keeper = this.keeper.parent;
                            ((CursorPos)object).parent = this.cursorPos;
                            ((CursorPos)object).page = page;
                            ((CursorPos)object).index = 0;
                            this.cursorPos = object;
                        }
                        n = 0;
                    }
                    object = page.getKey(n);
                    if (this.to != null && page.map.getKeyType().compare(object, this.to) > 0) {
                        return false;
                    }
                    this.last = object;
                    this.current = this.last;
                    this.lastValue = page.getValue(n);
                    this.lastPage = page;
                }
                ++this.cursorPos.index;
            }
        }
        return this.current != null;
    }

    @Override
    public K next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.current = null;
        return this.last;
    }

    public K getKey() {
        return this.last;
    }

    public V getValue() {
        return this.lastValue;
    }

    Page getPage() {
        return this.lastPage;
    }

    public void skip(long l) {
        if (l < 10L) {
            while (l-- > 0L && this.hasNext()) {
                this.next();
            }
        } else if (this.hasNext()) {
            CursorPos cursorPos;
            assert (this.cursorPos != null);
            CursorPos cursorPos2 = this.cursorPos;
            while ((cursorPos = cursorPos2.parent) != null) {
                cursorPos2 = cursorPos;
            }
            Page page = cursorPos2.page;
            MVMap<?, ?> mVMap = page.map;
            long l2 = mVMap.getKeyIndex(this.next());
            this.last = mVMap.getKey(l2 + l);
            this.cursorPos = Cursor.traverseDown(page, this.last);
        }
    }

    @Override
    public void remove() {
        throw DataUtils.newUnsupportedOperationException("Removal is not supported");
    }

    private static CursorPos traverseDown(Page page, Object object) {
        int n;
        CursorPos cursorPos = null;
        while (!page.isLeaf()) {
            n = 0;
            if (object != null && (n = page.binarySearch(object) + 1) < 0) {
                n = -n;
            }
            cursorPos = new CursorPos(page, n, cursorPos);
            page = page.getChildPage(n);
        }
        n = 0;
        if (object != null && (n = page.binarySearch(object)) < 0) {
            n = -n - 1;
        }
        return new CursorPos(page, n, cursorPos);
    }
}

