/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.mvstore;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import plan.org.h2.compress.CompressDeflate;
import plan.org.h2.compress.CompressLZF;
import plan.org.h2.compress.Compressor;
import plan.org.h2.mvstore.Chunk;
import plan.org.h2.mvstore.Cursor;
import plan.org.h2.mvstore.DataUtils;
import plan.org.h2.mvstore.FileStore;
import plan.org.h2.mvstore.MVMap;
import plan.org.h2.mvstore.Page;
import plan.org.h2.mvstore.RootReference;
import plan.org.h2.mvstore.WriteBuffer;
import plan.org.h2.mvstore.cache.CacheLongKeyLIRS;
import plan.org.h2.util.MathUtils;
import plan.org.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int MARKED_FREE = 10000000;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private final int keysPerPage;
    final CacheLongKeyLIRS<Page> cache;
    final CacheLongKeyLIRS<int[]> cacheChunkRef;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final Map<Integer, Chunk> freedPageSpace = new HashMap<Integer, Chunk>();
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private WriteBuffer writeBuffer;
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private long lastStoredVersion = -1L;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile IllegalStateException panicException;
    private long lastTimeAbsolute;
    private long lastFreeUnusedChunks;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> map) {
        Object object;
        int n;
        this.compressionLevel = DataUtils.getConfigParam(map, "compress", 0);
        String string = (String)map.get("fileName");
        FileStore fileStore = (FileStore)map.get("fileStore");
        boolean bl = this.fileStoreIsProvided = fileStore != null;
        if (fileStore == null && string != null) {
            fileStore = new FileStore();
        }
        this.fileStore = fileStore;
        int n2 = 48;
        CacheLongKeyLIRS.Config config = null;
        if (this.fileStore != null) {
            n = DataUtils.getConfigParam(map, "cacheSize", 16);
            if (n > 0) {
                config = new CacheLongKeyLIRS.Config();
                config.maxMemory = (long)n * 1024L * 1024L;
                object = map.get("cacheConcurrency");
                if (object != null) {
                    config.segmentCount = (Integer)object;
                }
            }
            n2 = 16384;
        }
        if (config != null) {
            this.cache = new CacheLongKeyLIRS(config);
            config.maxMemory /= 4L;
            this.cacheChunkRef = new CacheLongKeyLIRS(config);
        } else {
            this.cache = null;
            this.cacheChunkRef = null;
        }
        n2 = DataUtils.getConfigParam(map, "pageSplitSize", n2);
        if (this.cache != null && (long)n2 > this.cache.getMaxItemSize()) {
            n2 = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = n2;
        this.keysPerPage = DataUtils.getConfigParam(map, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)map.get("backgroundExceptionHandler");
        this.meta = new MVMap(this);
        if (this.fileStore != null) {
            String string22;
            this.retentionTime = this.fileStore.getDefaultRetentionTime();
            n = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory(64))) * 1024;
            n = DataUtils.getConfigParam(map, "autoCommitBufferSize", n);
            this.autoCommitMemory = n * 1024;
            this.autoCompactFillRate = DataUtils.getConfigParam(map, "autoCompactFillRate", 40);
            object = (char[])map.get("encryptionKey");
            try {
                if (!this.fileStoreIsProvided) {
                    boolean bl2 = map.containsKey("readOnly");
                    this.fileStore.open(string, bl2, (char[])object);
                }
                if (this.fileStore.size() == 0L) {
                    this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                    this.storeHeader.put("H", 2);
                    this.storeHeader.put("blockSize", 4096);
                    this.storeHeader.put("format", 1);
                    this.storeHeader.put("created", this.creationTime);
                    this.writeStoreHeader();
                } else {
                    this.readStoreHeader();
                }
            }
            catch (IllegalStateException illegalStateException) {
                this.panic(illegalStateException);
            }
            finally {
                if (object != null) {
                    Arrays.fill((char[])object, '\u0000');
                }
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            HashSet<String> hashSet = new HashSet<String>();
            Iterator<String> iterator = this.meta.keyIterator("root.");
            while (iterator.hasNext() && (string22 = iterator.next()).startsWith("root.")) {
                String string3 = string22.substring(string22.lastIndexOf(46) + 1);
                if (this.meta.containsKey("map." + string3)) continue;
                hashSet.add(string22);
            }
            for (String string22 : hashSet) {
                this.meta.remove(string22);
                this.markMetaChanged();
            }
            int n3 = DataUtils.getConfigParam(map, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(n3);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
        }
    }

    private void panic(IllegalStateException illegalStateException) {
        if (this.isOpen()) {
            this.handleException(illegalStateException);
            this.panicException = illegalStateException;
            this.closeImmediately();
        }
        throw illegalStateException;
    }

    public IllegalStateException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("fileName", string);
        return new MVStore(hashMap);
    }

    long getRootPos(int n, long l) {
        MVMap<String, String> mVMap = this.getMetaMap(l);
        return MVStore.getRootPos(mVMap, n);
    }

    public <K, V> MVMap<K, V> openMap(String string) {
        return this.openMap(string, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String string, MVMap.MapBuilder<M, K, V> mapBuilder) {
        Object object;
        int n = this.getMapId(string);
        if (n >= 0) {
            object = this.openMap(n, mapBuilder);
            assert (mapBuilder.getKeyType() == null || ((MVMap)object).getKeyType().getClass().equals(mapBuilder.getKeyType().getClass()));
            assert (mapBuilder.getValueType() == null || ((MVMap)object).getValueType().getClass().equals(mapBuilder.getValueType().getClass()));
        } else {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            n = this.lastMapId.incrementAndGet();
            assert (this.getMap(n) == null);
            hashMap.put("id", n);
            hashMap.put("createVersion", this.currentVersion);
            object = mapBuilder.create(this, hashMap);
            String string2 = Integer.toHexString(n);
            this.meta.put(MVMap.getMapKey(n), ((MVMap)object).asString(string));
            this.meta.put("name." + string, string2);
            ((MVMap)object).setRootPos(0L, this.lastStoredVersion);
            this.markMetaChanged();
            MVMap<?, ?> mVMap = this.maps.putIfAbsent(n, (MVMap<?, ?>)object);
            if (mVMap != null) {
                object = mVMap;
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends MVMap<K, V>, K, V> M openMap(int n, MVMap.MapBuilder<M, K, V> mapBuilder) {
        this.storeLock.lock();
        try {
            Object object;
            MVMap<K, V> mVMap = this.getMap(n);
            if (mVMap == null) {
                object = this.meta.get(MVMap.getMapKey(n));
                HashMap<String, Object> hashMap = object != null ? new HashMap<String, String>(DataUtils.parseMap((String)object)) : new HashMap<String, Integer>();
                hashMap.put("id", n);
                mVMap = mapBuilder.create(this, hashMap);
                long l = MVStore.getRootPos(this.meta, n);
                mVMap.setRootPos(l, this.lastStoredVersion);
                this.maps.put(n, mVMap);
            }
            object = mVMap;
            return (M)object;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public <K, V> MVMap<K, V> getMap(int n) {
        this.checkOpen();
        MVMap<?, ?> mVMap = this.maps.get(n);
        return mVMap;
    }

    public Set<String> getMapNames() {
        String string;
        HashSet<String> hashSet = new HashSet<String>();
        this.checkOpen();
        Iterator<String> iterator = this.meta.keyIterator("name.");
        while (iterator.hasNext() && (string = iterator.next()).startsWith("name.")) {
            String string2 = string.substring("name.".length());
            hashSet.add(string2);
        }
        return hashSet;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long l) {
        Chunk chunk = this.getChunkForVersion(l);
        DataUtils.checkArgument(chunk != null, "Unknown version {0}", l);
        chunk = this.readChunkHeader(chunk.block);
        MVMap<String, String> mVMap = this.meta.openReadOnly(chunk.metaRootPos, l);
        return mVMap;
    }

    private Chunk getChunkForVersion(long l) {
        Chunk chunk = null;
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.version > l || chunk != null && chunk2.id <= chunk.id) continue;
            chunk = chunk2;
        }
        return chunk;
    }

    public boolean hasMap(String string) {
        return this.meta.containsKey("name." + string);
    }

    public boolean hasData(String string) {
        return this.hasMap(string) && MVStore.getRootPos(this.meta, this.getMapId(string)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        long l;
        Object object;
        long l2;
        Chunk chunk = null;
        boolean bl = false;
        ByteBuffer byteBuffer = this.fileStore.readFully(0L, 8192);
        byte[] byArray = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            byteBuffer.get(byArray);
            try {
                HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
                if (hashMap == null) continue;
                int n = DataUtils.readHexInt(hashMap, "blockSize", 4096);
                if (n != 4096) {
                    throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", n);
                }
                long l3 = DataUtils.readHexLong(hashMap, "version", 0L);
                if (chunk != null && l3 <= chunk.version) continue;
                bl = true;
                this.storeHeader.putAll(hashMap);
                this.creationTime = DataUtils.readHexLong(hashMap, "created", 0L);
                int n2 = DataUtils.readHexInt(hashMap, "chunk", 0);
                l2 = DataUtils.readHexLong(hashMap, "block", 0L);
                object = this.readChunkHeaderAndFooter(l2);
                if (object == null || ((Chunk)object).id != n2) continue;
                chunk = object;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!bl) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        long l4 = DataUtils.readHexLong(this.storeHeader, "format", 1L);
        if (l4 > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", l4, 1);
        }
        if ((l4 = DataUtils.readHexLong(this.storeHeader, "formatRead", l4)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", l4, 1);
        }
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long l5 = System.currentTimeMillis();
        int n = 1970 + (int)(l5 / 31557600000L);
        if (n < 2014) {
            this.creationTime = l5 - (long)this.fileStore.getDefaultRetentionTime();
        } else if (l5 < this.creationTime) {
            this.creationTime = l5;
            this.storeHeader.put("created", this.creationTime);
        }
        Chunk chunk2 = this.readChunkFooter(this.fileStore.size());
        if (chunk2 != null && (chunk2 = this.readChunkHeaderAndFooter(chunk2.block)) != null && (chunk == null || chunk2.version > chunk.version)) {
            chunk = chunk2;
        }
        l2 = this.fileStore.size() / 4096L;
        object = new PriorityQueue<Chunk>(Math.max(32, (int)(l2 / 4L)), new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                int n = Long.compare(chunk2.version, chunk.version);
                if (n == 0) {
                    n = Long.compare(chunk.block, chunk2.block);
                }
                return n;
            }
        });
        HashMap<Long, Chunk> hashMap = new HashMap<Long, Chunk>();
        if (chunk != null) {
            while (true) {
                hashMap.put(chunk.block, chunk);
                object.add(chunk);
                if (chunk.next == 0L || chunk.next >= l2 || (chunk2 = this.readChunkHeaderAndFooter(chunk.next)) == null || chunk2.id <= chunk.id) break;
                chunk = chunk2;
            }
        }
        boolean bl2 = false;
        while (!bl2 && this.setLastChunk((Chunk)object.poll()) != null) {
            bl2 = true;
            Iterator<Chunk> iterator = this.meta.cursor("chunk.");
            while (((Cursor)iterator).hasNext() && ((String)((Cursor)iterator).next()).startsWith("chunk.")) {
                Chunk chunk3 = Chunk.fromString((String)((Cursor)iterator).getValue());
                assert (chunk3.version <= this.currentVersion);
                this.chunks.putIfAbsent(chunk3.id, chunk3);
                l = chunk3.block;
                chunk2 = (Chunk)hashMap.get(l);
                if (chunk2 == null) {
                    chunk2 = this.readChunkHeaderAndFooter(l);
                    if (chunk2 != null && chunk2.id == chunk3.id) {
                        hashMap.put(l, chunk2);
                        object.offer(chunk2);
                        continue;
                    }
                } else if (chunk2.id == chunk3.id) continue;
                bl2 = false;
            }
        }
        this.fileStore.clear();
        for (Chunk chunk3 : this.chunks.values()) {
            l = chunk3.block * 4096L;
            int n3 = chunk3.len * 4096;
            this.fileStore.markUsed(l, n3);
        }
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
        this.setWriteVersion(this.currentVersion);
        if (this.lastStoredVersion == -1L) {
            this.lastStoredVersion = this.currentVersion - 1L;
        }
    }

    private Chunk setLastChunk(Chunk chunk) {
        this.chunks.clear();
        this.lastChunk = chunk;
        if (chunk == null) {
            this.lastMapId.set(0);
            this.currentVersion = 0L;
            this.lastStoredVersion = -1L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId.set(chunk.mapId);
            this.currentVersion = chunk.version;
            this.chunks.put(chunk.id, chunk);
            this.lastStoredVersion = this.currentVersion - 1L;
            this.meta.setRootPos(chunk.metaRootPos, this.lastStoredVersion);
        }
        return chunk;
    }

    private Chunk readChunkHeaderAndFooter(long l) {
        Chunk chunk;
        try {
            chunk = this.readChunkHeader(l);
        }
        catch (Exception exception) {
            return null;
        }
        if (chunk == null) {
            return null;
        }
        Chunk chunk2 = this.readChunkFooter((l + (long)chunk.len) * 4096L);
        if (chunk2 == null || chunk2.id != chunk.id) {
            return null;
        }
        return chunk;
    }

    private Chunk readChunkFooter(long l) {
        try {
            long l2 = l - 128L;
            if (l2 < 0L) {
                return null;
            }
            ByteBuffer byteBuffer = this.fileStore.readFully(l2, 128);
            byte[] byArray = new byte[128];
            byteBuffer.get(byArray);
            HashMap<String, String> hashMap = DataUtils.parseChecksummedMap(byArray);
            if (hashMap != null) {
                int n = DataUtils.readHexInt(hashMap, "chunk", 0);
                Chunk chunk = new Chunk(n);
                chunk.version = DataUtils.readHexLong(hashMap, "version", 0L);
                chunk.block = DataUtils.readHexLong(hashMap, "block", 0L);
                return chunk;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder stringBuilder = new StringBuilder(112);
        if (this.lastChunk != null) {
            this.storeHeader.put("block", this.lastChunk.block);
            this.storeHeader.put("chunk", this.lastChunk.id);
            this.storeHeader.put("version", this.lastChunk.version);
        }
        DataUtils.appendMap(stringBuilder, this.storeHeader);
        byte[] byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        int n = DataUtils.getFletcher32(byArray, 0, byArray.length);
        DataUtils.appendMap(stringBuilder, "fletcher", n);
        stringBuilder.append('\n');
        byArray = stringBuilder.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer byteBuffer = ByteBuffer.allocate(8192);
        byteBuffer.put(byArray);
        byteBuffer.position(4096);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        this.write(0L, byteBuffer);
    }

    private void write(long l, ByteBuffer byteBuffer) {
        try {
            this.fileStore.writeFully(l, byteBuffer);
        }
        catch (IllegalStateException illegalStateException) {
            this.panic(illegalStateException);
        }
    }

    @Override
    public void close() {
        this.closeStore(true);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false);
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean bl) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(bl);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (bl && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> mVMap : this.maps.values()) {
                                if (!mVMap.isClosed() || this.meta.remove(MVMap.getMapRootKey(mVMap.getId())) == null) continue;
                                this.markMetaChanged();
                            }
                            this.commit();
                            this.shrinkFileIfPossible(0);
                        }
                        this.state = 2;
                        if (this.cache != null) {
                            this.cache.clear();
                        }
                        if (this.cacheChunkRef != null) {
                            this.cacheChunkRef.clear();
                        }
                        for (MVMap<?, ?> mVMap : new ArrayList(this.maps.values())) {
                            mVMap.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || this.fileStoreIsProvided) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    ByteBuffer readBufferForPage(long l, int n) {
        int n2;
        ByteBuffer byteBuffer;
        Chunk chunk = this.getChunk(l);
        long l2 = chunk.block * 4096L;
        if ((l2 += (long)DataUtils.getPageOffset(l)) < 0L) {
            throw DataUtils.newIllegalStateException(6, "Negative position {0}; p={1}, c={2}", l2, l, chunk.toString());
        }
        long l3 = (chunk.block + (long)chunk.len) * 4096L;
        int n3 = DataUtils.getPageMaxLength(l);
        if (n3 == 0x200000) {
            byteBuffer = this.fileStore.readFully(l2, 128);
            n3 = byteBuffer.getInt();
        }
        if ((n2 = (n3 = (int)Math.min(l3 - l2, (long)n3))) < 0) {
            throw DataUtils.newIllegalStateException(6, "Illegal page length {0} reading at {1}; max pos {2} ", n2, l2, l3);
        }
        byteBuffer = this.fileStore.readFully(l2, n2);
        int n4 = DataUtils.getPageChunkId(l);
        int n5 = DataUtils.getPageOffset(l);
        int n6 = byteBuffer.position();
        int n7 = byteBuffer.remaining();
        int n8 = byteBuffer.getInt();
        if (n8 > n7 || n8 < 4) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected page length 4..{1}, got {2}", n4, n7, n8);
        }
        byteBuffer.limit(n6 + n8);
        short s = byteBuffer.getShort();
        int n9 = DataUtils.readVarInt(byteBuffer);
        if (n9 != n) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected map id {1}, got {2}", n4, n, n9);
        }
        int n10 = DataUtils.getCheckValue(n4) ^ DataUtils.getCheckValue(n5) ^ DataUtils.getCheckValue(n8);
        if (s != (short)n10) {
            throw DataUtils.newIllegalStateException(6, "File corrupted in chunk {0}, expected check value {1}, got {2}", n4, n10, s);
        }
        return byteBuffer;
    }

    private Chunk getChunk(long l) {
        int n = DataUtils.getPageChunkId(l);
        Chunk chunk = this.chunks.get(n);
        if (chunk == null) {
            this.checkOpen();
            String string = this.meta.get(Chunk.getMetaKey(n));
            if (string == null) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} not found", n);
            }
            chunk = Chunk.fromString(string);
            if (chunk.block == Long.MAX_VALUE) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", n);
            }
            this.chunks.put(chunk.id, chunk);
        }
        return chunk;
    }

    private void setWriteVersion(long l) {
        Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            MVMap<?, ?> mVMap = iterator.next();
            if (mVMap.setWriteVersion(l) != null) continue;
            assert (mVMap.isClosed());
            assert (mVMap.getVersion() < this.getOldestVersionToKeep());
            this.meta.remove(MVMap.getMapRootKey(mVMap.getId()));
            this.markMetaChanged();
            iterator.remove();
        }
        this.meta.setWriteVersion(l);
        this.onVersionChange(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long tryCommit() {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long commit() {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store() {
        try {
            if (this.isOpenOrStopping() && this.hasUnsavedChangesInternal()) {
                this.currentStoreVersion = this.currentVersion;
                if (this.fileStore == null) {
                    this.lastStoredVersion = this.currentVersion++;
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
                    }
                    try {
                        this.storeNow();
                    }
                    catch (IllegalStateException illegalStateException) {
                        this.panic(illegalStateException);
                    }
                    catch (Throwable throwable) {
                        this.panic(DataUtils.newIllegalStateException(3, throwable.toString(), throwable));
                    }
                }
            }
        }
        finally {
            this.currentStoreVersion = -1L;
        }
    }

    private void storeNow() {
        boolean bl;
        Page page;
        Object object;
        Serializable serializable;
        Chunk chunk;
        int n;
        assert (this.storeLock.isHeldByCurrentThread());
        long l = this.getTimeSinceCreation();
        this.freeUnusedIfNeeded(l);
        int n2 = this.unsavedMemory;
        long l2 = this.currentStoreVersion;
        long l3 = ++this.currentVersion;
        this.lastCommitTime = l;
        if (this.lastChunk == null) {
            n = 0;
        } else {
            n = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(n), this.lastChunk.asString());
            this.markMetaChanged();
            l = Math.max(this.lastChunk.time, l);
        }
        int n3 = n;
        while ((chunk = this.chunks.get(n3 = n3 + 1 & 0x3FFFFFF)) != null) {
            if (chunk.block != Long.MAX_VALUE) continue;
            serializable = DataUtils.newIllegalStateException(3, "Last block {0} not stored, possibly due to out-of-memory", chunk);
            this.panic((IllegalStateException)serializable);
        }
        chunk = new Chunk(n3);
        chunk.pageCount = Integer.MAX_VALUE;
        chunk.pageCountLive = Integer.MAX_VALUE;
        chunk.maxLen = Long.MAX_VALUE;
        chunk.maxLenLive = Long.MAX_VALUE;
        chunk.metaRootPos = Long.MAX_VALUE;
        chunk.block = Long.MAX_VALUE;
        chunk.len = Integer.MAX_VALUE;
        chunk.time = l;
        chunk.version = l3;
        chunk.mapId = this.lastMapId.get();
        chunk.next = Long.MAX_VALUE;
        this.chunks.put(chunk.id, chunk);
        serializable = new ArrayList();
        Object object2 = this.maps.values().iterator();
        while (object2.hasNext()) {
            MVMap<?, ?> mVMap = object2.next();
            object = mVMap.setWriteVersion(l3);
            if (object == null) {
                assert (mVMap.isClosed());
                assert (mVMap.getVersion() < this.getOldestVersionToKeep());
                this.meta.remove(MVMap.getMapRootKey(mVMap.getId()));
                object2.remove();
                continue;
            }
            if (mVMap.getCreateVersion() > l2 || mVMap.isVolatile() || !mVMap.hasChangesSince(this.lastStoredVersion)) continue;
            assert (((RootReference)object).version <= l3) : ((RootReference)object).version + " > " + l3;
            page = ((RootReference)object).root;
            if (page.isSaved() && !page.isLeaf()) continue;
            ((ArrayList)serializable).add(page);
        }
        object2 = this.getWriteBuffer();
        chunk.writeChunkHeader((WriteBuffer)object2, 0);
        int n4 = ((WriteBuffer)object2).position();
        chunk.pageCount = 0;
        chunk.pageCountLive = 0;
        chunk.maxLen = 0L;
        chunk.maxLenLive = 0L;
        object = ((ArrayList)serializable).iterator();
        while (object.hasNext()) {
            page = (Page)object.next();
            String string = MVMap.getMapRootKey(page.getMapId());
            if (page.getTotalCount() == 0L) {
                this.meta.remove(string);
                continue;
            }
            page.writeUnsavedRecursive(chunk, (WriteBuffer)object2);
            long l4 = page.getPos();
            this.meta.put(string, Long.toHexString(l4));
        }
        this.applyFreedSpace();
        object = this.meta.setWriteVersion(l3);
        assert (object != null);
        assert (((RootReference)object).version == l3) : ((RootReference)object).version + " != " + l3;
        this.metaChanged = false;
        this.onVersionChange(l3);
        page = ((RootReference)object).root;
        page.writeUnsavedRecursive(chunk, (WriteBuffer)object2);
        int n5 = ((WriteBuffer)object2).position();
        int n6 = MathUtils.roundUpInt(n5 + 128, 4096);
        ((WriteBuffer)object2).limit(n6);
        long l5 = this.allocateFileSpace(n6, !this.reuseSpace);
        chunk.block = l5 / 4096L;
        chunk.len = n6 / 4096;
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + chunk;
        chunk.metaRootPos = page.getPos();
        chunk.next = this.reuseSpace ? this.fileStore.predictAllocation(chunk.len * 4096) / 4096L : 0L;
        ((WriteBuffer)object2).position(0);
        chunk.writeChunkHeader((WriteBuffer)object2, n4);
        ((WriteBuffer)object2).position(((WriteBuffer)object2).limit() - 128);
        ((WriteBuffer)object2).put(chunk.getFooterBytes());
        ((WriteBuffer)object2).position(0);
        this.write(l5, ((WriteBuffer)object2).getBuffer());
        this.releaseWriteBuffer((WriteBuffer)object2);
        boolean bl2 = false;
        boolean bl3 = bl = l5 + (long)n6 >= this.fileStore.size();
        if (!bl) {
            if (this.lastChunk == null) {
                bl2 = true;
            } else if (this.lastChunk.next != chunk.block) {
                bl2 = true;
            } else {
                long l6 = DataUtils.readHexLong(this.storeHeader, "version", 0L);
                if (this.lastChunk.version - l6 > 20L) {
                    bl2 = true;
                } else {
                    int n7 = DataUtils.readHexInt(this.storeHeader, "chunk", 0);
                    while (true) {
                        Chunk chunk2;
                        if ((chunk2 = this.chunks.get(n7)) == null) {
                            bl2 = true;
                            break;
                        }
                        if (n7 == this.lastChunk.id) break;
                        ++n7;
                    }
                }
            }
        }
        this.lastChunk = chunk;
        if (bl2) {
            this.writeStoreHeader();
        }
        if (!bl) {
            this.shrinkFileIfPossible(1);
        }
        Iterator iterator = ((ArrayList)serializable).iterator();
        while (iterator.hasNext()) {
            Page page2 = (Page)iterator.next();
            page2.writeEnd();
        }
        page.writeEnd();
        this.unsavedMemory = Math.max(0, this.unsavedMemory - n2);
        this.lastStoredVersion = l2;
    }

    private void freeUnusedIfNeeded(long l) {
        int n = this.retentionTime / 5;
        if (l - this.lastFreeUnusedChunks >= (long)n) {
            this.lastFreeUnusedChunks = l;
            this.freeUnusedChunks(true);
        }
    }

    private void freeUnusedChunks(boolean bl) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (this.lastChunk != null && this.reuseSpace) {
            Set<Integer> set = this.collectReferencedChunks(bl);
            long l = this.getTimeSinceCreation();
            Iterator<Chunk> iterator = this.chunks.values().iterator();
            while (iterator.hasNext()) {
                Chunk chunk = iterator.next();
                if (chunk.block == Long.MAX_VALUE || set.contains(chunk.id)) continue;
                if (this.canOverwriteChunk(chunk, l)) {
                    iterator.remove();
                    if (this.meta.remove(Chunk.getMetaKey(chunk.id)) != null) {
                        this.markMetaChanged();
                    }
                    long l2 = chunk.block * 4096L;
                    int n = chunk.len * 4096;
                    this.fileStore.free(l2, n);
                    assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
                    continue;
                }
                if (chunk.unused != 0L) continue;
                chunk.unused = l;
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
                this.markMetaChanged();
            }
            this.lastFreeUnusedChunks = this.getTimeSinceCreation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Integer> collectReferencedChunks(boolean bl) {
        assert (this.lastChunk != null);
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(10, 10, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.keysPerPage + 1));
        AtomicInteger atomicInteger = new AtomicInteger();
        try {
            Set<Integer> set;
            ChunkIdsCollector chunkIdsCollector = new ChunkIdsCollector(this.meta.getId());
            long l = this.getOldestVersionToKeep();
            Object object = this.meta.flushAndGetRoot();
            if (bl) {
                while (((RootReference)object).version >= l && (set = ((RootReference)object).previous) != null) {
                    object = set;
                }
                this.inspectVersion((RootReference)object, chunkIdsCollector, threadPoolExecutor, atomicInteger, null);
                Page page = ((RootReference)object).root;
                long l2 = page.getPos();
                assert (page.isSaved());
                int n = DataUtils.getPageChunkId(l2);
                while (++n <= this.lastChunk.id) {
                    chunkIdsCollector.registerChunk(n);
                }
            } else {
                set = new HashSet();
                do {
                    this.inspectVersion((RootReference)object, chunkIdsCollector, threadPoolExecutor, atomicInteger, (Set<Long>)set);
                } while (((RootReference)object).version >= l && (object = ((RootReference)object).previous) != null);
            }
            set = chunkIdsCollector.getReferenced();
            return set;
        }
        finally {
            threadPoolExecutor.shutdownNow();
        }
    }

    private void inspectVersion(RootReference rootReference, ChunkIdsCollector chunkIdsCollector, ThreadPoolExecutor threadPoolExecutor, AtomicInteger atomicInteger, Set<Long> set) {
        String string;
        Page page = rootReference.root;
        long l = page.getPos();
        if (page.isSaved()) {
            if (set != null && !set.add(l)) {
                return;
            }
            chunkIdsCollector.setMapId(this.meta.getId());
            chunkIdsCollector.visit(l, threadPoolExecutor, atomicInteger);
        }
        Cursor cursor = new Cursor(page, "root.");
        while (cursor.hasNext() && (string = cursor.next()).startsWith("root.")) {
            l = DataUtils.parseHexLong((String)cursor.getValue());
            if (!DataUtils.isPageSaved(l) || set != null && !set.add(l)) continue;
            int n = DataUtils.parseHexInt(string.substring(string.lastIndexOf(46) + 1));
            chunkIdsCollector.setMapId(n);
            chunkIdsCollector.visit(l, threadPoolExecutor, atomicInteger);
        }
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer writeBuffer;
        if (this.writeBuffer != null) {
            writeBuffer = this.writeBuffer;
            writeBuffer.clear();
        } else {
            writeBuffer = new WriteBuffer();
        }
        return writeBuffer;
    }

    private void releaseWriteBuffer(WriteBuffer writeBuffer) {
        if (writeBuffer.capacity() <= 0x400000) {
            this.writeBuffer = writeBuffer;
        }
    }

    private boolean canOverwriteChunk(Chunk chunk, long l) {
        if (this.retentionTime >= 0) {
            if (chunk.time + (long)this.retentionTime > l) {
                return false;
            }
            if (chunk.unused == 0L || chunk.unused + (long)(this.retentionTime / 2) > l) {
                return false;
            }
        }
        return true;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long l = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && l < this.lastTimeAbsolute) {
            l = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = l;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyFreedSpace() {
        while (true) {
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            Map<Integer, Chunk> map = this.freedPageSpace;
            synchronized (map) {
                for (Chunk chunk : this.freedPageSpace.values()) {
                    Chunk chunk2 = this.chunks.get(chunk.id);
                    if (chunk2 == null) continue;
                    chunk2.maxLenLive += chunk.maxLenLive;
                    chunk2.pageCountLive += chunk.pageCountLive;
                    if (chunk2.pageCountLive < 0 && chunk2.pageCountLive > -10000000) {
                        chunk2.pageCountLive = 0;
                    }
                    if (chunk2.maxLenLive < 0L && chunk2.maxLenLive > -10000000L) {
                        chunk2.maxLenLive = 0L;
                    }
                    arrayList.add(chunk2);
                }
                this.freedPageSpace.clear();
            }
            if (arrayList.isEmpty()) break;
            for (Chunk chunk : arrayList) {
                this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
            }
            this.markMetaChanged();
        }
    }

    private void shrinkFileIfPossible(int n) {
        long l;
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long l2 = this.getFileLengthInUse();
        if (l2 >= (l = this.fileStore.size())) {
            return;
        }
        if (n > 0 && l - l2 < 4096L) {
            return;
        }
        int n2 = (int)(100L - l2 * 100L / l);
        if (n2 < n) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(l2);
    }

    private long getFileLengthInUse() {
        long l = this.fileStore.getFileLengthInUse();
        assert (l == this.measureFileLengthInUse()) : l + " != " + this.measureFileLengthInUse();
        return l;
    }

    private long measureFileLengthInUse() {
        long l = 2L;
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.len == Integer.MAX_VALUE) continue;
            l = Math.max(l, chunk.block + (long)chunk.len);
        }
        return l * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            if (mVMap.isClosed() || !mVMap.hasChangesSince(this.lastStoredVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean hasUnsavedChangesInternal() {
        if (this.meta.hasChangesSince(this.lastStoredVersion)) {
            return true;
        }
        return this.hasUnsavedChanges();
    }

    private Chunk readChunkHeader(long l) {
        long l2 = l * 4096L;
        ByteBuffer byteBuffer = this.fileStore.readFully(l2, 1024);
        return Chunk.readChunkHeader(byteBuffer, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compactRewriteFully() {
        this.storeLock.lock();
        try {
            this.checkOpen();
            if (this.lastChunk == null) {
                boolean bl = false;
                return bl;
            }
            Iterator<MVMap<?, ?>> iterator = this.maps.values().iterator();
            while (iterator.hasNext()) {
                MVMap<?, ?> mVMap;
                MVMap<?, ?> mVMap2 = mVMap = iterator.next();
                Cursor<Object, ?> cursor = mVMap2.cursor(null);
                Page page = null;
                while (cursor.hasNext()) {
                    cursor.next();
                    Page page2 = cursor.getPage();
                    if (page2 == page) continue;
                    Object object = page2.getKey(0);
                    Object object2 = page2.getValue(0);
                    mVMap2.put(object, object2);
                    page = page2;
                }
            }
            this.commit();
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactMoveChunks(int n, long l) {
        block7: {
            this.storeLock.lock();
            try {
                this.checkOpen();
                if (this.lastChunk == null || !this.reuseSpace) break block7;
                int n2 = this.retentionTime;
                boolean bl = this.reuseSpace;
                try {
                    this.retentionTime = -1;
                    this.freeUnusedChunks(false);
                    if (this.fileStore.getFillRate() <= n) {
                        long l2 = this.fileStore.getFirstFree() / 4096L;
                        ArrayList<Chunk> arrayList = this.findChunksToMove(l2, l);
                        this.compactMoveChunks(arrayList);
                    }
                }
                finally {
                    this.reuseSpace = bl;
                    this.retentionTime = n2;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private ArrayList<Chunk> findChunksToMove(long l, long l2) {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        for (Chunk chunk : this.chunks.values()) {
            if (chunk.block <= l) continue;
            arrayList.add(chunk);
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                return Long.signum(chunk.block - chunk2.block);
            }
        });
        int n = 0;
        long l3 = 0L;
        for (Chunk chunk : arrayList) {
            long l4 = (long)chunk.len * 4096L;
            if ((l3 += l4) > l2) break;
            ++n;
        }
        while (arrayList.size() > n && arrayList.size() > 1) {
            arrayList.remove(1);
        }
        return arrayList;
    }

    private void compactMoveChunks(ArrayList<Chunk> arrayList) {
        for (Chunk object : arrayList) {
            this.moveChunk(object, true);
        }
        this.reuseSpace = false;
        this.commit();
        this.sync();
        Chunk chunk = this.lastChunk;
        this.reuseSpace = true;
        for (Chunk chunk2 : arrayList) {
            if (!this.chunks.containsKey(chunk2.id)) continue;
            this.moveChunk(chunk2, false);
        }
        this.commit();
        this.sync();
        if (this.chunks.containsKey(chunk.id)) {
            this.moveChunk(chunk, false);
            this.commit();
        }
        this.shrinkFileIfPossible(0);
        this.sync();
    }

    private void moveChunk(Chunk chunk, boolean bl) {
        WriteBuffer writeBuffer = this.getWriteBuffer();
        long l = chunk.block * 4096L;
        int n = chunk.len * 4096;
        writeBuffer.limit(n);
        ByteBuffer byteBuffer = this.fileStore.readFully(l, n);
        Chunk.readChunkHeader(byteBuffer, l);
        int n2 = byteBuffer.position();
        writeBuffer.position(n2);
        writeBuffer.put(byteBuffer);
        long l2 = this.allocateFileSpace(n, bl);
        this.fileStore.free(l, n);
        chunk.block = l2 / 4096L;
        chunk.next = 0L;
        writeBuffer.position(0);
        chunk.writeChunkHeader(writeBuffer, n2);
        writeBuffer.position(n - 128);
        writeBuffer.put(chunk.getFooterBytes());
        writeBuffer.position(0);
        this.write(l2, writeBuffer.getBuffer());
        this.releaseWriteBuffer(writeBuffer);
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.markMetaChanged();
    }

    private long allocateFileSpace(int n, boolean bl) {
        long l;
        if (bl) {
            l = this.getFileLengthInUse();
            this.fileStore.markUsed(l, n);
        } else {
            l = this.fileStore.allocate(n);
        }
        return l;
    }

    public void sync() {
        this.checkOpen();
        FileStore fileStore = this.fileStore;
        if (fileStore != null) {
            fileStore.sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(int n, int n2) {
        if (!this.reuseSpace) {
            return false;
        }
        this.checkOpen();
        try {
            if (this.storeLock.isHeldByCurrentThread()) return false;
            if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) return false;
            try {
                ArrayList<Chunk> arrayList = this.findOldChunks(n, n2);
                if (arrayList == null || arrayList.isEmpty()) {
                    boolean bl = false;
                    return bl;
                }
                this.compactRewrite(arrayList);
                boolean bl = true;
                return bl;
            }
            finally {
                this.storeLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            throw new RuntimeException(interruptedException);
        }
    }

    public int getCurrentFillRate() {
        long l = 1L;
        long l2 = 1L;
        long l3 = this.getTimeSinceCreation();
        for (Chunk chunk : this.chunks.values()) {
            l += chunk.maxLen;
            if (chunk.time + (long)this.retentionTime > l3) {
                l2 += chunk.maxLen;
                continue;
            }
            l2 += chunk.maxLenLive;
        }
        if (l <= 0L) {
            l = 1L;
        }
        int n = (int)(100L * l2 / l);
        return n;
    }

    private ArrayList<Chunk> findOldChunks(int n, int n2) {
        if (this.lastChunk == null) {
            return null;
        }
        long l = this.getTimeSinceCreation();
        int n3 = this.getCurrentFillRate();
        if (n3 >= n) {
            return null;
        }
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        Chunk chunk = this.chunks.get(this.lastChunk.id);
        for (Chunk chunk2 : this.chunks.values()) {
            if (chunk2.time + (long)this.retentionTime > l) continue;
            long l2 = chunk.version - chunk2.version + 1L;
            chunk2.collectPriority = (int)((long)(chunk2.getFillRate() * 1000) / Math.max(1L, l2));
            arrayList.add(chunk2);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        Collections.sort(arrayList, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk chunk, Chunk chunk2) {
                int n = Integer.compare(chunk.collectPriority, chunk2.collectPriority);
                if (n == 0) {
                    n = Long.compare(chunk.maxLenLive, chunk2.maxLenLive);
                }
                return n;
            }
        });
        long l3 = 0L;
        int n4 = 0;
        Chunk object2 = null;
        for (Chunk object3 : arrayList) {
            if (object2 != null && object3.collectPriority > 0 && l3 > (long)n2) break;
            l3 += object3.maxLenLive;
            ++n4;
            object2 = object3;
        }
        if (n4 < 1) {
            return null;
        }
        boolean bl = false;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Chunk chunk2 = (Chunk)iterator.next();
            if (object2 == chunk2) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            iterator.remove();
        }
        return arrayList;
    }

    private void compactRewrite(Iterable<Chunk> iterable) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Chunk object : iterable) {
            hashSet.add(object.id);
        }
        for (MVMap mVMap : this.maps.values()) {
            MVMap mVMap2 = mVMap;
            if (mVMap2.isClosed()) continue;
            mVMap2.rewrite(hashSet);
        }
        this.meta.rewrite(hashSet);
        this.freeUnusedChunks(false);
        this.commit();
    }

    Page readPage(MVMap<?, ?> mVMap, long l) {
        Page page;
        if (!DataUtils.isPageSaved(l)) {
            throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
        }
        Page page2 = page = this.cache == null ? null : this.cache.get(l);
        if (page == null) {
            ByteBuffer byteBuffer = this.readBufferForPage(l, mVMap.getId());
            page = Page.read(byteBuffer, l, mVMap);
            this.cachePage(page);
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePage(long l, int n) {
        if (!DataUtils.isPageSaved(l)) {
            this.unsavedMemory = Math.max(0, this.unsavedMemory - n);
            return;
        }
        int n2 = DataUtils.getPageChunkId(l);
        Map<Integer, Chunk> map = this.freedPageSpace;
        synchronized (map) {
            Chunk chunk = this.freedPageSpace.get(n2);
            if (chunk == null) {
                chunk = new Chunk(n2);
                this.freedPageSpace.put(n2, chunk);
            }
            chunk.maxLenLive -= (long)DataUtils.getPageMaxLength(l);
            --chunk.pageCountLive;
        }
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean bl) {
        this.reuseSpace = bl;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int n) {
        this.retentionTime = n;
    }

    public void setVersionsToKeep(int n) {
        this.versionsToKeep = n;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    public long getOldestVersionToKeep() {
        long l = this.oldestVersionToKeep.get();
        if (this.fileStore == null) {
            l = Math.max(l - (long)this.versionsToKeep + 1L, -1L);
            return l;
        }
        long l2 = this.currentStoreVersion;
        if (l2 != -1L && l2 < l) {
            l = l2;
        }
        return l;
    }

    private void setOldestVersionToKeep(long l) {
        long l2;
        boolean bl;
        while (!(bl = l <= (l2 = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(l2, l))) {
        }
    }

    private boolean isKnownVersion(long l) {
        if (l > this.currentVersion || l < 0L) {
            return false;
        }
        if (l == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk chunk = this.getChunkForVersion(l);
        if (chunk == null) {
            return false;
        }
        MVMap<String, String> mVMap = this.getMetaMap(l);
        if (mVMap == null) {
            return false;
        }
        try {
            String string;
            Iterator<String> iterator = mVMap.keyIterator("chunk.");
            while (iterator.hasNext() && (string = iterator.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(string)) continue;
                String string2 = mVMap.get(string);
                Chunk chunk2 = Chunk.fromString(string2);
                Chunk chunk3 = this.readChunkHeaderAndFooter(chunk2.block);
                if (chunk3 != null && chunk3.id == chunk2.id) continue;
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
        return true;
    }

    public void registerUnsavedPage(int n) {
        this.unsavedMemory += n;
        int n2 = this.unsavedMemory;
        if (n2 > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    public boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> mVMap) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping()) {
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                if (3 * this.unsavedMemory > 4 * this.autoCommitMemory) {
                    this.commit();
                } else {
                    this.tryCommit();
                }
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String string = this.meta.get("setting.storeVersion");
        return string == null ? 0 : DataUtils.parseHexInt(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStoreVersion(int n) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(n));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long l) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            if (l == 0L) {
                for (MVMap<?, ?> mVMap : this.maps.values()) {
                    mVMap.close();
                }
                this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                this.chunks.clear();
                if (this.fileStore != null) {
                    this.fileStore.clear();
                }
                this.maps.clear();
                this.lastChunk = null;
                Map<Integer, Chunk> map = this.freedPageSpace;
                synchronized (map) {
                    this.freedPageSpace.clear();
                }
                this.versions.clear();
                this.currentVersion = l;
                this.setWriteVersion(l);
                this.metaChanged = false;
                this.lastStoredVersion = -1L;
                return;
            }
            DataUtils.checkArgument(this.isKnownVersion(l), "Unknown version {0}", l);
            Object object = this.maps.values().iterator();
            while (object.hasNext()) {
                MVMap<?, ?> mVMap = object.next();
                mVMap.rollbackTo(l);
            }
            while ((object = this.versions.peekLast()) != null && ((TxCounter)object).version >= l) {
                this.versions.removeLast();
            }
            this.currentTxCounter = new TxCounter(l);
            this.meta.rollbackTo(l);
            this.metaChanged = false;
            boolean bl = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Chunk chunk = null;
            for (Chunk object2 : this.chunks.values()) {
                if (object2.version > l) {
                    arrayList.add(object2.id);
                    continue;
                }
                if (chunk != null && chunk.id >= object2.id) continue;
                chunk = object2;
            }
            if (!arrayList.isEmpty()) {
                Collections.sort(arrayList, Collections.reverseOrder());
                bl = true;
                Iterator<Object> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    Chunk chunk2 = this.chunks.remove(n);
                    long l2 = chunk2.block * 4096L;
                    int n2 = chunk2.len * 4096;
                    this.fileStore.free(l2, n2);
                    assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse();
                    WriteBuffer writeBuffer = this.getWriteBuffer();
                    writeBuffer.limit(n2);
                    Arrays.fill(writeBuffer.getBuffer().array(), (byte)0);
                    this.write(l2, writeBuffer.getBuffer());
                    this.releaseWriteBuffer(writeBuffer);
                    this.sync();
                }
                this.lastChunk = chunk;
                this.writeStoreHeader();
                this.readStoreHeader();
            }
            for (MVMap mVMap : new ArrayList(this.maps.values())) {
                int n = mVMap.getId();
                if (mVMap.getCreateVersion() >= l) {
                    mVMap.close();
                    this.maps.remove(n);
                    continue;
                }
                if (bl) {
                    mVMap.setRootPos(MVStore.getRootPos(this.meta, n), l);
                    continue;
                }
                mVMap.rollbackRoot(l);
            }
            this.currentVersion = l;
            if (this.lastStoredVersion == -1L) {
                this.lastStoredVersion = this.currentVersion - 1L;
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private static long getRootPos(MVMap<String, String> mVMap, int n) {
        String string = mVMap.get(MVMap.getMapRootKey(n));
        return string == null ? 0L : DataUtils.parseHexLong(string);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public long getLastStoredVersion() {
        return this.lastStoredVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> mVMap, String string) {
        this.checkOpen();
        DataUtils.checkArgument(mVMap != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int n = mVMap.getId();
        String string2 = this.getMapName(n);
        if (string2 != null && !string2.equals(string)) {
            String string3 = Integer.toHexString(n);
            String string4 = this.meta.putIfAbsent("name." + string, string3);
            DataUtils.checkArgument(string4 == null || string4.equals(string3), "A map named {0} already exists", string);
            this.meta.put(MVMap.getMapKey(n), mVMap.asString(string));
            this.meta.remove("name." + string2);
            this.markMetaChanged();
        }
    }

    public void removeMap(MVMap<?, ?> mVMap) {
        this.removeMap(mVMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> mVMap, boolean bl) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(mVMap != this.meta, "Removing the meta map is not allowed", new Object[0]);
            mVMap.close();
            RootReference rootReference = mVMap.getRoot();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int n = mVMap.getId();
            String string = this.getMapName(n);
            this.removeMap(string, n, bl);
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private void removeMap(String string, int n, boolean bl) {
        if (this.meta.remove(MVMap.getMapKey(n)) != null) {
            this.markMetaChanged();
        }
        if (this.meta.remove("name." + string) != null) {
            this.markMetaChanged();
        }
        if (!bl) {
            if (this.meta.remove(MVMap.getMapRootKey(n)) != null) {
                this.markMetaChanged();
            }
            this.maps.remove(n);
        }
    }

    public void removeMap(String string) {
        int n = this.getMapId(string);
        if (n > 0) {
            this.removeMap(string, n, false);
        }
    }

    public String getMapName(int n) {
        this.checkOpen();
        String string = this.meta.get(MVMap.getMapKey(n));
        return string == null ? null : DataUtils.getMapName(string);
    }

    private int getMapId(String string) {
        String string2 = this.meta.get("name." + string);
        return string2 == null ? -1 : DataUtils.parseHexInt(string2);
    }

    void writeInBackground() {
        try {
            if (!this.isOpenOrStopping()) {
                return;
            }
            long l = this.getTimeSinceCreation();
            if (l <= this.lastCommitTime + (long)this.autoCommitDelay) {
                return;
            }
            this.tryCommit();
            if (this.autoCompactFillRate > 0) {
                long l2 = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
                boolean bl = this.autoCompactLastFileOpCount != l2;
                int n = bl ? this.autoCompactFillRate / 3 : this.autoCompactFillRate;
                this.compact(n, this.autoCommitMemory);
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
        }
        catch (Throwable throwable) {
            this.handleException(throwable);
        }
    }

    private void handleException(Throwable throwable) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                }
                catch (Throwable throwable2) {
                    if (throwable == throwable2) break block3;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
    }

    public void setCacheSize(int n) {
        long l = (long)n * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(l);
            this.cache.clear();
        }
        if (this.cacheChunkRef != null) {
            this.cacheChunkRef.setMaxMemory(l / 4L);
            this.cacheChunkRef.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            assert (this.state == 3);
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean bl) {
        BackgroundWriterThread backgroundWriterThread;
        while ((backgroundWriterThread = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(backgroundWriterThread, null)) continue;
            if (backgroundWriterThread == Thread.currentThread()) break;
            Object object = backgroundWriterThread.sync;
            synchronized (object) {
                backgroundWriterThread.sync.notifyAll();
            }
            if (!bl) break;
            try {
                backgroundWriterThread.join();
            }
            catch (Exception exception) {}
            break;
        }
    }

    public void setAutoCommitDelay(int n) {
        int n2;
        BackgroundWriterThread backgroundWriterThread;
        if (this.autoCommitDelay == n) {
            return;
        }
        this.autoCommitDelay = n;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (n > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, backgroundWriterThread = new BackgroundWriterThread(this, n2 = Math.max(1, n / 10), this.fileStore.toString()))) {
            backgroundWriterThread.start();
        }
    }

    boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public double getUpdateFailureRatio() {
        long l = this.updateCounter;
        long l2 = this.updateAttemptCounter;
        RootReference rootReference = this.meta.getRoot();
        l += rootReference.updateCounter;
        l2 += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> mVMap : this.maps.values()) {
            RootReference rootReference2 = mVMap.getRoot();
            l += rootReference2.updateCounter;
            l2 += rootReference2.updateAttemptCounter;
        }
        return l2 == 0L ? 0.0 : 1.0 - (double)l / (double)l2;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while (true) {
            txCounter = this.currentTxCounter;
            if (txCounter.counter.getAndIncrement() >= 0) break;
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.counter.decrementAndGet();
        }
        return txCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterVersionUsage(TxCounter txCounter) {
        if (txCounter != null && txCounter.counter.decrementAndGet() <= 0 && !this.storeLock.isHeldByCurrentThread() && this.storeLock.tryLock()) {
            try {
                this.dropUnusedVersions();
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private void onVersionChange(long l) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.counter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(l);
        txCounter.counter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        while ((txCounter = this.versions.peek()) != null && txCounter.counter.get() < 0) {
            this.versions.poll();
        }
        this.setOldestVersionToKeep(txCounter != null ? txCounter.version : this.currentTxCounter.version);
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> hashMap) {
            this.config = hashMap;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String string, Object object) {
            this.config.put(string, object);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int n) {
            return this.set("autoCommitBufferSize", n);
        }

        public Builder autoCompactFillRate(int n) {
            return this.set("autoCompactFillRate", n);
        }

        public Builder fileName(String string) {
            return this.set("fileName", string);
        }

        public Builder encryptionKey(char[] cArray) {
            return this.set("encryptionKey", cArray);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder cacheSize(int n) {
            return this.set("cacheSize", n);
        }

        public Builder cacheConcurrency(int n) {
            return this.set("cacheConcurrency", n);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int n) {
            return this.set("pageSplitSize", n);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            return this.set("backgroundExceptionHandler", uncaughtExceptionHandler);
        }

        public Builder fileStore(FileStore fileStore) {
            return this.set("fileStore", fileStore);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String string) {
            return new Builder(DataUtils.parseMap(string));
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore mVStore, int n, String string) {
            super("MVStore background writer " + string);
            this.store = mVStore;
            this.sleep = n;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        public final AtomicInteger counter = new AtomicInteger();

        TxCounter(long l) {
            this.version = l;
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }

    final class ChunkIdsCollector {
        private final ConcurrentHashMap<Integer, Integer> referencedChunks = new ConcurrentHashMap();
        private final ChunkIdsCollector parent;
        private int mapId;

        ChunkIdsCollector(int n) {
            this.parent = null;
            this.mapId = n;
        }

        private ChunkIdsCollector(ChunkIdsCollector chunkIdsCollector) {
            this.parent = chunkIdsCollector;
            this.mapId = chunkIdsCollector.mapId;
        }

        public int getMapId() {
            return this.mapId;
        }

        public void setMapId(int n) {
            this.mapId = n;
        }

        public Set<Integer> getReferenced() {
            return new HashSet<Integer>(this.referencedChunks.keySet());
        }

        public void visit(Page page, ThreadPoolExecutor threadPoolExecutor, AtomicInteger atomicInteger) {
            int n;
            long l = page.getPos();
            if (DataUtils.isPageSaved(l)) {
                this.registerChunk(DataUtils.getPageChunkId(l));
            }
            if ((n = page.map.getChildPageCount(page)) == 0) {
                return;
            }
            ChunkIdsCollector chunkIdsCollector = DataUtils.isPageSaved(l) && MVStore.this.cacheChunkRef != null ? new ChunkIdsCollector(this) : this;
            for (int i = 0; i < n; ++i) {
                Page page2 = page.getChildPageIfLoaded(i);
                if (page2 != null) {
                    chunkIdsCollector.visit(page2, threadPoolExecutor, atomicInteger);
                    continue;
                }
                chunkIdsCollector.visit(page.getChildPagePos(i), threadPoolExecutor, atomicInteger);
            }
            this.cacheCollectedChunkIds(l, chunkIdsCollector);
        }

        public void visit(long l, ThreadPoolExecutor threadPoolExecutor, AtomicInteger atomicInteger) {
            int[] nArray;
            if (!DataUtils.isPageSaved(l)) {
                return;
            }
            this.registerChunk(DataUtils.getPageChunkId(l));
            if (DataUtils.getPageType(l) == 0) {
                return;
            }
            if (MVStore.this.cacheChunkRef != null && (nArray = MVStore.this.cacheChunkRef.get(l)) != null) {
                for (int n : nArray) {
                    this.registerChunk(n);
                }
            } else {
                Page page;
                ChunkIdsCollector chunkIdsCollector;
                ChunkIdsCollector chunkIdsCollector2 = chunkIdsCollector = MVStore.this.cacheChunkRef != null ? new ChunkIdsCollector(this) : this;
                if (MVStore.this.cache != null && (page = MVStore.this.cache.get(l)) != null) {
                    chunkIdsCollector.visit(page, threadPoolExecutor, atomicInteger);
                } else {
                    ByteBuffer byteBuffer = MVStore.this.readBufferForPage(l, this.getMapId());
                    Page.readChildrenPositions(byteBuffer, l, chunkIdsCollector, threadPoolExecutor, atomicInteger);
                }
                this.cacheCollectedChunkIds(l, chunkIdsCollector);
            }
        }

        void registerChunk(int n) {
            if (this.referencedChunks.put(n, 1) == null && this.parent != null) {
                this.parent.registerChunk(n);
            }
        }

        private void cacheCollectedChunkIds(long l, ChunkIdsCollector chunkIdsCollector) {
            if (chunkIdsCollector != this) {
                int[] nArray = new int[chunkIdsCollector.referencedChunks.size()];
                int n = 0;
                for (Integer n2 : chunkIdsCollector.referencedChunks.keySet()) {
                    nArray[n++] = n2;
                }
                MVStore.this.cacheChunkRef.put(l, nArray, 24 + 4 * nArray.length);
            }
        }
    }
}

