/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.server.pg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import plan.org.h2.engine.ConnectionInfo;
import plan.org.h2.engine.SysProperties;
import plan.org.h2.jdbc.JdbcConnection;
import plan.org.h2.jdbc.JdbcPreparedStatement;
import plan.org.h2.jdbc.JdbcResultSet;
import plan.org.h2.jdbc.JdbcStatement;
import plan.org.h2.message.DbException;
import plan.org.h2.server.pg.PgServer;
import plan.org.h2.util.DateTimeUtils;
import plan.org.h2.util.JdbcUtils;
import plan.org.h2.util.MathUtils;
import plan.org.h2.util.ScriptReader;
import plan.org.h2.util.StringUtils;
import plan.org.h2.util.Utils;
import plan.org.h2.value.CaseInsensitiveMap;
import plan.org.h2.value.Value;
import plan.org.h2.value.ValueDate;
import plan.org.h2.value.ValueNull;
import plan.org.h2.value.ValueTime;
import plan.org.h2.value.ValueTimestamp;

public class PgServerThread
implements Runnable {
    private static final boolean INTEGER_DATE_TYPES = false;
    private final PgServer server;
    private Socket socket;
    private Connection conn;
    private boolean stop;
    private DataInputStream dataInRaw;
    private DataInputStream dataIn;
    private OutputStream out;
    private int messageType;
    private ByteArrayOutputStream outBuffer;
    private DataOutputStream dataOut;
    private Thread thread;
    private boolean initDone;
    private String userName;
    private String databaseName;
    private int processId;
    private final int secret;
    private JdbcStatement activeRequest;
    private String clientEncoding = SysProperties.PG_DEFAULT_CLIENT_ENCODING;
    private String dateStyle = "ISO, MDY";
    private final HashMap<String, Prepared> prepared = new CaseInsensitiveMap<Prepared>();
    private final HashMap<String, Portal> portals = new CaseInsensitiveMap<Portal>();

    PgServerThread(Socket socket, PgServer pgServer) {
        this.server = pgServer;
        this.socket = socket;
        this.secret = (int)MathUtils.secureRandomLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.server.trace("Connect");
            InputStream inputStream = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.dataInRaw = new DataInputStream(inputStream);
            while (!this.stop) {
                this.process();
                this.out.flush();
            }
        }
        catch (EOFException eOFException) {
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        finally {
            this.server.trace("Disconnect");
            this.close();
        }
    }

    private String readString() throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = this.dataIn.read()) > 0) {
            byteArrayOutputStream.write(n);
        }
        return new String(byteArrayOutputStream.toByteArray(), this.getEncoding());
    }

    private int readInt() throws IOException {
        return this.dataIn.readInt();
    }

    private short readShort() throws IOException {
        return this.dataIn.readShort();
    }

    private byte readByte() throws IOException {
        return this.dataIn.readByte();
    }

    private void readFully(byte[] byArray) throws IOException {
        this.dataIn.readFully(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void process() throws IOException {
        if (this.initDone) {
            var1_1 = this.dataInRaw.read();
            if (var1_1 < 0) {
                this.stop = true;
                return;
            }
        } else {
            var1_1 = 0;
        }
        var2_2 = this.dataInRaw.readInt();
        var3_3 = Utils.newBytes(var2_2 -= 4);
        this.dataInRaw.readFully(var3_3, 0, var2_2);
        this.dataIn = new DataInputStream(new ByteArrayInputStream(var3_3, 0, var2_2));
        switch (var1_1) {
            case 0: {
                this.server.trace("Init");
                var4_4 = this.readInt();
                if (var4_4 == 80877102) {
                    this.server.trace("CancelRequest");
                    var5_5 = this.readInt();
                    var6_14 = this.readInt();
                    var7_24 = this.server.getThread(var5_5);
                    if (var7_24 != null && var6_14 == var7_24.secret) {
                        var7_24.cancelRequest();
                    } else {
                        this.server.trace("Invalid CancelRequest: pid=" + var5_5 + ", key=" + var6_14);
                    }
                    this.close();
                    break;
                }
                if (var4_4 == 80877103) {
                    this.server.trace("SSLRequest");
                    this.out.write(78);
                    break;
                }
                this.server.trace("StartupMessage");
                this.server.trace(" version " + var4_4 + " (" + (var4_4 >> 16) + "." + (var4_4 & 255) + ")");
                while (!(var5_6 = this.readString()).isEmpty()) {
                    var6_15 = this.readString();
                    if ("user".equals(var5_6)) {
                        this.userName = var6_15;
                    } else if ("database".equals(var5_6)) {
                        this.databaseName = this.server.checkKeyAndGetDatabaseName(var6_15);
                    } else if ("client_encoding".equals(var5_6)) {
                        this.clientEncoding = var6_15;
                    } else if ("DateStyle".equals(var5_6)) {
                        if (var6_15.indexOf(44) < 0) {
                            var6_15 = var6_15 + ", MDY";
                        }
                        this.dateStyle = var6_15;
                    }
                    this.server.trace(" param " + var5_6 + "=" + var6_15);
                }
                this.sendAuthenticationCleartextPassword();
                this.initDone = true;
                break;
            }
            case 112: {
                this.server.trace("PasswordMessage");
                var5_7 = this.readString();
                try {
                    var6_16 = new Properties();
                    var6_16.put("MODE", "PostgreSQL");
                    var6_16.put("USER", this.userName);
                    var6_16.put("PASSWORD", var5_7);
                    var7_25 = "jdbc:h2:" + this.databaseName;
                    var8_33 = new ConnectionInfo(var7_25, var6_16);
                    var9_43 = this.server.getBaseDir();
                    if (var9_43 == null) {
                        var9_43 = SysProperties.getBaseDir();
                    }
                    if (var9_43 != null) {
                        var8_33.setBaseDir(var9_43);
                    }
                    if (this.server.getIfExists()) {
                        var8_33.setProperty("IFEXISTS", "TRUE");
                    }
                    this.conn = new JdbcConnection(var8_33, false);
                    this.initDb();
                    this.sendAuthenticationOk();
                }
                catch (Exception var6_17) {
                    var6_17.printStackTrace();
                    this.stop = true;
                }
                break;
            }
            case 80: {
                this.server.trace("Parse");
                var5_8 = new Prepared();
                var5_8.name = this.readString();
                var5_8.sql = this.getSQL(this.readString());
                var6_18 = this.readShort();
                var7_26 = null;
                if (var6_18 > 0) {
                    var7_26 = new int[var6_18];
                    for (var8_34 = 0; var8_34 < var6_18; ++var8_34) {
                        var7_26[var8_34] = this.readInt();
                    }
                }
                try {
                    var5_8.prep = (JdbcPreparedStatement)this.conn.prepareStatement(var5_8.sql);
                    var8_35 = var5_8.prep.getParameterMetaData();
                    var5_8.paramType = new int[var8_35.getParameterCount()];
                    for (var9_44 = 0; var9_44 < var5_8.paramType.length; ++var9_44) {
                        if (var9_44 < var6_18 && var7_26[var9_44] != 0) {
                            var10_50 = var7_26[var9_44];
                            this.server.checkType(var10_50);
                        } else {
                            var10_50 = PgServer.convertType(var8_35.getParameterType(var9_44 + 1));
                        }
                        var5_8.paramType[var9_44] = var10_50;
                    }
                    this.prepared.put(var5_8.name, var5_8);
                    this.sendParseComplete();
                }
                catch (Exception var8_36) {
                    this.sendErrorResponse(var8_36);
                }
                break;
            }
            case 66: {
                this.server.trace("Bind");
                var5_9 = new Portal();
                var5_9.name = this.readString();
                var6_19 = this.readString();
                var7_27 = this.prepared.get(var6_19);
                if (var7_27 == null) {
                    this.sendErrorResponse("Prepared not found");
                    break;
                }
                var5_9.prep = var7_27;
                this.portals.put(var5_9.name, var5_9);
                var8_37 = this.readShort();
                var9_45 = new int[var8_37];
                for (var10_51 = 0; var10_51 < var8_37; ++var10_51) {
                    var9_45[var10_51] = this.readShort();
                }
                var10_51 = this.readShort();
                try {
                    for (var11_55 = 0; var11_55 < var10_51; ++var11_55) {
                        this.setParameter(var7_27.prep, var7_27.paramType[var11_55], var11_55, var9_45);
                    }
                }
                catch (Exception var11_56) {
                    this.sendErrorResponse(var11_56);
                    break;
                }
                var11_55 = this.readShort();
                var5_9.resultColumnFormat = new int[var11_55];
                for (var12_60 = 0; var12_60 < var11_55; ++var12_60) {
                    var5_9.resultColumnFormat[var12_60] = this.readShort();
                }
                this.sendBindComplete();
                break;
            }
            case 67: {
                var5_10 = (char)this.readByte();
                var6_20 = this.readString();
                this.server.trace("Close");
                if (var5_10 == 'S') {
                    var7_28 = this.prepared.remove(var6_20);
                    if (var7_28 != null) {
                        JdbcUtils.closeSilently(var7_28.prep);
                    }
                } else if (var5_10 == 'P') {
                    this.portals.remove(var6_20);
                } else {
                    this.server.trace("expected S or P, got " + var5_10);
                    this.sendErrorResponse("expected S or P");
                    break;
                }
                this.sendCloseComplete();
                break;
            }
            case 68: {
                var5_11 = (char)this.readByte();
                var6_21 = this.readString();
                this.server.trace("Describe");
                if (var5_11 == 'S') {
                    var7_29 = this.prepared.get(var6_21);
                    if (var7_29 == null) {
                        this.sendErrorResponse("Prepared not found: " + var6_21);
                        break;
                    }
                    try {
                        this.sendParameterDescription(var7_29.prep.getParameterMetaData(), var7_29.paramType);
                        this.sendRowDescription(var7_29.prep.getMetaData());
                    }
                    catch (Exception var8_38) {
                        this.sendErrorResponse(var8_38);
                    }
                    break;
                }
                if (var5_11 == 'P') {
                    var7_30 = this.portals.get(var6_21);
                    if (var7_30 == null) {
                        this.sendErrorResponse("Portal not found: " + var6_21);
                        break;
                    }
                    var8_39 = var7_30.prep.prep;
                    try {
                        var9_46 = var8_39.getMetaData();
                        this.sendRowDescription(var9_46);
                    }
                    catch (Exception var9_47) {
                        this.sendErrorResponse(var9_47);
                    }
                    break;
                }
                this.server.trace("expected S or P, got " + var5_11);
                this.sendErrorResponse("expected S or P");
                break;
            }
            case 69: {
                var5_12 = this.readString();
                this.server.trace("Execute");
                var6_22 = this.portals.get(var5_12);
                if (var6_22 == null) {
                    this.sendErrorResponse("Portal not found: " + var5_12);
                    break;
                }
                var7_31 = this.readShort();
                var8_40 = var6_22.prep;
                var9_48 = var8_40.prep;
                this.server.trace(var8_40.sql);
                try {
                    var9_48.setMaxRows(var7_31);
                    this.setActiveRequest(var9_48);
                    var10_52 = var9_48.execute();
                    if (var10_52) {
                        try {
                            var11_57 = var9_48.getResultSet();
                            while (var11_57.next()) {
                                this.sendDataRow(var11_57, var6_22.resultColumnFormat);
                            }
                            this.sendCommandComplete(var9_48, 0);
                        }
                        catch (Exception var11_58) {
                            this.sendErrorResponse(var11_58);
                        }
                        break;
                    }
                    this.sendCommandComplete(var9_48, var9_48.getUpdateCount());
                    break;
                }
                catch (Exception var10_53) {
                    if (var9_48.isCancelled()) {
                        this.sendCancelQueryResponse();
                        break;
                    }
                    this.sendErrorResponse(var10_53);
                    break;
                }
                finally {
                    this.setActiveRequest(null);
                }
            }
            case 83: {
                this.server.trace("Sync");
                this.sendReadyForQuery();
                break;
            }
            case 81: {
                this.server.trace("Query");
                var5_13 = this.readString();
                var6_23 = new ScriptReader(new StringReader(var5_13));
                while (true) {
                    var7_32 = null;
                    var8_41 = var6_23.readStatement();
                    if (var8_41 != null) ** GOTO lbl249
                    JdbcUtils.closeSilently(var7_32);
                    this.setActiveRequest(null);
                    ** GOTO lbl287
lbl249:
                    // 2 sources

                    var8_41 = this.getSQL(var8_41);
                    var7_32 = (JdbcStatement)this.conn.createStatement();
                    this.setActiveRequest(var7_32);
                    var9_49 = var7_32.execute(var8_41);
                    if (!var9_49) ** GOTO lbl270
                    var10_54 = var7_32.getResultSet();
                    var11_59 = var10_54.getMetaData();
                    try {
                        this.sendRowDescription(var11_59);
                        while (var10_54.next()) {
                            this.sendDataRow(var10_54, null);
                        }
                        this.sendCommandComplete(var7_32, 0);
                    }
                    catch (Exception var12_61) {
                        this.sendErrorResponse(var12_61);
                        JdbcUtils.closeSilently(var7_32);
                        this.setActiveRequest(null);
                    }
                    ** GOTO lbl271
lbl270:
                    // 1 sources

                    this.sendCommandComplete(var7_32, var7_32.getUpdateCount());
lbl271:
                    // 2 sources

                    JdbcUtils.closeSilently(var7_32);
                    this.setActiveRequest(null);
                }
                catch (SQLException var8_42) {
                    try {
                        if (var7_32 == null || !var7_32.isCancelled()) ** GOTO lbl279
                        this.sendCancelQueryResponse();
                        ** GOTO lbl284
lbl279:
                        // 1 sources

                        this.sendErrorResponse(var8_42);
                    }
                    catch (Throwable var14_63) {
                        JdbcUtils.closeSilently(var7_32);
                        this.setActiveRequest(null);
                        throw var14_63;
                    }
lbl284:
                    // 2 sources

                    JdbcUtils.closeSilently(var7_32);
                    this.setActiveRequest(null);
                }
lbl287:
                // 3 sources

                this.sendReadyForQuery();
                break;
            }
            case 88: {
                this.server.trace("Terminate");
                this.close();
                break;
            }
            default: {
                this.server.trace("Unsupported: " + var1_1 + " (" + (char)var1_1 + ")");
            }
        }
    }

    private String getSQL(String string) {
        String string2 = StringUtils.toLowerEnglish(string);
        if (string2.startsWith("show max_identifier_length")) {
            string = "CALL 63";
        } else if (string2.startsWith("set client_encoding to")) {
            string = "set DATESTYLE ISO";
        }
        if (this.server.getTrace()) {
            this.server.trace(string + ";");
        }
        return string;
    }

    private void sendCommandComplete(JdbcStatement jdbcStatement, int n) throws IOException {
        this.startMessage(67);
        switch (jdbcStatement.getLastExecutedCommandType()) {
            case 61: {
                this.writeStringPart("INSERT 0 ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 68: {
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 58: {
                this.writeStringPart("DELETE ");
                this.writeString(Integer.toString(n));
                break;
            }
            case 57: 
            case 66: {
                this.writeString("SELECT");
                break;
            }
            case 83: {
                this.writeString("BEGIN");
                break;
            }
            default: {
                this.server.trace("check CommandComplete tag for command " + jdbcStatement);
                this.writeStringPart("UPDATE ");
                this.writeString(Integer.toString(n));
            }
        }
        this.sendMessage();
    }

    private void sendDataRow(ResultSet resultSet, int[] nArray) throws IOException, SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = resultSetMetaData.getColumnCount();
        this.startMessage(68);
        this.writeShort(n);
        for (int i = 1; i <= n; ++i) {
            int n2 = PgServer.convertType(resultSetMetaData.getColumnType(i));
            boolean bl = PgServerThread.formatAsText(n2);
            if (nArray != null) {
                if (nArray.length == 0) {
                    bl = true;
                } else if (nArray.length == 1) {
                    bl = nArray[0] == 0;
                } else if (i - 1 < nArray.length) {
                    bl = nArray[i - 1] == 0;
                }
            }
            this.writeDataColumn(resultSet, i, n2, bl);
        }
        this.sendMessage();
    }

    private static long toPostgreDays(long l) {
        return DateTimeUtils.prolepticGregorianAbsoluteDayFromDateValue(l) - 10957L;
    }

    private void writeDataColumn(ResultSet resultSet, int n, int n2, boolean bl) throws IOException {
        Value value = ((JdbcResultSet)resultSet).get(n);
        if (value == ValueNull.INSTANCE) {
            this.writeInt(-1);
            return;
        }
        if (bl) {
            switch (n2) {
                case 16: {
                    this.writeInt(1);
                    this.dataOut.writeByte(value.getBoolean() ? 116 : 102);
                    break;
                }
                default: {
                    byte[] byArray = value.getString().getBytes(this.getEncoding());
                    this.writeInt(byArray.length);
                    this.write(byArray);
                    break;
                }
            }
        } else {
            switch (n2) {
                case 21: {
                    this.writeInt(2);
                    this.writeShort(value.getShort());
                    break;
                }
                case 23: {
                    this.writeInt(4);
                    this.writeInt(value.getInt());
                    break;
                }
                case 20: {
                    this.writeInt(8);
                    this.dataOut.writeLong(value.getLong());
                    break;
                }
                case 700: {
                    this.writeInt(4);
                    this.dataOut.writeFloat(value.getFloat());
                    break;
                }
                case 701: {
                    this.writeInt(8);
                    this.dataOut.writeDouble(value.getDouble());
                    break;
                }
                case 17: {
                    byte[] byArray = value.getBytesNoCopy();
                    this.writeInt(byArray.length);
                    this.write(byArray);
                    break;
                }
                case 1082: {
                    ValueDate valueDate = (ValueDate)value.convertTo(10);
                    this.writeInt(4);
                    this.writeInt((int)PgServerThread.toPostgreDays(valueDate.getDateValue()));
                    break;
                }
                case 1083: {
                    ValueTime valueTime = (ValueTime)value.convertTo(9);
                    this.writeInt(8);
                    long l = valueTime.getNanos();
                    l = Double.doubleToLongBits((double)l * 1.0E-9);
                    this.dataOut.writeLong(l);
                    break;
                }
                case 1114: {
                    ValueTimestamp valueTimestamp = (ValueTimestamp)value.convertTo(11);
                    this.writeInt(8);
                    long l = PgServerThread.toPostgreDays(valueTimestamp.getDateValue()) * 86400L;
                    long l2 = valueTimestamp.getTimeNanos();
                    l = Double.doubleToLongBits((double)l + (double)l2 * 1.0E-9);
                    this.dataOut.writeLong(l);
                    break;
                }
                default: {
                    throw new IllegalStateException("output binary format is undefined");
                }
            }
        }
    }

    private Charset getEncoding() {
        if ("UNICODE".equals(this.clientEncoding)) {
            return StandardCharsets.UTF_8;
        }
        return Charset.forName(this.clientEncoding);
    }

    private void setParameter(PreparedStatement preparedStatement, int n, int n2, int[] nArray) throws SQLException, IOException {
        boolean bl = n2 >= nArray.length || nArray[n2] == 0;
        int n3 = n2 + 1;
        int n4 = this.readInt();
        if (n4 == -1) {
            preparedStatement.setNull(n3, 0);
        } else if (bl) {
            byte[] byArray = Utils.newBytes(n4);
            this.readFully(byArray);
            String string = new String(byArray, this.getEncoding());
            switch (n) {
                case 1082: {
                    int n5 = string.indexOf(32);
                    if (n5 <= 0) break;
                    string = string.substring(0, n5);
                    break;
                }
                case 1083: {
                    int n6 = string.indexOf(43);
                    if (n6 <= 0) {
                        n6 = string.indexOf(45);
                    }
                    if (n6 <= 0) break;
                    string = string.substring(0, n6);
                    break;
                }
            }
            preparedStatement.setString(n3, string);
        } else {
            switch (n) {
                case 21: {
                    PgServerThread.checkParamLength(2, n4);
                    preparedStatement.setShort(n3, this.readShort());
                    break;
                }
                case 23: {
                    PgServerThread.checkParamLength(4, n4);
                    preparedStatement.setInt(n3, this.readInt());
                    break;
                }
                case 20: {
                    PgServerThread.checkParamLength(8, n4);
                    preparedStatement.setLong(n3, this.dataIn.readLong());
                    break;
                }
                case 700: {
                    PgServerThread.checkParamLength(4, n4);
                    preparedStatement.setFloat(n3, this.dataIn.readFloat());
                    break;
                }
                case 701: {
                    PgServerThread.checkParamLength(8, n4);
                    preparedStatement.setDouble(n3, this.dataIn.readDouble());
                    break;
                }
                case 17: {
                    byte[] byArray = Utils.newBytes(n4);
                    this.readFully(byArray);
                    preparedStatement.setBytes(n3, byArray);
                    break;
                }
                default: {
                    this.server.trace("Binary format for type: " + n + " is unsupported");
                    byte[] byArray = Utils.newBytes(n4);
                    this.readFully(byArray);
                    preparedStatement.setString(n3, new String(byArray, this.getEncoding()));
                }
            }
        }
    }

    private static void checkParamLength(int n, int n2) {
        if (n != n2) {
            throw DbException.getInvalidValueException("paramLen", n2);
        }
    }

    private void sendErrorResponse(Exception exception) throws IOException {
        SQLException sQLException = DbException.toSQLException(exception);
        this.server.traceError(sQLException);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString(sQLException.getSQLState());
        this.write(77);
        this.writeString(sQLException.getMessage());
        this.write(68);
        this.writeString(sQLException.toString());
        this.write(0);
        this.sendMessage();
    }

    private void sendCancelQueryResponse() throws IOException {
        this.server.trace("CancelSuccessResponse");
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("57014");
        this.write(77);
        this.writeString("canceling statement due to user request");
        this.write(0);
        this.sendMessage();
    }

    private void sendParameterDescription(ParameterMetaData parameterMetaData, int[] nArray) throws Exception {
        int n = parameterMetaData.getParameterCount();
        this.startMessage(116);
        this.writeShort(n);
        for (int i = 0; i < n; ++i) {
            int n2 = nArray != null && nArray[i] != 0 ? nArray[i] : 1043;
            this.server.checkType(n2);
            this.writeInt(n2);
        }
        this.sendMessage();
    }

    private void sendNoData() throws IOException {
        this.startMessage(110);
        this.sendMessage();
    }

    private void sendRowDescription(ResultSetMetaData resultSetMetaData) throws IOException, SQLException {
        if (resultSetMetaData == null) {
            this.sendNoData();
        } else {
            int n;
            int n2 = resultSetMetaData.getColumnCount();
            int[] nArray = new int[n2];
            int[] nArray2 = new int[n2];
            String[] stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                String string;
                stringArray[n] = string = resultSetMetaData.getColumnName(n + 1);
                int n3 = resultSetMetaData.getColumnType(n + 1);
                int n4 = PgServer.convertType(n3);
                nArray2[n] = resultSetMetaData.getColumnDisplaySize(n + 1);
                if (n3 != 0) {
                    this.server.checkType(n4);
                }
                nArray[n] = n4;
            }
            this.startMessage(84);
            this.writeShort(n2);
            for (n = 0; n < n2; ++n) {
                this.writeString(StringUtils.toLowerEnglish(stringArray[n]));
                this.writeInt(0);
                this.writeShort(0);
                this.writeInt(nArray[n]);
                this.writeShort(PgServerThread.getTypeSize(nArray[n], nArray2[n]));
                this.writeInt(-1);
                this.writeShort(PgServerThread.formatAsText(nArray[n]) ? 0 : 1);
            }
            this.sendMessage();
        }
    }

    private static boolean formatAsText(int n) {
        switch (n) {
            case 17: {
                return false;
            }
        }
        return true;
    }

    private static int getTypeSize(int n, int n2) {
        switch (n) {
            case 16: {
                return 1;
            }
            case 1043: {
                return Math.max(255, n2 + 10);
            }
        }
        return n2 + 4;
    }

    private void sendErrorResponse(String string) throws IOException {
        this.server.trace("Exception: " + string);
        this.startMessage(69);
        this.write(83);
        this.writeString("ERROR");
        this.write(67);
        this.writeString("08P01");
        this.write(77);
        this.writeString(string);
        this.sendMessage();
    }

    private void sendParseComplete() throws IOException {
        this.startMessage(49);
        this.sendMessage();
    }

    private void sendBindComplete() throws IOException {
        this.startMessage(50);
        this.sendMessage();
    }

    private void sendCloseComplete() throws IOException {
        this.startMessage(51);
        this.sendMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDb() throws SQLException {
        Statement statement;
        block48: {
            statement = null;
            try {
                Object object;
                Object object2 = this.server;
                synchronized (object2) {
                    boolean bl;
                    object = this.conn.getMetaData().getTables(null, "PG_CATALOG", "PG_VERSION", null);
                    Throwable throwable = null;
                    try {
                        bl = object.next();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                    statement = this.conn.createStatement();
                    if (!bl) {
                        PgServerThread.installPgCatalog(statement);
                    }
                    object = statement.executeQuery("select * from pg_catalog.pg_version");
                    throwable = null;
                    try {
                        if (!object.next() || object.getInt(1) < 2) {
                            PgServerThread.installPgCatalog(statement);
                        } else {
                            int n = object.getInt(2);
                            if (n > 2) {
                                throw DbException.throwInternalError("Incompatible PG_VERSION");
                            }
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (object != null) {
                            if (throwable != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                statement.execute("set search_path = PUBLIC, pg_catalog");
                object2 = this.server.getTypeSet();
                if (!((HashSet)object2).isEmpty()) break block48;
                ResultSet resultSet = statement.executeQuery("select oid from pg_catalog.pg_type");
                object = null;
                try {
                    while (resultSet.next()) {
                        ((HashSet)object2).add(resultSet.getInt(1));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (resultSet != null) {
                        if (object != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                JdbcUtils.closeSilently(statement);
                throw throwable;
            }
        }
        JdbcUtils.closeSilently(statement);
    }

    private static void installPgCatalog(Statement statement) throws SQLException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(new ByteArrayInputStream(Utils.getResource("/plan/org/h2/server/pg/pg_catalog.sql")));){
            String string;
            ScriptReader scriptReader = new ScriptReader(inputStreamReader);
            while ((string = scriptReader.readStatement()) != null) {
                statement.execute(string);
            }
            scriptReader.close();
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, "Can not read pg_catalog resource");
        }
    }

    void close() {
        try {
            this.stop = true;
            JdbcUtils.closeSilently(this.conn);
            if (this.socket != null) {
                this.socket.close();
            }
            this.server.trace("Close");
        }
        catch (Exception exception) {
            this.server.traceError(exception);
        }
        this.conn = null;
        this.socket = null;
        this.server.remove(this);
    }

    private void sendAuthenticationCleartextPassword() throws IOException {
        this.startMessage(82);
        this.writeInt(3);
        this.sendMessage();
    }

    private void sendAuthenticationOk() throws IOException {
        this.startMessage(82);
        this.writeInt(0);
        this.sendMessage();
        this.sendParameterStatus("client_encoding", this.clientEncoding);
        this.sendParameterStatus("DateStyle", this.dateStyle);
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendParameterStatus("is_superuser", "off");
        this.sendParameterStatus("server_encoding", "SQL_ASCII");
        this.sendParameterStatus("server_version", "8.2.23");
        this.sendParameterStatus("session_authorization", this.userName);
        this.sendParameterStatus("standard_conforming_strings", "off");
        this.sendParameterStatus("TimeZone", "CET");
        this.sendParameterStatus("integer_datetimes", "off");
        this.sendBackendKeyData();
        this.sendReadyForQuery();
    }

    private void sendReadyForQuery() throws IOException {
        int n;
        this.startMessage(90);
        try {
            n = this.conn.getAutoCommit() ? 73 : 84;
        }
        catch (SQLException sQLException) {
            n = 69;
        }
        this.write((byte)n);
        this.sendMessage();
    }

    private void sendBackendKeyData() throws IOException {
        this.startMessage(75);
        this.writeInt(this.processId);
        this.writeInt(this.secret);
        this.sendMessage();
    }

    private void writeString(String string) throws IOException {
        this.writeStringPart(string);
        this.write(0);
    }

    private void writeStringPart(String string) throws IOException {
        this.write(string.getBytes(this.getEncoding()));
    }

    private void writeInt(int n) throws IOException {
        this.dataOut.writeInt(n);
    }

    private void writeShort(int n) throws IOException {
        this.dataOut.writeShort(n);
    }

    private void write(byte[] byArray) throws IOException {
        this.dataOut.write(byArray);
    }

    private void write(int n) throws IOException {
        this.dataOut.write(n);
    }

    private void startMessage(int n) {
        this.messageType = n;
        this.outBuffer = new ByteArrayOutputStream();
        this.dataOut = new DataOutputStream(this.outBuffer);
    }

    private void sendMessage() throws IOException {
        this.dataOut.flush();
        byte[] byArray = this.outBuffer.toByteArray();
        int n = byArray.length;
        this.dataOut = new DataOutputStream(this.out);
        this.dataOut.write(this.messageType);
        this.dataOut.writeInt(n + 4);
        this.dataOut.write(byArray);
        this.dataOut.flush();
    }

    private void sendParameterStatus(String string, String string2) throws IOException {
        this.startMessage(83);
        this.writeString(string);
        this.writeString(string2);
        this.sendMessage();
    }

    void setThread(Thread thread) {
        this.thread = thread;
    }

    Thread getThread() {
        return this.thread;
    }

    void setProcessId(int n) {
        this.processId = n;
    }

    int getProcessId() {
        return this.processId;
    }

    private synchronized void setActiveRequest(JdbcStatement jdbcStatement) {
        this.activeRequest = jdbcStatement;
    }

    private synchronized void cancelRequest() {
        if (this.activeRequest != null) {
            try {
                this.activeRequest.cancel();
                this.activeRequest = null;
            }
            catch (SQLException sQLException) {
                throw DbException.convert(sQLException);
            }
        }
    }

    static class Portal {
        String name;
        int[] resultColumnFormat;
        Prepared prep;

        Portal() {
        }
    }

    static class Prepared {
        String name;
        String sql;
        JdbcPreparedStatement prep;
        int[] paramType;

        Prepared() {
        }
    }
}

