/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.store;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import plan.org.h2.store.DataHandler;
import plan.org.h2.store.LobStorageInterface;
import plan.org.h2.store.LobStorageRemoteInputStream;
import plan.org.h2.value.Value;
import plan.org.h2.value.ValueLobDb;

public class LobStorageFrontend
implements LobStorageInterface {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    public static final int TABLE_TEMP = -2;
    public static final int TABLE_RESULT = -3;
    private final DataHandler handler;

    public LobStorageFrontend(DataHandler dataHandler) {
        this.handler = dataHandler;
    }

    @Override
    public void removeLob(ValueLobDb valueLobDb) {
    }

    @Override
    public InputStream getInputStream(ValueLobDb valueLobDb, byte[] byArray, long l) throws IOException {
        if (l < 0L) {
            l = Long.MAX_VALUE;
        }
        return new BufferedInputStream(new LobStorageRemoteInputStream(this.handler, valueLobDb, byArray, l));
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ValueLobDb copyLob(ValueLobDb valueLobDb, int n, long l) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeAllForTable(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Value createBlob(InputStream inputStream, long l) {
        return ValueLobDb.createTempBlob(inputStream, l, this.handler);
    }

    @Override
    public Value createClob(Reader reader, long l) {
        return ValueLobDb.createTempClob(reader, l, this.handler);
    }

    @Override
    public void init() {
    }
}

