/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.table;

import plan.org.h2.command.Parser;
import plan.org.h2.command.ddl.CreateSynonymData;
import plan.org.h2.engine.Session;
import plan.org.h2.message.DbException;
import plan.org.h2.schema.Schema;
import plan.org.h2.schema.SchemaObjectBase;
import plan.org.h2.table.Table;

public class TableSynonym
extends SchemaObjectBase {
    private CreateSynonymData data;
    private Table synonymFor;

    public TableSynonym(CreateSynonymData createSynonymData) {
        super(createSynonymData.schema, createSynonymData.id, createSynonymData.synonymName, 11);
        this.data = createSynonymData;
    }

    public Table getSynonymFor() {
        return this.synonymFor;
    }

    public void updateData(CreateSynonymData createSynonymData) {
        this.data = createSynonymData;
    }

    @Override
    public int getType() {
        return 15;
    }

    @Override
    public String getCreateSQLForCopy(Table table, String string) {
        return this.synonymFor.getCreateSQLForCopy(table, string);
    }

    @Override
    public void rename(String string) {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    @Override
    public void removeChildrenAndResources(Session session) {
        this.synonymFor.removeSynonym(this);
        this.database.removeMeta(session, this.getId());
    }

    @Override
    public String getCreateSQL() {
        StringBuilder stringBuilder = new StringBuilder("CREATE SYNONYM ");
        this.getSQL(stringBuilder, true).append(" FOR ");
        Parser.quoteIdentifier(stringBuilder, this.data.synonymForSchema.getName(), true).append('.');
        Parser.quoteIdentifier(stringBuilder, this.data.synonymFor, true);
        return stringBuilder.toString();
    }

    @Override
    public String getDropSQL() {
        StringBuilder stringBuilder = new StringBuilder("DROP SYNONYM ");
        return this.getSQL(stringBuilder, true).toString();
    }

    @Override
    public void checkRename() {
        throw DbException.getUnsupportedException("SYNONYM");
    }

    public String getSynonymForName() {
        return this.data.synonymFor;
    }

    public Schema getSynonymForSchema() {
        return this.data.synonymForSchema;
    }

    public boolean isInvalid() {
        return this.synonymFor.isValid();
    }

    public void updateSynonymFor() {
        if (this.synonymFor != null) {
            this.synonymFor.removeSynonym(this);
        }
        this.synonymFor = this.data.synonymForSchema.getTableOrView(this.data.session, this.data.synonymFor);
        this.synonymFor.addSynonym(this);
    }
}

