/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.util;

public abstract class HashBase {
    private static final long MAX_LOAD = 90L;
    protected int mask;
    protected int len;
    protected int size;
    protected int deletedCount;
    protected int level;
    protected boolean zeroKey;
    private int maxSize;
    private int minSize;
    private int maxDeleted;

    public HashBase() {
        this.reset(2);
    }

    protected abstract void rehash(int var1);

    public int size() {
        return this.size + (this.zeroKey ? 1 : 0);
    }

    void checkSizePut() {
        if (this.deletedCount > this.size) {
            this.rehash(this.level);
        }
        if (this.size + this.deletedCount >= this.maxSize) {
            this.rehash(this.level + 1);
        }
    }

    protected void checkSizeRemove() {
        if (this.size < this.minSize && this.level > 0) {
            this.rehash(this.level - 1);
        } else if (this.deletedCount > this.maxDeleted) {
            this.rehash(this.level);
        }
    }

    protected void reset(int n) {
        if (n > 30) {
            throw new IllegalStateException("exceeded max size of hash table");
        }
        this.size = 0;
        this.level = n;
        this.len = 2 << this.level;
        this.mask = this.len - 1;
        this.minSize = (int)((long)(1 << this.level) * 90L / 100L);
        this.maxSize = (int)((long)this.len * 90L / 100L);
        this.deletedCount = 0;
        this.maxDeleted = 20 + this.len / 2;
    }

    protected int getIndex(int n) {
        return n & this.mask;
    }
}

