/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import plan.org.h2.engine.Mode;
import plan.org.h2.util.StringUtils;
import plan.org.h2.value.CompareMode;
import plan.org.h2.value.ExtTypeInfo;
import plan.org.h2.value.TypeInfo;
import plan.org.h2.value.Value;

public class ValueEnumBase
extends Value {
    private final String label;
    private final int ordinal;

    protected ValueEnumBase(String string, int n) {
        this.label = string;
        this.ordinal = n;
    }

    @Override
    public Value add(Value value) {
        Value value2 = value.convertTo(4);
        return this.convertTo(4).add(value2);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        return Integer.compare(this.getInt(), value.getInt());
    }

    @Override
    public Value divide(Value value) {
        Value value2 = value.convertTo(4);
        return this.convertTo(4).divide(value2);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueEnumBase && this.getInt() == ((ValueEnumBase)object).getInt();
    }

    public static ValueEnumBase get(String string, int n) {
        return new ValueEnumBase(string, n);
    }

    @Override
    public int getInt() {
        return this.ordinal;
    }

    @Override
    public long getLong() {
        return this.ordinal;
    }

    @Override
    public Object getObject() {
        return this.label;
    }

    @Override
    public int getSignum() {
        return Integer.signum(this.ordinal);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        return StringUtils.quoteStringSQL(stringBuilder, this.label);
    }

    @Override
    public String getString() {
        return this.label;
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_ENUM_UNDEFINED;
    }

    @Override
    public int getValueType() {
        return 25;
    }

    @Override
    public int getMemory() {
        return 120;
    }

    @Override
    public int hashCode() {
        int n = 31;
        n += this.getString().hashCode();
        return n += this.getInt();
    }

    @Override
    public Value modulus(Value value) {
        Value value2 = value.convertTo(4);
        return this.convertTo(4).modulus(value2);
    }

    @Override
    public Value multiply(Value value) {
        Value value2 = value.convertTo(4);
        return this.convertTo(4).multiply(value2);
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setInt(n, this.ordinal);
    }

    @Override
    public Value subtract(Value value) {
        Value value2 = value.convertTo(4);
        return this.convertTo(4).subtract(value2);
    }

    @Override
    protected Value convertTo(int n, Mode mode, Object object, ExtTypeInfo extTypeInfo) {
        if (n == 25) {
            return extTypeInfo.cast(this);
        }
        return super.convertTo(n, mode, object, extTypeInfo);
    }
}

