/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.value;

import plan.org.h2.engine.SysProperties;
import plan.org.h2.util.StringUtils;
import plan.org.h2.value.CompareMode;
import plan.org.h2.value.Value;
import plan.org.h2.value.ValueString;

public class ValueStringIgnoreCase
extends ValueString {
    private static final ValueStringIgnoreCase EMPTY = new ValueStringIgnoreCase("");
    private int hash;

    protected ValueStringIgnoreCase(String string) {
        super(string);
    }

    @Override
    public int getValueType() {
        return 14;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        return compareMode.compareString(this.value, ((ValueStringIgnoreCase)value).value, true);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueString && this.value.equalsIgnoreCase(((ValueString)object).value);
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.value.toUpperCase().hashCode();
        }
        return this.hash;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("CAST(");
        return StringUtils.quoteStringSQL(stringBuilder, this.value).append(" AS VARCHAR_IGNORECASE)");
    }

    public static ValueStringIgnoreCase get(String string) {
        int n = string.length();
        if (n == 0) {
            return EMPTY;
        }
        ValueStringIgnoreCase valueStringIgnoreCase = new ValueStringIgnoreCase(StringUtils.cache(string));
        if (n > SysProperties.OBJECT_CACHE_MAX_PER_ELEMENT_SIZE) {
            return valueStringIgnoreCase;
        }
        ValueStringIgnoreCase valueStringIgnoreCase2 = (ValueStringIgnoreCase)Value.cache(valueStringIgnoreCase);
        if (valueStringIgnoreCase2.value.equals(string)) {
            return valueStringIgnoreCase2;
        }
        return valueStringIgnoreCase;
    }

    @Override
    protected ValueString getNew(String string) {
        return ValueStringIgnoreCase.get(string);
    }
}

