/*
 * Decompiled with CFR 0.152.
 */
package plan.org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import plan.org.h2.message.DbException;
import plan.org.h2.util.DateTimeUtils;
import plan.org.h2.value.CompareMode;
import plan.org.h2.value.TypeInfo;
import plan.org.h2.value.Value;

public class ValueTime
extends Value {
    public static final int DEFAULT_PRECISION = 8;
    public static final int MAXIMUM_PRECISION = 18;
    static final int DEFAULT_SCALE = 0;
    public static final int MAXIMUM_SCALE = 9;
    private final long nanos;

    private ValueTime(long l) {
        this.nanos = l;
    }

    public static ValueTime fromNanos(long l) {
        if (l < 0L || l >= 86400000000000L) {
            StringBuilder stringBuilder = new StringBuilder();
            DateTimeUtils.appendTime(stringBuilder, l);
            throw DbException.get(22007, "TIME", stringBuilder.toString());
        }
        return (ValueTime)Value.cache(new ValueTime(l));
    }

    public static ValueTime get(Time time) {
        long l = time.getTime();
        return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalMillis(l + (long)DateTimeUtils.getTimeZoneOffset(l)));
    }

    public static ValueTime fromMillis(long l) {
        return ValueTime.fromNanos(DateTimeUtils.nanosFromLocalMillis(l + (long)DateTimeUtils.getTimeZoneOffset(l)));
    }

    public static ValueTime parse(String string) {
        try {
            return ValueTime.fromNanos(DateTimeUtils.parseTimeNanos(string, 0, string.length()));
        }
        catch (Exception exception) {
            throw DbException.get(22007, exception, "TIME", string);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    @Override
    public Time getTime() {
        return DateTimeUtils.convertNanoToTime(this.nanos);
    }

    @Override
    public TypeInfo getType() {
        return TypeInfo.TYPE_TIME;
    }

    @Override
    public int getValueType() {
        return 9;
    }

    @Override
    public String getString() {
        StringBuilder stringBuilder = new StringBuilder(18);
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.toString();
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        stringBuilder.append("TIME '");
        DateTimeUtils.appendTime(stringBuilder, this.nanos);
        return stringBuilder.append('\'');
    }

    @Override
    public boolean checkPrecision(long l) {
        return true;
    }

    @Override
    public Value convertScale(boolean bl, int n) {
        if (n >= 9) {
            return this;
        }
        if (n < 0) {
            throw DbException.getInvalidValueException("scale", n);
        }
        long l = this.nanos;
        long l2 = DateTimeUtils.convertScale(l, n);
        if (l2 == l) {
            return this;
        }
        if (l2 >= 86400000000000L) {
            l2 = 86399999999999L;
        }
        return ValueTime.fromNanos(l2);
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode) {
        return Long.compare(this.nanos, ((ValueTime)value).nanos);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        return object instanceof ValueTime && this.nanos == ((ValueTime)object).nanos;
    }

    @Override
    public int hashCode() {
        return (int)(this.nanos ^ this.nanos >>> 32);
    }

    @Override
    public Object getObject() {
        return this.getTime();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setTime(n, this.getTime());
    }

    @Override
    public Value add(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos + valueTime.getNanos());
    }

    @Override
    public Value subtract(Value value) {
        ValueTime valueTime = (ValueTime)value.convertTo(9);
        return ValueTime.fromNanos(this.nanos - valueTime.getNanos());
    }

    @Override
    public Value multiply(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos * value.getDouble()));
    }

    @Override
    public Value divide(Value value) {
        return ValueTime.fromNanos((long)((double)this.nanos / value.getDouble()));
    }
}

