/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.rojo8399.placeholderapi.ExpansionBuilder;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.utils.TextUtils;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;

public interface PlaceholderService {
    public static final Pattern DEFAULT_PATTERN = Pattern.compile("[%\\{]([^ \\{\\}%]+)[\\}%]");

    public <S, O, V> ExpansionBuilder<S, O, V, ? extends ExpansionBuilder<S, O, V, ?>> builder(Class<? extends S> var1, Class<? extends O> var2, Class<? extends V> var3);

    public Map<String, Object> fillPlaceholders(TextTemplate var1, Object var2, Object var3);

    default public Pattern getDefaultPattern() {
        return DEFAULT_PATTERN;
    }

    public boolean isRegistered(String var1);

    public ExpansionBuilder<?, ?, ?, ? extends ExpansionBuilder<?, ?, ?, ?>> load(Object var1, String var2, Object var3);

    public List<? extends ExpansionBuilder<?, ?, ?, ? extends ExpansionBuilder<?, ?, ?, ?>>> loadAll(Object var1, Object var2);

    public Object parse(String var1, Object var2, Object var3);

    default public <T> Optional<T> parse(String placeholder, Object source, Object observer, Class<T> expected) {
        return TypeUtils.tryCast(this.parse(placeholder, source, observer), expected);
    }

    default public Map<String, Object> parseAll(List<String> placeholders, Object source, Object observer) {
        return placeholders.stream().collect(Collectors.toMap(s -> s, s -> this.parse((String)s, source, observer)));
    }

    default public <T> T parseNullable(String placeholder, Object source, Object observer, Class<T> expected) {
        return this.parse(placeholder, source, observer, expected).orElse(null);
    }

    public boolean registerExpansion(Expansion<?, ?, ?> var1);

    public <T> void registerTypeDeserializer(TypeToken<T> var1, Function<String, T> var2);

    default public Text replacePlaceholders(String text, Object source, Object observer) {
        return this.replacePlaceholders(text, source, observer, DEFAULT_PATTERN);
    }

    default public Text replacePlaceholders(String text, Object source, Object observer, Pattern pattern) {
        return this.replacePlaceholders(TextUtils.parse(text, pattern), source, observer);
    }

    default public Text replacePlaceholders(Text text, Object source, Object observer) {
        return this.replacePlaceholders(text, source, observer, DEFAULT_PATTERN);
    }

    default public Text replacePlaceholders(Text text, Object source, Object observer, Pattern pattern) {
        return this.replacePlaceholders(TextUtils.toTemplate(text, pattern), source, observer);
    }

    public Text replacePlaceholders(TextTemplate var1, Object var2, Object var3);

    default public Text replaceSourcePlaceholders(String text, Object source) {
        return this.replaceSourcePlaceholders(text, source, DEFAULT_PATTERN);
    }

    default public Text replaceSourcePlaceholders(String text, Object source, Pattern pattern) {
        return this.replacePlaceholders(text, source, source, pattern);
    }

    default public Text replaceSourcePlaceholders(Text text, Object source) {
        return this.replaceSourcePlaceholders(text, source, DEFAULT_PATTERN);
    }

    default public Text replaceSourcePlaceholders(Text text, Object source, Pattern pattern) {
        return this.replacePlaceholders(text, source, source, pattern);
    }

    default public Text replaceSourcePlaceholders(TextTemplate template, Object source) {
        return this.replacePlaceholders(template, source, source);
    }

    default public boolean verifyObserver(Object target) {
        return this.verifySource(target);
    }

    public boolean verifySource(Object var1);
}

