/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.scheduler.Scheduler;
import org.spongepowered.api.scheduler.Task;

public class Metrics {
    public static final int B_STATS_VERSION = 1;
    private static boolean created = false;
    private static final List<Object> knownMetricsInstances = new ArrayList<Object>();
    private static final String URL = "https://bStats.org/submitData/sponge";
    private final List<CustomChart> charts;
    private Path configDir;
    private boolean enabled;
    private boolean logFailedRequests;
    private Logger logger;
    private final PluginContainer plugin;
    private String serverUUID;

    private static byte[] compress(String str) throws IOException {
        if (str == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(outputStream);
        gzip.write(str.getBytes("UTF-8"));
        gzip.close();
        return outputStream.toByteArray();
    }

    public static void linkMetrics(Object metrics) {
        knownMetricsInstances.add(metrics);
    }

    private static void sendData(JsonObject data) throws Exception {
        Validate.notNull((Object)data, (String)"Data cannot be null", (Object[])new Object[0]);
        HttpsURLConnection connection = (HttpsURLConnection)new URL(URL).openConnection();
        byte[] compressedData = Metrics.compress(data.toString());
        connection.setRequestMethod("POST");
        connection.addRequestProperty("Accept", "application/json");
        connection.addRequestProperty("Connection", "close");
        connection.addRequestProperty("Content-Encoding", "gzip");
        connection.addRequestProperty("Content-Length", String.valueOf(compressedData.length));
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "MC-Server/1");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.write(compressedData);
        outputStream.flush();
        outputStream.close();
        connection.getInputStream().close();
    }

    @Inject
    private Metrics(PluginContainer plugin, Logger logger, @ConfigDir(sharedRoot=true) Path configDir) {
        block9: {
            this.charts = new ArrayList<CustomChart>();
            this.logFailedRequests = false;
            if (created) {
                throw new IllegalStateException("There's already an instance of this Metrics class!");
            }
            created = true;
            this.plugin = plugin;
            this.logger = logger;
            this.configDir = configDir;
            try {
                this.loadConfig();
            }
            catch (IOException e) {
                logger.warn("Failed to load bStats config!", (Throwable)e);
                return;
            }
            if (!this.enabled) {
                return;
            }
            Class<?> usedMetricsClass = this.getFirstBStatsClass();
            if (usedMetricsClass == null) {
                return;
            }
            if (usedMetricsClass == this.getClass()) {
                Metrics.linkMetrics(this);
                this.startSubmitting();
            } else {
                try {
                    usedMetricsClass.getMethod("linkMetrics", Object.class).invoke(null, this);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!this.logFailedRequests) break block9;
                    logger.warn("Failed to link to first metrics class {}!", (Object)usedMetricsClass.getName(), (Object)e);
                }
            }
        }
    }

    public void addCustomChart(CustomChart chart) {
        Validate.notNull((Object)chart, (String)"Chart cannot be null", (Object[])new Object[0]);
        this.charts.add(chart);
    }

    private Class<?> getFirstBStatsClass() {
        Path configPath = this.configDir.resolve("bStats");
        configPath.toFile().mkdirs();
        File tempFile = new File(configPath.toFile(), "temp.txt");
        try {
            String className = this.readFile(tempFile);
            if (className != null) {
                try {
                    return Class.forName(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.writeFile(tempFile, this.getClass().getName());
            return this.getClass();
        }
        catch (IOException e) {
            if (this.logFailedRequests) {
                this.logger.warn("Failed to get first bStats class!", (Throwable)e);
            }
            return null;
        }
    }

    public JsonObject getPluginData() {
        JsonObject data = new JsonObject();
        String pluginName = this.plugin.getName();
        String pluginVersion = this.plugin.getVersion().orElse("unknown");
        data.addProperty("pluginName", pluginName);
        data.addProperty("pluginVersion", pluginVersion);
        JsonArray customCharts = new JsonArray();
        for (CustomChart customChart : this.charts) {
            JsonObject chart = customChart.getRequestJsonObject(this.logger, this.logFailedRequests);
            if (chart == null) continue;
            customCharts.add((JsonElement)chart);
        }
        data.add("customCharts", (JsonElement)customCharts);
        return data;
    }

    private JsonObject getServerData() {
        int playerAmount = Sponge.getServer().getOnlinePlayers().size();
        playerAmount = playerAmount > 200 ? 200 : playerAmount;
        int onlineMode = Sponge.getServer().getOnlineMode() ? 1 : 0;
        String minecraftVersion = Sponge.getGame().getPlatform().getMinecraftVersion().getName();
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String osVersion = System.getProperty("os.version");
        int coreCount = Runtime.getRuntime().availableProcessors();
        JsonObject data = new JsonObject();
        data.addProperty("serverUUID", this.serverUUID);
        data.addProperty("playerAmount", (Number)playerAmount);
        data.addProperty("onlineMode", (Number)onlineMode);
        data.addProperty("minecraftVersion", minecraftVersion);
        data.addProperty("javaVersion", javaVersion);
        data.addProperty("osName", osName);
        data.addProperty("osArch", osArch);
        data.addProperty("osVersion", osVersion);
        data.addProperty("coreCount", (Number)coreCount);
        return data;
    }

    private void loadConfig() throws IOException {
        CommentedConfigurationNode node;
        Path configPath = this.configDir.resolve("bStats");
        configPath.toFile().mkdirs();
        File configFile = new File(configPath.toFile(), "config.conf");
        HoconConfigurationLoader configurationLoader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(configFile)).build();
        if (!configFile.exists()) {
            configFile.createNewFile();
            node = (CommentedConfigurationNode)configurationLoader.load();
            node.getNode(new Object[]{"enabled"}).setValue((Object)true);
            node.getNode(new Object[]{"serverUuid"}).setValue((Object)UUID.randomUUID().toString());
            node.getNode(new Object[]{"logFailedRequests"}).setValue((Object)false);
            node.getNode(new Object[]{"enabled"}).setComment("bStats collects some data for plugin authors like how many servers are using their plugins.\nTo honor their work, you should not disable it.\nThis has nearly no effect on the server performance!\nCheck out https://bStats.org/ to learn more :)");
            configurationLoader.save((ConfigurationNode)node);
        } else {
            node = (CommentedConfigurationNode)configurationLoader.load();
        }
        this.enabled = node.getNode(new Object[]{"enabled"}).getBoolean(true);
        this.serverUUID = node.getNode(new Object[]{"serverUuid"}).getString();
        this.logFailedRequests = node.getNode(new Object[]{"logFailedRequests"}).getBoolean(false);
    }

    /*
     * Exception decompiling
     */
    private String readFile(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void startSubmitting() {
        final Timer timer = new Timer(true);
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (!Sponge.getPluginManager().isLoaded(Metrics.this.plugin.getId())) {
                    timer.cancel();
                    return;
                }
                Scheduler scheduler = Sponge.getScheduler();
                Task.Builder taskBuilder = scheduler.createTaskBuilder();
                taskBuilder.execute(() -> Metrics.this.submitData()).submit((Object)Metrics.this.plugin);
            }
        }, 300000L, 1800000L);
    }

    private void submitData() {
        JsonObject data = this.getServerData();
        JsonArray pluginData = new JsonArray();
        for (Object metrics : knownMetricsInstances) {
            try {
                Object plugin = metrics.getClass().getMethod("getPluginData", new Class[0]).invoke(metrics, new Object[0]);
                if (!(plugin instanceof JsonObject)) continue;
                pluginData.add((JsonElement)((JsonObject)plugin));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {}
        }
        data.add("plugins", (JsonElement)pluginData);
        new Thread(() -> {
            block2: {
                try {
                    Metrics.sendData(data);
                }
                catch (Exception e) {
                    if (!this.logFailedRequests) break block2;
                    this.logger.warn("Could not submit plugin stats!", (Throwable)e);
                }
            }
        }).start();
    }

    private void writeFile(File file, String text) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        try (FileWriter fileWriter = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);){
            bufferedWriter.write(text);
            bufferedWriter.newLine();
            bufferedWriter.write("Note: This class only exists for internal purpose. You can ignore it :)");
        }
    }

    static {
        String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
        String examplePackage = new String(new byte[]{121, 111, 117, 114, 46, 112, 97, 99, 107, 97, 103, 101});
        if (Metrics.class.getPackage().getName().equals(defaultPackage) || Metrics.class.getPackage().getName().equals(examplePackage)) {
            throw new IllegalStateException("bStats Metrics class has not been relocated correctly!");
        }
    }

    public static abstract class SingleLineChart
    extends CustomChart {
        public SingleLineChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            int value = this.getValue();
            if (value == 0) {
                return null;
            }
            data.addProperty("value", (Number)value);
            return data;
        }

        public abstract int getValue();
    }

    public static abstract class SimplePie
    extends CustomChart {
        public SimplePie(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            String value = this.getValue();
            if (value == null || value.isEmpty()) {
                return null;
            }
            data.addProperty("value", value);
            return data;
        }

        public abstract String getValue();
    }

    public static abstract class SimpleMapChart
    extends CustomChart {
        public SimpleMapChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            Country value = this.getValue();
            if (value == null) {
                return null;
            }
            data.addProperty("value", value.getCountryIsoTag());
            return data;
        }

        public abstract Country getValue();
    }

    public static abstract class SimpleBarChart
    extends CustomChart {
        public SimpleBarChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                JsonArray categoryValues = new JsonArray();
                categoryValues.add((JsonElement)new JsonPrimitive((Number)entry.getValue()));
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            data.add("values", (JsonElement)values);
            return data;
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);
    }

    public static abstract class MultiLineChart
    extends CustomChart {
        public MultiLineChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);
    }

    public static abstract class CustomChart {
        protected final String chartId;

        public CustomChart(String chartId) {
            if (chartId == null || chartId.isEmpty()) {
                throw new IllegalArgumentException("ChartId cannot be null or empty!");
            }
            this.chartId = chartId;
        }

        protected abstract JsonObject getChartData();

        protected JsonObject getRequestJsonObject(Logger logger, boolean logFailedRequests) {
            JsonObject chart = new JsonObject();
            chart.addProperty("chartId", this.chartId);
            try {
                JsonObject data = this.getChartData();
                if (data == null) {
                    return null;
                }
                chart.add("data", (JsonElement)data);
            }
            catch (Throwable t) {
                if (logFailedRequests) {
                    logger.warn("Failed to get data for custom chart with id {}", (Object)this.chartId, (Object)t);
                }
                return null;
            }
            return chart;
        }
    }

    public static enum Country {
        AFGHANISTAN("AF", "Afghanistan"),
        ALAND_ISLANDS("AX", "\u00c5land Islands"),
        ALBANIA("AL", "Albania"),
        ALGERIA("DZ", "Algeria"),
        AMERICAN_SAMOA("AS", "American Samoa"),
        ANDORRA("AD", "Andorra"),
        ANGOLA("AO", "Angola"),
        ANGUILLA("AI", "Anguilla"),
        ANTARCTICA("AQ", "Antarctica"),
        ANTIGUA_AND_BARBUDA("AG", "Antigua and Barbuda"),
        ARGENTINA("AR", "Argentina"),
        ARMENIA("AM", "Armenia"),
        ARUBA("AW", "Aruba"),
        AUSTRALIA("AU", "Australia"),
        AUSTRIA("AT", "Austria"),
        AUTO_DETECT("AUTO", "Auto Detected"),
        AZERBAIJAN("AZ", "Azerbaijan"),
        BAHAMAS("BS", "Bahamas"),
        BAHRAIN("BH", "Bahrain"),
        BANGLADESH("BD", "Bangladesh"),
        BARBADOS("BB", "Barbados"),
        BELARUS("BY", "Belarus"),
        BELGIUM("BE", "Belgium"),
        BELIZE("BZ", "Belize"),
        BENIN("BJ", "Benin"),
        BERMUDA("BM", "Bermuda"),
        BHUTAN("BT", "Bhutan"),
        BOLIVIA("BO", "Bolivia"),
        BONAIRE_SINT_EUSTATIUS_AND_SABA("BQ", "Bonaire, Sint Eustatius and Saba"),
        BOSNIA_AND_HERZEGOVINA("BA", "Bosnia and Herzegovina"),
        BOTSWANA("BW", "Botswana"),
        BOUVET_ISLAND("BV", "Bouvet Island"),
        BRAZIL("BR", "Brazil"),
        BRITISH_INDIAN_OCEAN_TERRITORY("IO", "British Indian Ocean Territory"),
        BRITISH_VIRGIN_ISLANDS("VG", "British Virgin Islands"),
        BRUNEI("BN", "Brunei"),
        BULGARIA("BG", "Bulgaria"),
        BURKINA_FASO("BF", "Burkina Faso"),
        BURUNDI("BI", "Burundi"),
        CAMBODIA("KH", "Cambodia"),
        CAMEROON("CM", "Cameroon"),
        CANADA("CA", "Canada"),
        CAPE_VERDE("CV", "Cape Verde"),
        CAYMAN_ISLANDS("KY", "Cayman Islands"),
        CENTRAL_AFRICAN_REPUBLIC("CF", "Central African Republic"),
        CHAD("TD", "Chad"),
        CHILE("CL", "Chile"),
        CHINA("CN", "China"),
        CHRISTMAS_ISLAND("CX", "Christmas Island"),
        COCOS_ISLANDS("CC", "Cocos Islands"),
        COLOMBIA("CO", "Colombia"),
        COMOROS("KM", "Comoros"),
        CONGO("CG", "Congo"),
        COOK_ISLANDS("CK", "Cook Islands"),
        COSTA_RICA("CR", "Costa Rica"),
        COTE_D_IVOIRE("CI", "C\u00f4te d'Ivoire"),
        CROATIA("HR", "Croatia"),
        CUBA("CU", "Cuba"),
        CURACAO("CW", "Cura\u00e7ao"),
        CYPRUS("CY", "Cyprus"),
        CZECH_REPUBLIC("CZ", "Czech Republic"),
        DENMARK("DK", "Denmark"),
        DJIBOUTI("DJ", "Djibouti"),
        DOMINICA("DM", "Dominica"),
        DOMINICAN_REPUBLIC("DO", "Dominican Republic"),
        ECUADOR("EC", "Ecuador"),
        EGYPT("EG", "Egypt"),
        EL_SALVADOR("SV", "El Salvador"),
        EQUATORIAL_GUINEA("GQ", "Equatorial Guinea"),
        ERITREA("ER", "Eritrea"),
        ESTONIA("EE", "Estonia"),
        ETHIOPIA("ET", "Ethiopia"),
        FALKLAND_ISLANDS("FK", "Falkland Islands"),
        FAROE_ISLANDS("FO", "Faroe Islands"),
        FIJI("FJ", "Fiji"),
        FINLAND("FI", "Finland"),
        FRANCE("FR", "France"),
        FRENCH_GUIANA("GF", "French Guiana"),
        FRENCH_POLYNESIA("PF", "French Polynesia"),
        FRENCH_SOUTHERN_TERRITORIES("TF", "French Southern Territories"),
        GABON("GA", "Gabon"),
        GAMBIA("GM", "Gambia"),
        GEORGIA("GE", "Georgia"),
        GERMANY("DE", "Germany"),
        GHANA("GH", "Ghana"),
        GIBRALTAR("GI", "Gibraltar"),
        GREECE("GR", "Greece"),
        GREENLAND("GL", "Greenland"),
        GRENADA("GD", "Grenada"),
        GUADELOUPE("GP", "Guadeloupe"),
        GUAM("GU", "Guam"),
        GUATEMALA("GT", "Guatemala"),
        GUERNSEY("GG", "Guernsey"),
        GUINEA("GN", "Guinea"),
        GUINEA_BISSAU("GW", "Guinea-Bissau"),
        GUYANA("GY", "Guyana"),
        HAITI("HT", "Haiti"),
        HEARD_ISLAND_AND_MCDONALD_ISLANDS("HM", "Heard Island And McDonald Islands"),
        HONDURAS("HN", "Honduras"),
        HONG_KONG("HK", "Hong Kong"),
        HUNGARY("HU", "Hungary"),
        ICELAND("IS", "Iceland"),
        INDIA("IN", "India"),
        INDONESIA("ID", "Indonesia"),
        IRAN("IR", "Iran"),
        IRAQ("IQ", "Iraq"),
        IRELAND("IE", "Ireland"),
        ISLE_OF_MAN("IM", "Isle Of Man"),
        ISRAEL("IL", "Israel"),
        ITALY("IT", "Italy"),
        JAMAICA("JM", "Jamaica"),
        JAPAN("JP", "Japan"),
        JERSEY("JE", "Jersey"),
        JORDAN("JO", "Jordan"),
        KAZAKHSTAN("KZ", "Kazakhstan"),
        KENYA("KE", "Kenya"),
        KIRIBATI("KI", "Kiribati"),
        KUWAIT("KW", "Kuwait"),
        KYRGYZSTAN("KG", "Kyrgyzstan"),
        LAOS("LA", "Laos"),
        LATVIA("LV", "Latvia"),
        LEBANON("LB", "Lebanon"),
        LESOTHO("LS", "Lesotho"),
        LIBERIA("LR", "Liberia"),
        LIBYA("LY", "Libya"),
        LIECHTENSTEIN("LI", "Liechtenstein"),
        LITHUANIA("LT", "Lithuania"),
        LUXEMBOURG("LU", "Luxembourg"),
        MACAO("MO", "Macao"),
        MACEDONIA("MK", "Macedonia"),
        MADAGASCAR("MG", "Madagascar"),
        MALAWI("MW", "Malawi"),
        MALAYSIA("MY", "Malaysia"),
        MALDIVES("MV", "Maldives"),
        MALI("ML", "Mali"),
        MALTA("MT", "Malta"),
        MARSHALL_ISLANDS("MH", "Marshall Islands"),
        MARTINIQUE("MQ", "Martinique"),
        MAURITANIA("MR", "Mauritania"),
        MAURITIUS("MU", "Mauritius"),
        MAYOTTE("YT", "Mayotte"),
        MEXICO("MX", "Mexico"),
        MICRONESIA("FM", "Micronesia"),
        MOLDOVA("MD", "Moldova"),
        MONACO("MC", "Monaco"),
        MONGOLIA("MN", "Mongolia"),
        MONTENEGRO("ME", "Montenegro"),
        MONTSERRAT("MS", "Montserrat"),
        MOROCCO("MA", "Morocco"),
        MOZAMBIQUE("MZ", "Mozambique"),
        MYANMAR("MM", "Myanmar"),
        NAMIBIA("NA", "Namibia"),
        NAURU("NR", "Nauru"),
        NEPAL("NP", "Nepal"),
        NETHERLANDS("NL", "Netherlands"),
        NETHERLANDS_ANTILLES("AN", "Netherlands Antilles"),
        NEW_CALEDONIA("NC", "New Caledonia"),
        NEW_ZEALAND("NZ", "New Zealand"),
        NICARAGUA("NI", "Nicaragua"),
        NIGER("NE", "Niger"),
        NIGERIA("NG", "Nigeria"),
        NIUE("NU", "Niue"),
        NORFOLK_ISLAND("NF", "Norfolk Island"),
        NORTH_KOREA("KP", "North Korea"),
        NORTHERN_MARIANA_ISLANDS("MP", "Northern Mariana Islands"),
        NORWAY("NO", "Norway"),
        OMAN("OM", "Oman"),
        PAKISTAN("PK", "Pakistan"),
        PALAU("PW", "Palau"),
        PALESTINE("PS", "Palestine"),
        PANAMA("PA", "Panama"),
        PAPUA_NEW_GUINEA("PG", "Papua New Guinea"),
        PARAGUAY("PY", "Paraguay"),
        PERU("PE", "Peru"),
        PHILIPPINES("PH", "Philippines"),
        PITCAIRN("PN", "Pitcairn"),
        POLAND("PL", "Poland"),
        PORTUGAL("PT", "Portugal"),
        PUERTO_RICO("PR", "Puerto Rico"),
        QATAR("QA", "Qatar"),
        REUNION("RE", "Reunion"),
        ROMANIA("RO", "Romania"),
        RUSSIA("RU", "Russia"),
        RWANDA("RW", "Rwanda"),
        SAINT_BARTHELEMY("BL", "Saint Barth\u00e9lemy"),
        SAINT_HELENA("SH", "Saint Helena"),
        SAINT_KITTS_AND_NEVIS("KN", "Saint Kitts And Nevis"),
        SAINT_LUCIA("LC", "Saint Lucia"),
        SAINT_MARTIN("MF", "Saint Martin"),
        SAINT_PIERRE_AND_MIQUELON("PM", "Saint Pierre And Miquelon"),
        SAINT_VINCENT_AND_THE_GRENADINES("VC", "Saint Vincent And The Grenadines"),
        SAMOA("WS", "Samoa"),
        SAN_MARINO("SM", "San Marino"),
        SAO_TOME_AND_PRINCIPE("ST", "Sao Tome And Principe"),
        SAUDI_ARABIA("SA", "Saudi Arabia"),
        SENEGAL("SN", "Senegal"),
        SERBIA("RS", "Serbia"),
        SEYCHELLES("SC", "Seychelles"),
        SIERRA_LEONE("SL", "Sierra Leone"),
        SINGAPORE("SG", "Singapore"),
        SINT_MAARTEN_DUTCH_PART("SX", "Sint Maarten (Dutch part)"),
        SLOVAKIA("SK", "Slovakia"),
        SLOVENIA("SI", "Slovenia"),
        SOLOMON_ISLANDS("SB", "Solomon Islands"),
        SOMALIA("SO", "Somalia"),
        SOUTH_AFRICA("ZA", "South Africa"),
        SOUTH_GEORGIA_AND_THE_SOUTH_SANDWICH_ISLANDS("GS", "South Georgia And The South Sandwich Islands"),
        SOUTH_KOREA("KR", "South Korea"),
        SOUTH_SUDAN("SS", "South Sudan"),
        SPAIN("ES", "Spain"),
        SRI_LANKA("LK", "Sri Lanka"),
        SUDAN("SD", "Sudan"),
        SURINAME("SR", "Suriname"),
        SVALBARD_AND_JAN_MAYEN("SJ", "Svalbard And Jan Mayen"),
        SWAZILAND("SZ", "Swaziland"),
        SWEDEN("SE", "Sweden"),
        SWITZERLAND("CH", "Switzerland"),
        SYRIA("SY", "Syria"),
        TAIWAN("TW", "Taiwan"),
        TAJIKISTAN("TJ", "Tajikistan"),
        TANZANIA("TZ", "Tanzania"),
        THAILAND("TH", "Thailand"),
        THE_DEMOCRATIC_REPUBLIC_OF_CONGO("CD", "The Democratic Republic Of Congo"),
        TIMOR_LESTE("TL", "Timor-Leste"),
        TOGO("TG", "Togo"),
        TOKELAU("TK", "Tokelau"),
        TONGA("TO", "Tonga"),
        TRINIDAD_AND_TOBAGO("TT", "Trinidad and Tobago"),
        TUNISIA("TN", "Tunisia"),
        TURKEY("TR", "Turkey"),
        TURKMENISTAN("TM", "Turkmenistan"),
        TURKS_AND_CAICOS_ISLANDS("TC", "Turks And Caicos Islands"),
        TUVALU("TV", "Tuvalu"),
        U_S__VIRGIN_ISLANDS("VI", "U.S. Virgin Islands"),
        UGANDA("UG", "Uganda"),
        UKRAINE("UA", "Ukraine"),
        UNITED_ARAB_EMIRATES("AE", "United Arab Emirates"),
        UNITED_KINGDOM("GB", "United Kingdom"),
        UNITED_STATES("US", "United States"),
        UNITED_STATES_MINOR_OUTLYING_ISLANDS("UM", "United States Minor Outlying Islands"),
        URUGUAY("UY", "Uruguay"),
        UZBEKISTAN("UZ", "Uzbekistan"),
        VANUATU("VU", "Vanuatu"),
        VATICAN("VA", "Vatican"),
        VENEZUELA("VE", "Venezuela"),
        VIETNAM("VN", "Vietnam"),
        WALLIS_AND_FUTUNA("WF", "Wallis And Futuna"),
        WESTERN_SAHARA("EH", "Western Sahara"),
        YEMEN("YE", "Yemen"),
        ZAMBIA("ZM", "Zambia"),
        ZIMBABWE("ZW", "Zimbabwe");

        private String isoTag;
        private String name;

        public static Country byIsoTag(String isoTag) {
            for (Country country : Country.values()) {
                if (!country.getCountryIsoTag().equals(isoTag)) continue;
                return country;
            }
            return null;
        }

        public static Country byLocale(Locale locale) {
            return Country.byIsoTag(locale.getCountry());
        }

        private Country(String isoTag, String name) {
            this.isoTag = isoTag;
            this.name = name;
        }

        public String getCountryIsoTag() {
            return this.isoTag;
        }

        public String getCountryName() {
            return this.name;
        }
    }

    public static abstract class AdvancedPie
    extends CustomChart {
        public AdvancedPie(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, Integer> map = this.getValues(new HashMap<String, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }

        public abstract HashMap<String, Integer> getValues(HashMap<String, Integer> var1);
    }

    public static abstract class AdvancedMapChart
    extends CustomChart {
        public AdvancedMapChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<Country, Integer> map = this.getValues(new HashMap<Country, Integer>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<Country, Integer> entry : map.entrySet()) {
                if (entry.getValue() == 0) continue;
                allSkipped = false;
                values.addProperty(entry.getKey().getCountryIsoTag(), (Number)entry.getValue());
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }

        public abstract HashMap<Country, Integer> getValues(HashMap<Country, Integer> var1);
    }

    public static abstract class AdvancedBarChart
    extends CustomChart {
        public AdvancedBarChart(String chartId) {
            super(chartId);
        }

        @Override
        protected JsonObject getChartData() {
            JsonObject data = new JsonObject();
            JsonObject values = new JsonObject();
            HashMap<String, int[]> map = this.getValues(new HashMap<String, int[]>());
            if (map == null || map.isEmpty()) {
                return null;
            }
            boolean allSkipped = true;
            for (Map.Entry<String, int[]> entry : map.entrySet()) {
                if (entry.getValue().length == 0) continue;
                allSkipped = false;
                JsonArray categoryValues = new JsonArray();
                for (int categoryValue : entry.getValue()) {
                    categoryValues.add((JsonElement)new JsonPrimitive((Number)categoryValue));
                }
                values.add(entry.getKey(), (JsonElement)categoryValues);
            }
            if (allSkipped) {
                return null;
            }
            data.add("values", (JsonElement)values);
            return data;
        }

        public abstract HashMap<String, int[]> getValues(HashMap<String, int[]> var1);
    }
}

