/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.impl.Metrics;
import me.rojo8399.placeholderapi.impl.PlaceholderServiceImpl;
import me.rojo8399.placeholderapi.impl.commands.InfoCommand;
import me.rojo8399.placeholderapi.impl.commands.ListCommand;
import me.rojo8399.placeholderapi.impl.commands.ParseCommand;
import me.rojo8399.placeholderapi.impl.commands.RefreshCommand;
import me.rojo8399.placeholderapi.impl.configs.Config;
import me.rojo8399.placeholderapi.impl.configs.JavascriptManager;
import me.rojo8399.placeholderapi.impl.configs.Messages;
import me.rojo8399.placeholderapi.impl.placeholder.Defaults;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;
import ninja.leaping.configurate.loader.ConfigurationLoader;
import ninja.leaping.configurate.objectmapping.ObjectMappingException;
import org.slf4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.asset.Asset;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.command.spec.CommandSpec;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.config.DefaultConfig;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GameInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartingServerEvent;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;

@Plugin(id="placeholderapi", name="PlaceholderAPI", version="4.4", authors={"rojo8399", "Wundero"})
public class PlaceholderAPIPlugin {
    private static PlaceholderAPIPlugin instance;
    public static final String PLUGIN_ID = "placeholderapi";
    public static final String PLUGIN_NAME = "PlaceholderAPI";
    public static final String PLUGIN_VERSION = "4.4";
    private Set<Object> alreadyRegistered = new HashSet<Object>();
    private Config config;
    @Inject
    @ConfigDir(sharedRoot=false)
    private Path configDir;
    private DateTimeFormatter formatter;
    @Inject
    private Game game;
    private JavascriptManager jsm;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private ConfigurationLoader<CommentedConfigurationNode> loader;
    @Inject
    private Logger logger;
    @Inject
    private Metrics metrics;
    private ConfigurationLoader<CommentedConfigurationNode> msgloader;
    private ConfigurationNode msgRoot;
    private Messages msgs;
    @Inject
    @DefaultConfig(sharedRoot=false)
    private Path path;
    @Inject
    private PluginContainer plugin;
    private ConfigurationNode root;
    private PlaceholderService s;

    public static PlaceholderAPIPlugin getInstance() {
        return instance;
    }

    public DateTimeFormatter formatter() {
        return this.formatter;
    }

    public Config getConfig() {
        return this.config;
    }

    public Game getGame() {
        return this.game;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ConfigurationNode getRootConfig() {
        return this.root;
    }

    private ConfigurationNode loadDefault() throws IOException {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setURL(((Asset)this.game.getAssetManager().getAsset((Object)this, "config.conf").get()).getUrl())).build().load(this.loader.getDefaultOptions());
    }

    private void mapDefault() throws IOException, ObjectMappingException {
        try {
            this.root = this.loadDefault();
            this.config = (Config)this.root.getValue(Config.type);
        }
        catch (IOException | ObjectMappingException ex) {
            this.logger.error("Could not load the embedded default config! Disabling plugin.");
            this.game.getEventManager().unregisterPluginListeners((Object)this);
            throw ex;
        }
    }

    @Listener
    public void onGameInitializationEvent(GameInitializationEvent event) {
        CommandSpec parseCmd = CommandSpec.builder().arguments(new CommandElement[]{GenericArguments.onlyOne((CommandElement)GenericArguments.player((Text)Text.of((String)"player"))), GenericArguments.remainingJoinedStrings((Text)Text.of((String)"placeholders"))}).executor((CommandExecutor)new ParseCommand()).permission("placeholderapi.admin").build();
        CommandSpec listCmd = CommandSpec.builder().permission("placeholderapi.admin").executor((CommandExecutor)new ListCommand()).build();
        CommandSpec infoCmd = CommandSpec.builder().arguments(GenericArguments.string((Text)Text.of((String)"placeholder"))).permission("placeholderapi.admin").executor((CommandExecutor)new InfoCommand()).build();
        CommandSpec reloadCommand = CommandSpec.builder().arguments(GenericArguments.optional((CommandElement)GenericArguments.string((Text)Text.of((String)"id")))).permission("placeholderapi.admin").executor((CommandExecutor)new RefreshCommand()).build();
        CommandSpec enable = CommandSpec.builder().executor((src, params) -> {
            String id = params.getOne("id").orElse(null);
            if (!Store.get().has(id)) {
                throw new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]));
            }
            Boolean rel = params.getOne("relational").orElse(null);
            if (rel != null) {
                Optional<Expansion<?, ?, ?>> e = Store.get().get(id, rel);
                if (!e.isPresent()) {
                    throw new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]));
                }
                e.get().enable();
                src.sendMessage(Messages.get().placeholder.placeholderEnabled.t(new Object[0]));
                return CommandResult.success();
            }
            Expansion<?, ?, ?> e = Store.get().get(id, false).orElse(Store.get().get(id, false).orElseThrow(() -> new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]))));
            e.enable();
            src.sendMessage(Messages.get().placeholder.placeholderEnabled.t(new Object[0]));
            return CommandResult.success();
        }).arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"id")), GenericArguments.optional((CommandElement)GenericArguments.bool((Text)Text.of((String)"relational")))}).permission("placeholderapi.admin").build();
        CommandSpec disable = CommandSpec.builder().executor((src, params) -> {
            String id = params.getOne("id").orElse(null);
            if (!Store.get().has(id)) {
                throw new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]));
            }
            Boolean rel = params.getOne("relational").orElse(null);
            if (rel != null) {
                Optional<Expansion<?, ?, ?>> e = Store.get().get(id, rel);
                if (!e.isPresent()) {
                    throw new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]));
                }
                e.get().disable();
                src.sendMessage(Messages.get().placeholder.placeholderDisabled.t(new Object[0]));
                return CommandResult.success();
            }
            Expansion<?, ?, ?> e = Store.get().get(id, false).orElse(Store.get().get(id, false).orElseThrow(() -> new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]))));
            e.disable();
            src.sendMessage(Messages.get().placeholder.placeholderDisabled.t(new Object[0]));
            return CommandResult.success();
        }).arguments(new CommandElement[]{GenericArguments.string((Text)Text.of((String)"id")), GenericArguments.optional((CommandElement)GenericArguments.bool((Text)Text.of((String)"relational")))}).permission("placeholderapi.admin").build();
        CommandSpec baseCmd = CommandSpec.builder().executor(new CommandExecutor(){

            public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
                src.sendMessage(Text.of((Object[])new Object[]{TextColors.GREEN, PlaceholderAPIPlugin.PLUGIN_NAME, TextColors.GRAY, " ", Messages.get().misc.version.t(new Object[0]), " ", TextColors.AQUA, PlaceholderAPIPlugin.PLUGIN_VERSION, TextColors.GRAY, "."}));
                return CommandResult.success();
            }
        }).child((CommandCallable)parseCmd, new String[]{"parse", "p"}).child((CommandCallable)listCmd, new String[]{"list", "l"}).child((CommandCallable)infoCmd, new String[]{"info", "i"}).child((CommandCallable)reloadCommand, new String[]{"reload", "r"}).child((CommandCallable)enable, new String[]{"enable"}).child((CommandCallable)disable, new String[]{"disable"}).build();
        this.game.getCommandManager().register((Object)this.plugin, (CommandCallable)baseCmd, new String[]{PLUGIN_ID, "papi"});
    }

    @Listener
    public void onGamePreInitializationEvent(GamePreInitializationEvent event) throws IOException, ObjectMappingException {
        instance = this;
        this.plugin = (PluginContainer)this.game.getPluginManager().getPlugin(PLUGIN_ID).get();
        Asset conf = (Asset)this.game.getAssetManager().getAsset((Object)this, "config.conf").get();
        this.jsm = new JavascriptManager(new File(this.path.toFile().getParentFile(), "javascript"));
        if (!Files.exists(this.path, new LinkOption[0])) {
            try {
                conf.copyToFile(this.path);
            }
            catch (IOException ex) {
                this.logger.error("Could not copy the config file!");
                try {
                    throw ex;
                }
                catch (Throwable throwable) {
                    this.mapDefault();
                    throw throwable;
                }
            }
        }
        try {
            this.root = this.loader.load();
        }
        catch (IOException ex) {
            this.logger.error("Could not load the config file!");
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.mapDefault();
                throw throwable;
            }
        }
        try {
            this.config = (Config)this.root.getValue(Config.type, (Object)new Config());
        }
        catch (ObjectMappingException ex) {
            this.logger.error("Invalid config file!");
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.mapDefault();
                throw throwable;
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.root.setValue(Config.type, (Object)this.config);
            try {
                this.loader.save(this.root);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        File msgFile = new File(this.configDir.toFile(), "messages.conf");
        this.msgloader = ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setFile(msgFile)).build();
        try {
            this.msgRoot = this.msgloader.load();
            this.msgs = (Messages)this.msgRoot.getValue(Messages.type);
            if (this.msgs == null) {
                this.msgs = new Messages();
                this.msgRoot.setValue(Messages.type, (Object)this.msgs);
                this.msgloader.save(this.msgRoot);
            }
        }
        catch (IOException ex) {
            this.logger.error("Could not load the messages file!");
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.msgs = new Messages();
                this.msgRoot.setValue(Messages.type, (Object)this.msgs);
                this.msgloader.save(this.msgRoot);
                throw throwable;
            }
        }
        catch (ObjectMappingException ex) {
            this.logger.error("Invalid messages file!");
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                this.msgs = new Messages();
                this.msgRoot.setValue(Messages.type, (Object)this.msgs);
                this.msgloader.save(this.msgRoot);
                throw throwable;
            }
        }
        Messages.init(this.msgs);
        this.formatter = DateTimeFormatter.ofPattern(this.config.dateFormat == null ? "uuuu LLL dd HH:mm:ss" : this.config.dateFormat);
        this.s = PlaceholderServiceImpl.get();
        this.registerPlaceholders();
        this.game.getServiceManager().setProvider((Object)this, PlaceholderService.class, (Object)this.s);
    }

    @Listener
    public void onGameStartingServerEvent(GameStartingServerEvent event) {
        this.metrics.addCustomChart(new Metrics.SimpleBarChart("placeholders"){

            @Override
            public HashMap<String, Integer> getValues(HashMap<String, Integer> valueMap) {
                List<String> rids = Store.get().ids(true);
                List<String> ids = Store.get().ids(false);
                if (rids.isEmpty() && ids.isEmpty()) {
                    HashMap<String, Integer> out = new HashMap<String, Integer>();
                    out.put("none", 1);
                    return out;
                }
                ArrayList exp = new ArrayList();
                rids.forEach(e -> exp.add("rel_" + e));
                ids.forEach(exp::add);
                return (HashMap)exp.stream().collect(Collectors.toMap(e -> e, e -> 1));
            }
        });
    }

    @Listener
    public void onReload(GameReloadEvent event) throws IOException, ObjectMappingException {
        this.reloadConfig();
        event.getCause().first(Player.class).ifPresent(p -> p.sendMessage(Messages.get().plugin.reloadSuccess.t(new Object[0])));
        this.logger.info("Reloaded PlaceholderAPI");
    }

    @Listener
    public void onStop(GameStoppingEvent event) {
        this.saveConfig();
        Store.get().saveAll();
    }

    public void registerListeners(Object object) {
        this.registerListeners(object, this);
    }

    public void registerListeners(Object object, Object plugin) {
        if (this.alreadyRegistered.contains(object)) {
            return;
        }
        Sponge.getEventManager().registerListeners(plugin, object);
        this.alreadyRegistered.add(object);
    }

    public void registerPlaceholders() {
        EconomyService ex = this.game.getServiceManager().provide(EconomyService.class).orElse(null);
        Defaults handle = new Defaults(ex, this.jsm, this.s);
        this.registerListeners(handle);
        this.s.loadAll(handle, this).stream().map(builder -> {
            switch (builder.getId()) {
                case "player": {
                    if (builder.isRelational()) {
                        return builder.description(Messages.get().placeholder.relplayerdesc.value).tokens("distance", "audible", "visible", "distance_x", "distance_y", "distance_z").version("2.0");
                    }
                    return builder.description(Messages.get().placeholder.playerdesc.value).tokens(null, "prefix", "suffix", "option_[option]", "permission_[permission]", "name", "displayname", "uuid", "can_fly", "world", "ping", "language", "flying", "health", "max_health", "food", "saturation", "gamemode", "x", "y", "z", "direction", "exp", "exp_total", "exp_to_next", "level", "first_join", "fly_speed", "max_air", "remaining_air", "item_in_main_hand", "item_in_off_hand", "walk_speed", "time_played", "time_played_ticks", "time_played_seconds", "time_played_minutes", "time_played_hours", "time_played_days").version("2.0");
                }
                case "rank": {
                    if (builder.isRelational()) {
                        return builder.description(Messages.get().placeholder.relrankdesc.value).tokens("greater_than", "less_than").version("1.0");
                    }
                    return builder.description(Messages.get().placeholder.rankdesc.value).tokens(null, "prefix", "suffix", "name", "permission_[permission]", "option_[option]").version("2.0");
                }
                case "javascript": {
                    return builder.description(Messages.get().placeholder.jsdesc.value).tokens(this.jsm.getScriptNames()).reloadFunction(e -> {
                        try {
                            this.jsm.reloadScripts();
                        }
                        catch (Exception exc) {
                            this.getLogger().warn("Error reloading JavaScript placeholders!");
                            exc.printStackTrace();
                            return false;
                        }
                        e.setTokens(this.jsm.getScriptNames());
                        return true;
                    }).version("2.0");
                }
                case "economy": {
                    return builder.description(Messages.get().placeholder.curdesc.value).tokens("", "[currency]", "balance", "balance_[currency]", "bal_format_[currency]", "bal_format", "display", "display_[currency]", "plural_display_[currency]", "symbol_[currency]", "plural_display", "symbol", "baltop_<number>", "baltop_<number>_[currency]").version("2.0");
                }
                case "server": {
                    return builder.description(Messages.get().placeholder.serverdesc.value).tokens("time_[world]", "game_time_[world]", "unique_players", "online", "max_players", "motd", "cores", "tps", "ram_used", "ram_free", "ram_total", "ram_max", "uptime", "uptime_percent", "uptime_total").version("2.0");
                }
                case "sound": {
                    return builder.description(Messages.get().placeholder.sounddesc.value).tokens("[sound]-[volume]-[pitch]", "[sound]-[volume]-[pitch]_all").version("2.0");
                }
                case "statistic": {
                    return builder.description(Messages.get().placeholder.statdesc.value).version("2.0");
                }
                case "time": {
                    return builder.description(Messages.get().placeholder.timedesc.value).tokens("").version("2.0");
                }
            }
            return builder;
        }).forEach(t -> {
            try {
                String i = t.getId();
                boolean r = t.isRelational();
                t.author("Wundero").plugin(this).buildAndRegister();
                Store.get().get(i, r).ifPresent(e -> e.reloadListeners());
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void reloadConfig() throws IOException, ObjectMappingException {
        try {
            this.root = this.loader.load();
            this.config = (Config)this.root.getValue(Config.type);
        }
        catch (IOException ex) {
            this.logger.error("Could not reload config!");
            throw ex;
        }
        catch (ObjectMappingException ex) {
            this.logger.error("Invalid Config!");
            throw ex;
        }
        try {
            this.msgRoot = this.msgloader.load();
            this.msgs = (Messages)this.msgRoot.getValue(Messages.type);
            if (this.msgs == null) {
                this.msgs = new Messages();
                this.msgRoot.setValue(Messages.type, (Object)this.msgs);
                this.msgloader.save(this.msgRoot);
            }
        }
        catch (IOException ex) {
            this.logger.error("Could not reload config!");
            throw ex;
        }
        catch (ObjectMappingException ex) {
            this.logger.error("Invalid Config!");
            throw ex;
        }
        Messages.init(this.msgs);
    }

    public void saveConfig() {
        try {
            this.loader.save(this.root);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unregisterListeners(Object object) {
        if (this.alreadyRegistered.contains(object)) {
            this.alreadyRegistered.remove(object);
            Sponge.getEventManager().unregisterListeners(object);
        }
    }
}

