/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.rojo8399.placeholderapi.ExpansionBuilder;
import me.rojo8399.placeholderapi.NoValueException;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.configs.Messages;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.ExpansionBuilderImpl;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Locatable;

public class PlaceholderServiceImpl
implements PlaceholderService {
    private static PlaceholderServiceImpl instance;
    private Store store = Store.get();

    public static PlaceholderServiceImpl get() {
        return instance == null ? (instance = new PlaceholderServiceImpl()) : instance;
    }

    private PlaceholderServiceImpl() {
    }

    @Override
    public <S, O, V> ExpansionBuilder<S, O, V, ? extends ExpansionBuilder<S, O, V, ?>> builder(Class<? extends S> s, Class<? extends O> o, Class<? extends V> v) {
        return ExpansionBuilderImpl.builder(s, o, v);
    }

    @Override
    public Map<String, Object> fillPlaceholders(TextTemplate template, Object source, Object observer) {
        this.validate(source, observer);
        return this.rpt(source, observer, template, new HashMap<String, Object>());
    }

    Store getStore() {
        return this.store;
    }

    @Override
    public boolean isRegistered(String id) {
        return this.store.has(id);
    }

    public ExpansionBuilder<?, ?, ?, ?> load(Object handle, String id, Object plugin) {
        return ExpansionBuilderImpl.load(handle, id, plugin);
    }

    public List<? extends ExpansionBuilder<?, ?, ?, ?>> loadAll(Object handle, Object plugin) {
        return ExpansionBuilderImpl.loadAll(handle, plugin);
    }

    @Override
    public Object parse(String placeholder, Object source, Object observer) {
        this.validate(source, observer);
        placeholder = placeholder.trim().toLowerCase();
        if (placeholder.contains("_")) {
            String id = placeholder.substring(0, placeholder.indexOf(95));
            String token = placeholder.substring(id.indexOf(45));
            if (!this.store.has(id)) {
                return null;
            }
            try {
                Object out = this.store.parse(id, this.store.isRelational(id), source, observer, Optional.ofNullable(token.isEmpty() ? null : token));
                if (out == null && this.store.isNormal(id) && PlaceholderAPIPlugin.getInstance().getConfig().relationaltoregular) {
                    return this.store.parse(id, false, observer, source, Optional.ofNullable(token.isEmpty() ? null : token));
                }
                return out;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (!this.store.has(placeholder)) {
            return null;
        }
        try {
            Object out = this.store.parse(placeholder, this.store.isRelational(placeholder), source, observer, Optional.empty());
            if (out == null && this.store.isNormal(placeholder) && PlaceholderAPIPlugin.getInstance().getConfig().relationaltoregular) {
                return this.store.parse(placeholder, false, observer, source, Optional.empty());
            }
            return out;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshAll() {
        this.store.reloadAll();
    }

    public boolean refreshPlaceholder(String id) {
        return this.store.reload(id);
    }

    @Override
    public boolean registerExpansion(Expansion<?, ?, ?> expansion) {
        return this.store.register(expansion);
    }

    @Override
    public <T> void registerTypeDeserializer(TypeToken<T> token, Function<String, T> deserializer) {
        TypeUtils.registerDeserializer(token, deserializer);
    }

    @Override
    public Text replacePlaceholders(TextTemplate template, Object source, Object observer) {
        return template.apply(this.fillPlaceholders(template, source, observer)).build();
    }

    private Map<String, Object> rpt(Object s, Object o, TextTemplate template, Map<String, Object> args) {
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        for (String a : template.getArguments().keySet()) {
            String cl;
            String id;
            int index;
            boolean rel;
            if (args.containsKey(a)) continue;
            String format = a.toLowerCase();
            boolean bl = rel = !format.isEmpty() && format.toLowerCase().startsWith("rel");
            if (rel) {
                format = format.substring(4);
            }
            if ((index = format.indexOf("_")) == 0 || index == format.length()) {
                if (((TextTemplate.Arg)template.getArguments().get(a)).isOptional()) continue;
                args.put(a, template.getOpenArgString() + a + template.getCloseArgString());
                continue;
            }
            boolean noToken = false;
            if (index == -1) {
                noToken = true;
                index = format.length();
            }
            if (!this.store.has(id = format.substring(0, index).toLowerCase())) {
                if (((TextTemplate.Arg)template.getArguments().get(a)).isOptional()) continue;
                LiteralText suggestions = Text.NEW_LINE;
                suggestions = suggestions.concat(Text.of((Object[])new Object[]{Messages.get().misc.suggestions.t(new Object[0]), Text.joinWith((Text)Text.of((String)", "), (Iterable)this.store.allIds().stream().filter(str -> TypeUtils.closeTo(id, str)).map(Text::of).collect(Collectors.toList()))}));
                args.put(a, Text.of((Object[])new Object[]{TextColors.WHITE, TextActions.showText((Text)Text.of((Object[])new Object[]{Messages.get().misc.invalid.t("ID"), suggestions})), template.getOpenArgString(), TextColors.RED, a, TextColors.WHITE, template.getCloseArgString()}));
                continue;
            }
            String token = noToken ? null : format.substring(index + 1);
            Text value = null;
            boolean empty = true;
            Text errorMsg = Messages.get().placeholder.tokenNeeded.t(new Object[0]);
            List<Object> suggestions = new ArrayList();
            try {
                value = this.store.parse(id, rel, s, o, Optional.ofNullable(token), Text.class).orElse(null);
            }
            catch (Exception e) {
                if (e instanceof NoValueException) {
                    value = null;
                    empty = false;
                    errorMsg = ((NoValueException)e).getTextMessage();
                    suggestions = ((NoValueException)e).suggestions();
                }
                cl = "";
                try {
                    cl = e.getCause().getMessage() + " ";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                value = Text.of((Object[])new Object[]{TextColors.RED, TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.RED, "Check the console for details!"})), "ERROR: " + cl + e.getMessage()});
                e.printStackTrace();
            }
            if (value == null && PlaceholderAPIPlugin.getInstance().getConfig().relationaltoregular && rel) {
                empty = true;
                try {
                    value = this.store.parse(id, false, o, s, Optional.ofNullable(token), Text.class).orElse(null);
                }
                catch (Exception e) {
                    if (e instanceof NoValueException) {
                        value = null;
                        empty = false;
                        errorMsg = ((NoValueException)e).getTextMessage();
                        suggestions = ((NoValueException)e).suggestions();
                    }
                    cl = "";
                    try {
                        cl = e.getCause().getMessage() + " ";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    value = Text.of((Object[])new Object[]{TextColors.RED, TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.RED, "Check the console for details!"})), "ERROR: " + cl + e.getMessage()});
                    e.printStackTrace();
                }
            }
            boolean enabled = this.store.get(id, false).orElseGet(() -> this.store.get(id, true).get()).isEnabled();
            if (value == null && !empty) {
                Text arg;
                if (noToken) {
                    arg = enabled ? Text.of((Object[])new Object[]{TextColors.RED, TextActions.showText((Text)errorMsg), a}) : Text.of((Object[])new Object[]{TextColors.RED, TextActions.showText((Text)Messages.get().placeholder.notEnabled.t(new Object[0])), a});
                } else {
                    TextColor idCol = TextColors.WHITE;
                    idCol = this.store.has(id) ? (enabled ? TextColors.WHITE : TextColors.RED) : TextColors.RED;
                    Text sug = Text.EMPTY;
                    if (!suggestions.isEmpty()) {
                        sug = Text.of((Object[])new Object[]{Text.NEW_LINE, Messages.get().misc.suggestions, Text.joinWith((Text)Text.of((String)", "), (Iterable)suggestions.stream().map(Text::of).collect(Collectors.toList()))});
                    }
                    arg = Text.of((Object[])new Object[]{idCol, TextActions.showText((Text)Text.of((Object[])new Object[]{TextColors.RED, errorMsg, sug})), id, TextColors.RED, "_" + token});
                }
                value = Text.of((Object[])new Object[]{TextColors.WHITE, template.getOpenArgString(), arg, TextColors.WHITE, template.getCloseArgString()});
            } else if (value == null) {
                value = Text.EMPTY;
            }
            args.put(a, value);
        }
        return args;
    }

    private void validate(Object source, Object observer) {
        Preconditions.checkArgument((boolean)this.verifySource(source), (Object)"Source is not the right type!");
        Preconditions.checkArgument((boolean)this.verifySource(observer), (Object)"Observer is not the right type!");
    }

    @Override
    public boolean verifySource(Object source) {
        return source == null || source instanceof Locatable || source instanceof MessageReceiver || source instanceof Subject || source instanceof DataHolder;
    }
}

