/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.commands;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.configs.Messages;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import me.rojo8399.placeholderapi.impl.utils.TextUtils;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.spec.CommandExecutor;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;

public class InfoCommand
implements CommandExecutor {
    private static final Pattern OPT = Pattern.compile("[\\<\\[\\(\\{]([^ \\<\\>\\[\\]\\{\\}\\(\\)]+)[\\>\\}\\]\\)]", 2);

    private static Text format(Expansion<?, ?, ?> e, CommandSource src) {
        String name = e.id();
        String version = e.version();
        String author = e.author();
        boolean rel = e.relational();
        List<String> tokens = e.tokens();
        if (tokens == null) {
            tokens = new ArrayList<String>();
        }
        List supportedTokens = tokens.stream().map(s -> s == null || s.isEmpty() ? null : s).map(s -> s == null ? null : s.toLowerCase().trim()).distinct().sorted((s1, s2) -> s1 == null ? -1 : (s2 == null ? 1 : s1.compareTo((String)s2))).map(s -> {
            if (s == null) {
                return InfoCommand.token(name, src, rel);
            }
            String s2 = name.concat("_" + s);
            if (OPT.matcher(s2).find()) {
                return InfoCommand.token(s2, src, rel, true);
            }
            return InfoCommand.token(s2, src, rel);
        }).collect(Collectors.toList());
        boolean seeall = false;
        ArrayList<Text> t2 = new ArrayList<Text>(supportedTokens);
        if (supportedTokens.size() > 20) {
            supportedTokens = supportedTokens.subList(0, 20);
            seeall = true;
        }
        Text url = e.url() == null ? Text.EMPTY : Text.of((Object[])new Object[]{Text.NEW_LINE, TextColors.BLUE, TextActions.openUrl((URL)e.url()), e.url().toString()});
        String d = e.description();
        Text desc = d == null || d.isEmpty() ? Text.EMPTY : Text.of((Object[])new Object[]{Text.NEW_LINE, TextColors.AQUA, e.description()});
        Text reload = Text.of((Object[])new Object[]{Text.NEW_LINE, Messages.get().placeholder.clickReload.t(new Object[0]), " ", InfoCommand.reload(e.id())});
        Text support = supportedTokens.isEmpty() ? Text.EMPTY : Text.of((Object[])new Object[]{Text.NEW_LINE, Messages.get().placeholder.supportedPlaceholders.t(new Object[0]), seeall ? InfoCommand.seeall(t2, rel) : "", Text.NEW_LINE, Text.joinWith((Text)Text.of((String)", "), supportedTokens)});
        return Text.of((Object[])new Object[]{TextColors.AQUA, (rel ? "rel_" : "") + name, TextColors.GREEN, " " + version, TextColors.GRAY, " ", Messages.get().misc.by.t(new Object[0]), " ", TextColors.GOLD, author, TextColors.GRAY, ".", reload, desc, url, support});
    }

    private static Text formatExpansion(String e, CommandSource src) {
        Expansion norm;
        List conts = Arrays.asList(Store.get().get(e, true), Store.get().get(e, false)).stream().flatMap(TypeUtils.unmapOptional()).collect(Collectors.toList());
        try {
            norm = (Expansion)conts.get(0);
        }
        catch (Exception ex) {
            return Messages.get().placeholder.improperRegistration.t(new Object[0]);
        }
        Expansion rel = null;
        if (conts.size() > 1) {
            rel = (Expansion)conts.get(1);
        }
        Text out = InfoCommand.format(norm, src);
        if (rel != null) {
            out = out.concat((Text)Text.NEW_LINE);
            out = out.concat(InfoCommand.format(rel, src));
        }
        return out;
    }

    private static Text reload(String token) {
        return Messages.get().placeholder.reloadButton.t(new Object[0]).toBuilder().onHover((HoverAction)TextActions.showText((Text)Messages.get().placeholder.reloadButtonHover.t(new Object[0]))).onClick((ClickAction)TextActions.runCommand((String)("/papi r " + token))).build();
    }

    private static Text seeall(List<Text> tokens, boolean relational) {
        Text t = Text.joinWith((Text)Text.of((String)", "), tokens);
        Text h = relational ? Messages.get().placeholder.allPlaceholdersHoverRelational.t(new Object[0]) : Messages.get().placeholder.allPlaceholdersHover.t(new Object[0]);
        Text a = relational ? Messages.get().placeholder.allSupportedPlaceholdersRelational.t(new Object[0]) : Messages.get().placeholder.allSupportedPlaceholders.t(new Object[0]);
        Text m = Messages.get().placeholder.allPlaceholdersButton.t(new Object[0]);
        Text m2 = m.toBuilder().onClick((ClickAction)TextActions.executeCallback(s -> {
            s.sendMessage(a);
            s.sendMessage(t);
        })).onHover((HoverAction)TextActions.showText((Text)Text.of((Object[])new Object[]{h}))).build();
        return Text.of((Object[])new Object[]{"    ", m2});
    }

    private static Text token(String token, CommandSource src, boolean relational) {
        if (!(src instanceof Player)) {
            return Text.of((Object[])new Object[]{TextColors.GREEN, token});
        }
        String p = src.getName();
        return Text.of((Object[])new Object[]{TextColors.GREEN, TextActions.showText((Text)Messages.get().placeholder.parseButtonHover.t(new Object[0])), TextActions.runCommand((String)("/papi p " + p + " %" + (relational ? "rel_" : "") + token + "%")), (relational ? "rel_" : "") + token});
    }

    private static Text token(String token, CommandSource src, boolean relational, boolean opt) {
        if (!opt) {
            return InfoCommand.token(token, src, relational);
        }
        if (!(src instanceof Player)) {
            return Text.of((Object[])new Object[]{TextColors.GREEN, token});
        }
        String p = src.getName();
        return Text.of((Object[])new Object[]{TextColors.GREEN, TextActions.showText((Text)Messages.get().placeholder.parseButtonHover.t(new Object[0])), TextActions.suggestCommand((String)("/papi p " + p + " %" + (relational ? "rel_" : "") + token + "%")), (relational ? "rel_" : "") + token});
    }

    public CommandResult execute(CommandSource src, CommandContext args) throws CommandException {
        String placeholder = (String)args.getOne("placeholder").orElseThrow(() -> new CommandException(Messages.get().placeholder.mustSpecify.t(new Object[0])));
        PlaceholderService service = (PlaceholderService)PlaceholderAPIPlugin.getInstance().getGame().getServiceManager().provideUnchecked(PlaceholderService.class);
        if (!service.isRegistered(placeholder)) {
            throw new CommandException(Messages.get().placeholder.invalidPlaceholder.t(new Object[0]));
        }
        Text barrier = TextUtils.repeat(Text.of((Object[])new Object[]{TextColors.GOLD, "="}), 35);
        src.sendMessage(barrier);
        src.sendMessage(InfoCommand.formatExpansion(placeholder, src));
        src.sendMessage(barrier);
        return CommandResult.success();
    }
}

