/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.configs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class JavascriptManager {
    private File folder;
    private Map<String, String> scripts = new HashMap<String, String>();

    public JavascriptManager(File scriptFolder) throws IOException {
        if (scriptFolder.exists() && scriptFolder.isFile()) {
            scriptFolder.delete();
        }
        if (!scriptFolder.exists()) {
            scriptFolder.mkdirs();
        }
        this.folder = scriptFolder;
        for (File sub : this.folder.listFiles((f, s) -> s.endsWith(".js"))) {
            BufferedReader r = new BufferedReader(new FileReader(sub));
            String str = r.lines().reduce("", (s1, s2) -> s1 + "\n" + s2);
            r.close();
            this.scripts.put(sub.getName().replace(".js", "").toLowerCase(), str);
        }
    }

    public Object eval(ScriptEngine engine, String token) {
        if (token.replace("_", "").isEmpty()) {
            return null;
        }
        if (token.contains("_")) {
            String[] arr = token.split("_");
            if (arr.length == 1) {
                Reader r = this.getScript(arr[0]);
                if (r == null) {
                    return null;
                }
                try {
                    engine.put("args", null);
                    return engine.eval(r);
                }
                catch (ScriptException e) {
                    return "ERROR: " + e.getMessage();
                }
            }
            Reader f = this.getScript(arr[0]);
            if (f == null) {
                return null;
            }
            List<String> l = Arrays.asList(arr).stream().skip(1L).collect(Collectors.toList());
            engine.put("args", l.toArray(new String[l.size() - 1]));
            try {
                return engine.eval(f);
            }
            catch (ScriptException e) {
                return "ERROR: " + e.getMessage();
            }
        }
        Reader r = this.getScript(token);
        if (r == null) {
            return null;
        }
        try {
            engine.put("args", null);
            return engine.eval(r);
        }
        catch (ScriptException e) {
            return "ERROR: " + e.getMessage();
        }
    }

    public Reader getScript(String name) {
        if (!this.scripts.containsKey(name)) {
            return null;
        }
        return new StringReader(this.scripts.get(name));
    }

    public List<String> getScriptNames() {
        ArrayList<String> out = new ArrayList<String>();
        out.addAll(this.scripts.keySet());
        return out;
    }

    public void reloadScripts() throws IOException {
        this.scripts.clear();
        for (File sub : this.folder.listFiles((f, s) -> s.endsWith(".js"))) {
            BufferedReader r = new BufferedReader(new FileReader(sub));
            String str = r.lines().reduce("", (s1, s2) -> s1 + "\n" + s2);
            r.close();
            this.scripts.put(sub.getName().replace(".js", "").toLowerCase(), str);
        }
    }
}

