/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.placeholder;

import com.flowpowered.math.vector.Vector3d;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import me.rojo8399.placeholderapi.Attach;
import me.rojo8399.placeholderapi.Listening;
import me.rojo8399.placeholderapi.NoValueException;
import me.rojo8399.placeholderapi.Observer;
import me.rojo8399.placeholderapi.Placeholder;
import me.rojo8399.placeholderapi.PlaceholderService;
import me.rojo8399.placeholderapi.Relational;
import me.rojo8399.placeholderapi.Requires;
import me.rojo8399.placeholderapi.Source;
import me.rojo8399.placeholderapi.Token;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.configs.JavascriptManager;
import me.rojo8399.placeholderapi.impl.configs.Messages;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.HandTypes;
import org.spongepowered.api.effect.sound.SoundType;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.entity.living.player.gamemode.GameMode;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.game.state.GameStoppingEvent;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.event.service.ChangeServiceProviderEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.service.economy.Currency;
import org.spongepowered.api.service.economy.EconomyService;
import org.spongepowered.api.service.economy.account.UniqueAccount;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.statistic.Statistic;
import org.spongepowered.api.statistic.Statistics;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.world.Locatable;
import org.spongepowered.api.world.storage.WorldProperties;

@ConfigSerializable
@Listening
public class Defaults {
    private static final Pattern ALLSOUND_PATTERN = Pattern.compile("([_]?all[_]?)", 2);
    private static int MB = 0x100000;
    private static Runtime runtime = Runtime.getRuntime();
    private Map<Currency, List<UniqueAccount>> balTop = new HashMap<Currency, List<UniqueAccount>>();
    private boolean changed = false;
    private Map<String, Currency> currencies = new HashMap<String, Currency>();
    private Uptime current;
    private Currency def;
    private boolean eco = true;
    private ScriptEngine engine;
    private Map<Currency, Long> lastUpdate = new HashMap<Currency, Long>();
    private JavascriptManager manager;
    private PlaceholderService s;
    private Server server;
    private EconomyService service;
    private UserStorageService storage = null;
    @Setting
    @Attach(value="server")
    private List<Uptime> uptimes = new ArrayList<Uptime>();
    @Setting
    @Attach(value="server")
    private boolean useUptimes = false;
    private Set<User> users = new HashSet<User>();

    private static boolean between(double o, double min, double max) {
        return o >= min && o <= max;
    }

    private static String getCardinal(Player player) {
        Vector3d rot = player.getHeadRotation();
        double rotation = rot.abs().getY();
        if (Defaults.between(rotation, 0.0, 22.5) || Defaults.between(rotation, 337.5, 360.0)) {
            return Messages.get().misc.directions.south.value;
        }
        if (Defaults.between(rotation, 22.5, 67.5)) {
            return Messages.get().misc.directions.southwest.value;
        }
        if (Defaults.between(rotation, 67.5, 112.5)) {
            return Messages.get().misc.directions.west.value;
        }
        if (Defaults.between(rotation, 112.5, 157.5)) {
            return Messages.get().misc.directions.northwest.value;
        }
        if (Defaults.between(rotation, 157.5, 202.5)) {
            return Messages.get().misc.directions.north.value;
        }
        if (Defaults.between(rotation, 202.5, 247.5)) {
            return Messages.get().misc.directions.northeast.value;
        }
        if (Defaults.between(rotation, 247.5, 292.5)) {
            return Messages.get().misc.directions.east.value;
        }
        if (Defaults.between(rotation, 292.5, 337.5)) {
            return Messages.get().misc.directions.southeast.value;
        }
        return "ERROR";
    }

    private static Subject getParentGroup(Subject subject) {
        List parents = subject.getParents();
        return parents.stream().sorted((s1, s2) -> {
            if (s1.isChildOf(s2)) {
                return 1;
            }
            if (s2.isChildOf(s1)) {
                return -1;
            }
            return 0;
        }).findFirst().orElse(parents.isEmpty() ? subject : (Subject)parents.get(0));
    }

    private static double getTime(Player player, TimeUnit unit) {
        boolean ticks = unit == null;
        long time = Optional.ofNullable(((Map)player.get(Keys.STATISTICS).orElseThrow(() -> new IllegalStateException("Player must have statistics!"))).get(Statistics.TIME_PLAYED)).orElse(0L);
        if (ticks) {
            return time;
        }
        double time2 = (double)time / 20.0;
        if (unit == TimeUnit.SECONDS) {
            return time2;
        }
        double value = time2 / (double)TimeUnit.SECONDS.convert(1L, unit);
        return value;
    }

    private static long getTime(Player player, TimeUnit unit, boolean round) {
        boolean ticks = unit == null;
        long time = Optional.ofNullable(((Map)player.get(Keys.STATISTICS).orElseThrow(() -> new IllegalStateException("Player must have statistics!"))).get(Statistics.TIME_PLAYED)).orElse(0L);
        if (ticks) {
            return time;
        }
        double time2 = (double)time / 20.0;
        if (unit == TimeUnit.SECONDS) {
            if (!round) {
                return (long)time2;
            }
            return Math.round(time2);
        }
        double value = time2 / (double)TimeUnit.SECONDS.convert(1L, unit);
        if (!round) {
            return (long)value;
        }
        return Math.round(value);
    }

    public Defaults(EconomyService service, JavascriptManager manager, PlaceholderService s) {
        if (service != null) {
            this.eco = true;
            this.service = service;
            this.def = service.getDefaultCurrency();
            service.getCurrencies().forEach(this::putCur);
        } else {
            this.eco = false;
        }
        this.manager = manager;
        try {
            manager.reloadScripts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = PlaceholderAPIPlugin.getInstance().getGame().getServer();
        this.s = s;
        Optional o = Sponge.getServiceManager().provide(UserStorageService.class);
        if (o.isPresent()) {
            this.storage = (UserStorageService)o.get();
            this.changed = true;
            this.sync();
        }
        this.current = new Uptime();
        this.current.start();
    }

    private void calculateBalTop(Currency cur) {
        if (this.lastUpdate.containsKey(cur) && this.lastUpdate.get(cur) != null) {
            long last = this.lastUpdate.get(cur);
            if (Duration.ofMillis(System.currentTimeMillis() - last).toMinutes() <= 3L) {
                return;
            }
        }
        List<Object> baltop = new ArrayList();
        baltop = this.users.stream().map(u -> u.getUniqueId()).filter(arg_0 -> ((EconomyService)this.service).hasAccount(arg_0)).map(arg_0 -> ((EconomyService)this.service).getOrCreateAccount(arg_0)).filter(Optional::isPresent).map(Optional::get).sorted((a, b) -> -a.getBalance(cur).compareTo(b.getBalance(cur))).collect(Collectors.toList());
        this.balTop.put(cur, baltop);
        this.lastUpdate.put(cur, System.currentTimeMillis());
    }

    private boolean contains(Player p) {
        return this.users.stream().map(u -> u.getUniqueId()).anyMatch(p.getUniqueId()::equals);
    }

    @Placeholder(id="economy")
    public Object economy(@Token(fix=true) @Nullable String token, @Nullable @Source User player) throws NoValueException {
        if (this.service == null || !this.eco) {
            throw new NoValueException("No economy plugin present!");
        }
        if (token == null) {
            Text amt = this.def.format(BigDecimal.valueOf(1234.56));
            LiteralText v = Text.of((String)(this.def.getName() + " (" + this.def.getId() + ") - "));
            return v.concat(amt);
        }
        String t = token;
        Currency toUse = this.def;
        if (t.contains("_")) {
            String[] a2 = t.split("_");
            t = a2[0];
            for (int i = 1; i < a2.length - 1; ++i) {
                t = t + "_" + a2[i];
            }
            String c = a2[a2.length - 1];
            if (this.currencies.containsKey(c)) {
                toUse = this.currencies.get(c);
            } else {
                t = t + "_" + c;
            }
        }
        Currency toUseFinal = toUse;
        int baltop = 0;
        if (t.startsWith("baltop")) {
            if (t.contains("_")) {
                String aft = t.substring(t.indexOf("_") + 1);
                t = t.substring(0, t.indexOf("_"));
                try {
                    baltop = Integer.parseInt(aft);
                }
                catch (Exception e) {
                    if (aft.contains("_")) {
                        String cur = aft.split("_")[1];
                        throw new NoValueException("That is not a valid currency!", this.currencies.keySet().stream().filter(s -> TypeUtils.closeTo(cur, s)).collect(Collectors.toList()));
                    }
                    throw new NoValueException("That is not a valid currency!", this.currencies.keySet().stream().filter(s -> TypeUtils.closeTo(aft, s)).collect(Collectors.toList()));
                }
            } else {
                baltop = 5;
            }
            if (baltop <= 0) {
                baltop = 1;
            }
            this.calculateBalTop(toUse);
            List baltop2 = this.balTop.get(toUse).stream().limit(baltop).collect(Collectors.toList());
            if (t.startsWith("baltopf")) {
                return Text.joinWith((Text)Text.of((String)", "), (Iterable)baltop2.stream().map(a -> Text.of((Object[])new Object[]{a.getDisplayName(), ": " + toUseFinal.format(a.getBalance(toUseFinal))})).collect(Collectors.toList()));
            }
            return Text.joinWith((Text)Text.of((String)", "), (Iterable)baltop2.stream().map(a -> Text.of((Object[])new Object[]{a.getDisplayName(), ": " + a.getBalance(toUseFinal).toPlainString()})).collect(Collectors.toList()));
        }
        switch (t) {
            case "display": {
                return toUse.getDisplayName();
            }
            case "plural_display": {
                return toUse.getPluralDisplayName();
            }
            case "symbol": {
                return toUse.getSymbol();
            }
        }
        if (player != null) {
            UniqueAccount acc = (UniqueAccount)this.service.getOrCreateAccount(player.getUniqueId()).get();
            switch (t) {
                case "balance": {
                    return acc.getBalance(toUse).toPlainString();
                }
                case "bal_format": {
                    return toUse.format(acc.getBalance(toUse));
                }
            }
        }
        if (this.currencies.containsKey(t)) {
            toUse = this.currencies.get(t);
            Text amt = toUse.format(BigDecimal.valueOf(1234.56));
            LiteralText v = Text.of((String)(toUse.getName() + " (" + toUse.getId() + ") - "));
            return v.concat(amt);
        }
        if (t.contains("_")) {
            String[] arr = t.split("_");
            t = arr[arr.length - 1];
        }
        String ft = t;
        throw new NoValueException("That is not a valid currency!", this.currencies.keySet().stream().filter(s -> TypeUtils.closeTo(ft, s)).collect(Collectors.toList()));
    }

    private long getDowntimeMillis() {
        long lastFinTime = 0L;
        long out = 0L;
        for (Uptime u : this.uptimes) {
            if (lastFinTime == 0L) {
                lastFinTime = u.finishTimeMillis;
                continue;
            }
            out += u.startTimeMillis - lastFinTime;
            lastFinTime = u.finishTimeMillis;
        }
        if (out == 0L) {
            out = System.currentTimeMillis() - lastFinTime;
        }
        return out;
    }

    private long getUptimeMillis() {
        return this.uptimes.stream().map(u -> u.finishTimeMillis - u.startTimeMillis).reduce((long)Sponge.getServer().getRunningTimeTicks() * 50L, (a, b) -> a + b);
    }

    @Placeholder(id="rank")
    @Relational
    public Boolean isAbove(@Token String token, @Source User underrank, @Observer User overrank) throws NoValueException {
        if (!token.equalsIgnoreCase("greater_than") && !token.equalsIgnoreCase("less_than")) {
            throw new NoValueException();
        }
        if (token.equalsIgnoreCase("greater_than")) {
            if (underrank.isChildOf((Subject)overrank)) {
                return true;
            }
            return Defaults.getParentGroup((Subject)underrank).isChildOf(Defaults.getParentGroup((Subject)overrank));
        }
        if (overrank.isChildOf((Subject)underrank)) {
            return true;
        }
        return Defaults.getParentGroup((Subject)overrank).isChildOf(Defaults.getParentGroup((Subject)underrank));
    }

    @Placeholder(id="javascript")
    public Object js(@Nullable @Source Player player, @Nullable @Observer CommandSource observer, @Token String token) {
        if (this.engine == null) {
            this.engine = new ScriptEngineManager(null).getEngineByName("Nashorn");
            this.engine.put("server", this.server == null ? (this.server = PlaceholderAPIPlugin.getInstance().getGame().getServer()) : this.server);
        }
        this.engine.put("player", player);
        this.engine.put("observer", observer);
        Service service = new Service(this.s, player, observer);
        this.engine.put("service", service);
        return this.manager.eval(this.engine, token);
    }

    @Listener
    public void newEco(ChangeServiceProviderEvent event) {
        if (event.getService().equals(EconomyService.class)) {
            EconomyService s = (EconomyService)event.getNewProvider();
            if (s != null) {
                this.eco = true;
                this.service = s;
                this.def = this.service.getDefaultCurrency();
                this.currencies.clear();
                this.service.getCurrencies().forEach(this::putCur);
            } else {
                this.eco = false;
            }
        }
    }

    @Placeholder(id="player")
    public Object normalPlayer(@Source Player p, @Token(fix=true) @Nullable String token) throws NoValueException {
        if (token == null) {
            return p.getName();
        }
        if (token.startsWith("option_")) {
            String op = token.substring("option_".length());
            return p.getOption(op).orElse("");
        }
        if (token.startsWith("perm") && token.contains("_")) {
            String op = token.substring(token.indexOf("_"));
            return p.getPermissionValue(p.getActiveContexts(), op).toString();
        }
        switch (token) {
            case "prefix": 
            case "suffix": {
                return p.getOption(token).orElse("");
            }
            case "name": {
                return p.getName();
            }
            case "displayname": {
                return p.getOrElse(Keys.DISPLAY_NAME, (Object)Text.of((String)p.getName()));
            }
            case "uuid": {
                return p.getUniqueId();
            }
            case "can_fly": {
                return p.getOrElse(Keys.CAN_FLY, (Object)false);
            }
            case "world": {
                return p.getWorld().getName();
            }
            case "ping": {
                return p.getConnection().getLatency();
            }
            case "language": {
                return p.getLocale().getDisplayName();
            }
            case "flying": {
                return p.getOrElse(Keys.IS_FLYING, (Object)false);
            }
            case "health": {
                return Math.round((Double)p.health().get());
            }
            case "max_health": {
                return Math.round((Double)p.maxHealth().get());
            }
            case "food": {
                return p.foodLevel().get();
            }
            case "saturation": {
                return Math.round((Double)p.saturation().get());
            }
            case "gamemode": {
                return ((GameMode)p.gameMode().get()).getName();
            }
            case "x": {
                return p.getLocation().getPosition().toInt().getX();
            }
            case "y": {
                return p.getLocation().getPosition().toInt().getY();
            }
            case "z": {
                return p.getLocation().getPosition().toInt().getZ();
            }
            case "direction": {
                return Defaults.getCardinal(p);
            }
            case "exp_total": {
                return p.getOrElse(Keys.TOTAL_EXPERIENCE, (Object)0);
            }
            case "exp": {
                return p.getOrElse(Keys.EXPERIENCE_SINCE_LEVEL, (Object)0);
            }
            case "exp_to_next": {
                return p.getOrElse(Keys.EXPERIENCE_FROM_START_OF_LEVEL, (Object)0);
            }
            case "level": {
                return p.getOrElse(Keys.EXPERIENCE_LEVEL, (Object)0);
            }
            case "first_join": {
                return p.getOrNull(Keys.FIRST_DATE_PLAYED);
            }
            case "fly_speed": {
                return p.getOrElse(Keys.FLYING_SPEED, (Object)1.0);
            }
            case "max_air": {
                return p.getOrElse(Keys.MAX_AIR, (Object)300);
            }
            case "remaining_air": {
                return p.getOrElse(Keys.REMAINING_AIR, (Object)300);
            }
            case "item_in_main_hand": {
                return p.getItemInHand(HandTypes.MAIN_HAND).orElse(ItemStackSnapshot.NONE.createStack());
            }
            case "item_in_off_hand": {
                return p.getItemInHand(HandTypes.OFF_HAND).orElse(ItemStackSnapshot.NONE.createStack());
            }
            case "walk_speed": {
                return p.getOrElse(Keys.WALKING_SPEED, (Object)1.0);
            }
            case "time_played_seconds": {
                return Defaults.getTime(p, TimeUnit.SECONDS, true);
            }
            case "time_played_minutes": {
                return Defaults.getTime(p, TimeUnit.MINUTES, true);
            }
            case "time_played_ticks": {
                return Defaults.getTime(p, null, true);
            }
            case "time_played_hours": {
                return Defaults.getTime(p, TimeUnit.HOURS, true);
            }
            case "time_played_days": {
                return Defaults.getTime(p, TimeUnit.DAYS, true);
            }
            case "time_played": {
                long d = Defaults.getTime(p, TimeUnit.DAYS, false);
                long h = Defaults.getTime(p, TimeUnit.HOURS, false);
                long m = Defaults.getTime(p, TimeUnit.MINUTES, false);
                double s = Defaults.getTime(p, TimeUnit.SECONDS);
                NumberFormat f = NumberFormat.getInstance(Locale.getDefault());
                f.setMaximumFractionDigits(2);
                String out = "";
                if (d > 0L) {
                    out = out + f.format(d) + " d ";
                    h -= 24L * d;
                    m -= 1440L * d;
                    s -= (double)(86400L * d);
                }
                if (h > 0L) {
                    out = out + f.format(h) + " h ";
                    m -= 60L * h;
                    s -= (double)(3600L * h);
                }
                if (m > 0L) {
                    out = out + f.format(m) + " m ";
                    s -= (double)(60L * m);
                }
                if (s > 0.0) {
                    out = out + f.format(s) + " s";
                }
                return out.trim();
            }
        }
        throw new NoValueException();
    }

    @Listener
    public void onJoin(ClientConnectionEvent.Join event, @Getter(value="getTargetEntity") Player player) {
        if (this.useUptimes) {
            this.uptimes = this.uptimes.stream().filter(u -> Duration.ofMillis(System.currentTimeMillis() - u.finishTimeMillis).toDays() <= 30L).collect(Collectors.toList());
        }
        if (this.contains(player)) {
            return;
        }
        this.changed = this.users.add((User)player) || this.changed;
    }

    @Listener
    public void onStopping(GameStoppingEvent event) {
        if (this.useUptimes) {
            this.current.finish();
            this.uptimes.add(this.current);
            Store.get().get("server", false).ifPresent(Expansion::saveConfig);
        } else {
            this.uptimes.clear();
        }
    }

    private void putCur(Currency c) {
        this.currencies.put(c.getName().toLowerCase().replace(" ", ""), c);
    }

    @Placeholder(id="rank")
    public Object rank(@Source User player, @Token(fix=true) @Nullable String token) throws NoValueException {
        String t;
        if (token == null) {
            return Defaults.getParentGroup((Subject)player).getIdentifier();
        }
        Subject rank = Defaults.getParentGroup((Subject)player);
        switch (t = token) {
            case "prefix": 
            case "suffix": {
                return rank.getOption(t).orElse("");
            }
            case "name": {
                return rank.getIdentifier();
            }
        }
        if (t.contains("_") && t.indexOf("_") < t.length()) {
            if (t.startsWith("option")) {
                String opt = t.substring(t.indexOf("_") + 1);
                return rank.getOption(opt).orElse("");
            }
            if (t.startsWith("perm")) {
                String perm = t.substring(t.indexOf("_") + 1);
                return rank.getPermissionValue(rank.getActiveContexts(), perm).toString();
            }
        }
        throw new NoValueException();
    }

    @Placeholder(id="player")
    @Relational
    public Object relPlayer(@Source Player one, @Observer CommandSource two, @Token(fix=true) @Nullable String token) throws NoValueException {
        String t;
        if (!(two instanceof Player)) {
            if (token == null) {
                return two.getName();
            }
            t = token;
            if (t.startsWith("option_")) {
                String op = t.substring("option_".length());
                return two.getOption(op).orElse("");
            }
            if (t.startsWith("perm") && t.contains("_")) {
                String op = t.substring(t.indexOf("_"));
                return two.getPermissionValue(two.getActiveContexts(), op).toString();
            }
            if (t.equalsIgnoreCase("prefix") || t.equalsIgnoreCase("suffix")) {
                return two.getOption(t).orElse("");
            }
        }
        if (token == null) {
            throw new NoValueException();
        }
        switch (t = token) {
            case "distance": {
                if (!(two instanceof Locatable)) {
                    return 0;
                }
                return Math.round(one.getLocation().getPosition().distance(((Locatable)two).getLocation().getPosition()));
            }
            case "visible": {
                if (!(two instanceof Entity)) {
                    return false;
                }
                return ((Entity)two).canSee((Entity)one) && one.get(Keys.VANISH).orElse(false) == false;
            }
            case "audible": {
                return one.getMessageChannel().getMembers().contains(two);
            }
            case "distance_x": {
                if (!(two instanceof Locatable)) {
                    return 0;
                }
                return Math.abs(one.getLocation().getBlockX() - ((Locatable)two).getLocation().getBlockX());
            }
            case "distance_y": {
                if (!(two instanceof Locatable)) {
                    return 0;
                }
                return Math.abs(one.getLocation().getBlockY() - ((Locatable)two).getLocation().getBlockY());
            }
            case "distance_z": {
                if (!(two instanceof Locatable)) {
                    return 0;
                }
                return Math.abs(one.getLocation().getBlockZ() - ((Locatable)two).getLocation().getBlockZ());
            }
        }
        throw new NoValueException();
    }

    @Placeholder(id="server")
    public Object server(@Token(fix=true) String identifier) throws NoValueException {
        boolean gt = false;
        if (identifier.startsWith("time")) {
            gt = true;
            identifier = identifier.substring("time".length());
        }
        if (identifier.startsWith("game_time")) {
            gt = true;
            identifier = identifier.substring("game_time".length());
        }
        if (gt) {
            Optional w = Sponge.getServer().getDefaultWorld();
            if (!identifier.isEmpty()) {
                String world = identifier.substring(1);
                if (world.isEmpty()) {
                    if (w.isPresent()) {
                        return ((WorldProperties)w.get()).getWorldTime() % 24000L;
                    }
                    String id1 = identifier;
                    throw new NoValueException(Messages.get().misc.invalid.t("world"), Sponge.getServer().getAllWorldProperties().stream().map(wp -> wp.getWorldName()).filter(n -> TypeUtils.closeTo(id1.replaceFirst("_", ""), n)).map(s -> "time_" + s).collect(Collectors.toList()));
                }
                WorldProperties wp2 = Sponge.getServer().getWorld(world).map(wo -> wo.getProperties()).orElse(null);
                if (wp2 != null) {
                    return wp2.getWorldTime() % 24000L;
                }
            } else if (w.isPresent()) {
                return ((WorldProperties)w.get()).getWorldTime() % 24000L;
            }
            String id1 = identifier;
            throw new NoValueException(Messages.get().misc.invalid.t("world"), Sponge.getServer().getAllWorldProperties().stream().map(wp -> wp.getWorldName()).filter(n -> n.equalsIgnoreCase(((WorldProperties)w.get()).getWorldName()) || TypeUtils.closeTo(id1.replaceFirst("_", ""), n)).map(s -> "time_" + s).collect(Collectors.toList()));
        }
        switch (identifier) {
            case "online": {
                return Sponge.getServer().getOnlinePlayers().stream().filter(p -> (Boolean)p.getOrElse(Keys.VANISH_PREVENTS_TARGETING, (Object)false) == false).count();
            }
            case "max_players": {
                return Sponge.getServer().getMaxPlayers();
            }
            case "unique_players": {
                return this.unique();
            }
            case "motd": {
                return Sponge.getServer().getMotd();
            }
            case "uptime": 
            case "uptime_percent": {
                if (!this.useUptimes) {
                    throw new NoValueException("Uptime is not enabled!");
                }
                long um = this.getUptimeMillis();
                long dm = this.getDowntimeMillis();
                NumberFormat fmt = NumberFormat.getPercentInstance();
                fmt.setMaximumFractionDigits(2);
                fmt.setMinimumFractionDigits(2);
                return fmt.format((double)um / ((double)dm + (double)um));
            }
            case "uptime_total": {
                if (!this.useUptimes) {
                    throw new NoValueException("Uptime is not enabled!");
                }
                Duration dur = Duration.ofMillis(this.getUptimeMillis());
                return dur;
            }
            case "ram_used": {
                return (runtime.totalMemory() - runtime.freeMemory()) / (long)MB;
            }
            case "ram_free": {
                return runtime.freeMemory() / (long)MB;
            }
            case "ram_total": {
                return runtime.totalMemory() / (long)MB;
            }
            case "ram_max": {
                return runtime.maxMemory() / (long)MB;
            }
            case "cores": {
                return runtime.availableProcessors();
            }
            case "tps": {
                return Sponge.getServer().getTicksPerSecond();
            }
        }
        throw new NoValueException();
    }

    @Placeholder(id="sound")
    public Text sound(@Nullable @Source Player p, @Token(fix=true) String identifier) throws NoValueException {
        boolean all = identifier.contains("all");
        if (all) {
            identifier = ALLSOUND_PATTERN.matcher(identifier).replaceAll("");
        }
        Game game = PlaceholderAPIPlugin.getInstance().getGame();
        String[] i = identifier.split("-");
        Optional sound = game.getRegistry().getType(SoundType.class, i[0].replace("_", "."));
        Double volume = Double.valueOf(i[1] == null ? String.valueOf(1) : i[1]);
        Double pitch = Double.valueOf(i[2] == null ? String.valueOf(1) : i[2]);
        if (sound.isPresent()) {
            if (p != null && !all) {
                Vector3d position = p.getLocation().getPosition();
                p.playSound((SoundType)sound.get(), position, volume.doubleValue(), pitch.doubleValue());
            } else {
                for (Player pl : Sponge.getServer().getOnlinePlayers()) {
                    Vector3d position = pl.getLocation().getPosition();
                    pl.playSound((SoundType)sound.get(), position, volume.doubleValue(), pitch.doubleValue());
                }
            }
        } else {
            throw new NoValueException(Messages.get().misc.invalid.t("sound"));
        }
        return null;
    }

    @Placeholder(id="statistic")
    @Requires(spongeVersion="[6.0,)")
    public Long stat(@Source Player player, @Token(fix=true) String t) {
        return ((Map)player.getOrNull(Keys.STATISTICS)).entrySet().stream().filter(e -> {
            String s = ((Statistic)e.getKey()).getId().replace("._", ".").toLowerCase();
            String x = s.replace("_", "");
            String z = s.replace("_", ".");
            return s.startsWith(t) || x.startsWith(t) || z.startsWith(t);
        }).map(Map.Entry::getValue).reduce(-1L, (a, b) -> a >= 0L ? a + b : b);
    }

    public void sync() {
        if (!this.changed) {
            return;
        }
        if (this.storage == null) {
            return;
        }
        try {
            this.users = this.storage.getAll().stream().map(g -> this.storage.get(g)).filter(o -> o.isPresent()).map(o -> (User)o.get()).collect(Collectors.toSet());
            this.changed = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Placeholder(id="time")
    public LocalDateTime time() {
        return LocalDateTime.now();
    }

    public int unique() {
        return this.users.size();
    }

    @ConfigSerializable
    private static class Uptime {
        @Setting(value="end-time")
        public long finishTimeMillis;
        @Setting(value="start-time")
        public long startTimeMillis;

        private Uptime() {
        }

        public void finish() {
            this.finishTimeMillis = System.currentTimeMillis();
        }

        public void start() {
            this.startTimeMillis = System.currentTimeMillis();
        }

        public String toString() {
            return this.startTimeMillis + " to " + this.finishTimeMillis;
        }
    }

    public static class Service {
        private CommandSource o;
        private Player p;
        private PlaceholderService s;

        public Service(PlaceholderService s, Player p, CommandSource o) {
            this.s = s;
            this.p = p;
            this.o = o;
        }

        public Text get(String placeholders) {
            return this.get(placeholders, this.s.getDefaultPattern().pattern());
        }

        public Text get(String placeholders, String pattern) {
            if (placeholders.toLowerCase().contains("javascript")) {
                return Text.of((String)placeholders);
            }
            return this.s.replacePlaceholders(placeholders, (Object)this.p, (Object)this.s, Pattern.compile(pattern, 2));
        }

        public String value(String placeholder) {
            return this.value(placeholder, this.s.getDefaultPattern().pattern());
        }

        public String value(String placeholder, String pattern) {
            if (placeholder.toLowerCase().contains("javascript")) {
                return placeholder;
            }
            return TextSerializers.FORMATTING_CODE.serialize(this.s.replacePlaceholders(placeholder, (Object)this.p, (Object)this.o, Pattern.compile(pattern, 2)));
        }
    }
}

