/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.placeholder;

import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.rojo8399.placeholderapi.IExpansion;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import ninja.leaping.configurate.ConfigurationNode;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Locatable;

public abstract class Expansion<S, O, V>
implements IExpansion<S, O, V> {
    private String author;
    private Object configObject;
    private String desc;
    private boolean enabled = true;
    private String id;
    private final Class<? extends O> observerClass;
    private Object plugin;
    private boolean relational = false;
    private Runnable reloadListeners;
    private final Class<? extends S> sourceClass;
    private List<String> tokens;
    private URL url;
    private final Class<? extends V> valueClass;
    private String ver;

    private static final String fix(String id) {
        if ((id = id.toLowerCase().trim()).startsWith("rel_")) {
            id = id.substring(4);
        }
        return id.replace("_", "").replace(" ", "");
    }

    private static final boolean verifySource(Class<?> param) {
        return MessageReceiver.class.isAssignableFrom(param) || Locatable.class.isAssignableFrom(param) || Subject.class.isAssignableFrom(param) || DataHolder.class.isAssignableFrom(param);
    }

    public Class<? extends V> getValueClass() {
        return this.valueClass;
    }

    public Class<? extends S> getSourceClass() {
        return this.sourceClass;
    }

    public Class<? extends O> getObserverClass() {
        return this.observerClass;
    }

    protected Expansion(String id) {
        this(id, (Object)PlaceholderAPIPlugin.getInstance(), null, null, null, (URL)null, false, new ArrayList<String>());
    }

    public Expansion(String id, Object plugin, String author, String desc, String ver, String url, boolean relational, List<String> tokens) throws Exception {
        this(id, plugin, author, desc, ver, url != null && !url.isEmpty() ? new URL(url) : null, relational, tokens);
    }

    public Expansion(String id, Object plugin, String author, String desc, String ver, String url, boolean relational, String ... tokens) throws Exception {
        this(id, plugin, author, desc, ver, url != null && !url.isEmpty() ? new URL(url) : null, relational, tokens);
    }

    public Expansion(String id, Object plugin, String author, String desc, String ver, URL url, boolean relational, List<String> tokens) {
        this(id, plugin, author, desc, ver, url, relational, tokens, null, null, null);
    }

    public Expansion(String id, Object plugin, String author, String desc, String ver, URL url, boolean relational, List<String> tokens, Class<? extends S> source, Class<? extends O> observer, Class<? extends V> value) {
        this.id = Expansion.fix((String)Preconditions.checkNotNull((Object)id));
        this.plugin = Preconditions.checkNotNull((Object)plugin);
        this.author = author;
        this.desc = desc;
        this.ver = ver;
        this.url = url;
        this.tokens = tokens;
        this.sourceClass = source;
        this.valueClass = value;
        this.observerClass = observer;
        this.relational = relational;
    }

    public Expansion(String id, Object plugin, String author, String desc, String ver, URL url, boolean relational, String ... tokens) {
        this(id, plugin, author, desc, ver, url, relational, Arrays.asList(tokens));
    }

    @Override
    public final String author() {
        return this.author;
    }

    public final O convertObserver(Object observer) {
        if (observer == null) {
            return null;
        }
        try {
            return this.observerClass.cast(observer);
        }
        catch (Exception e) {
            return null;
        }
    }

    public final S convertSource(Object source) {
        if (source == null) {
            return null;
        }
        try {
            return this.sourceClass.cast(source);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public final String description() {
        return this.desc;
    }

    @Override
    public final void disable() {
        this.setEnabled(false);
    }

    @Override
    public final void enable() {
        this.setEnabled(true);
    }

    public <T> T getConfiguration() {
        try {
            return (T)this.configObject;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public Object getPlugin() {
        return this.plugin;
    }

    @Override
    public List<String> getSuggestions(String token) {
        if (this.tokens.isEmpty()) {
            return new ArrayList<String>();
        }
        if (token == null || token.isEmpty()) {
            return this.tokens;
        }
        return this.tokens.stream().filter(s -> TypeUtils.closeTo(s, token)).collect(Collectors.toList());
    }

    @Override
    public final String id() {
        return this.id;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public abstract V parse(S var1, O var2, Optional<String> var3) throws Exception;

    public void populateConfig() {
        ConfigurationNode node = Store.get().getNode(this);
        if (node.getParent().isVirtual()) {
            node.getParent().getNode(new Object[]{"enabled"}).setValue((Object)this.enabled);
        } else {
            this.enabled = node.getParent().getNode(new Object[]{"enabled"}).getBoolean(true);
        }
        this.populateConfigObject();
    }

    protected void populateConfigObject() {
        if (this.getConfiguration() == null || PlaceholderAPIPlugin.getInstance() == null || PlaceholderAPIPlugin.getInstance().getRootConfig() == null) {
            return;
        }
        ConfigurationNode node = Store.get().getNode(this);
        if (node.isVirtual()) {
            try {
                this.saveConfigObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Store.get().fillExpansionConfig(this);
        }
        catch (Exception e1) {
            try {
                this.saveConfigObject();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    final boolean refresh() {
        this.populateConfig();
        this.reloadListeners();
        return this.reload();
    }

    @Override
    public final boolean relational() {
        return this.relational;
    }

    public boolean reload() {
        return true;
    }

    public final void reloadListeners() {
        if (this.reloadListeners != null) {
            this.reloadListeners.run();
        }
    }

    public void saveConfig() {
        this.saveConfigObject();
        ConfigurationNode node = Store.get().getNode(this);
        node.getParent().getNode(new Object[]{"enabled"}).setValue((Object)this.enabled);
    }

    protected void saveConfigObject() {
        if (this.getConfiguration() == null || PlaceholderAPIPlugin.getInstance() == null || PlaceholderAPIPlugin.getInstance().getRootConfig() == null) {
            return;
        }
        try {
            Store.get().saveExpansionConfig(this);
            PlaceholderAPIPlugin.getInstance().saveConfig();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void setConfig(Object o) {
        this.configObject = o;
    }

    @Override
    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.saveConfig();
    }

    final void setId(String id) {
        this.id = Expansion.fix(id);
    }

    final void setRelational(boolean relational) {
        this.relational = relational;
    }

    final void setReloadListeners(Runnable run) {
        this.reloadListeners = run;
    }

    public void setTokens(List<String> tokens) {
        this.tokens = tokens;
    }

    public void setTokens(String ... tokens) {
        this.setTokens(Arrays.asList(tokens));
    }

    public final void toggleEnabled() {
        this.setEnabled(this.isEnabled());
    }

    public final List<String> tokens() {
        return this.tokens;
    }

    @Override
    public final URL url() {
        return this.url;
    }

    public final boolean verify() {
        Class<?> clazz = this.getClass();
        List params = Arrays.asList(clazz.getDeclaredMethods()).stream().filter(m -> m.getName().equalsIgnoreCase("parse") && Arrays.asList(m.getGenericParameterTypes()).stream().map(Type::getTypeName).anyMatch(s -> s.contains("java.util.Optional"))).map(m -> Arrays.asList(m.getParameterTypes())).map(Collection::stream).reduce(Stream.empty(), Stream::concat).collect(Collectors.toList());
        try {
            return Expansion.verifySource((Class)params.get(0)) && Expansion.verifySource((Class)params.get(1));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public final String version() {
        return this.ver;
    }
}

