/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.placeholder;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.rojo8399.placeholderapi.ExpansionBuilder;
import me.rojo8399.placeholderapi.IExpansion;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.Store;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Locatable;

public class ExpansionBuilderImpl<S, O, V>
implements ExpansionBuilder<S, O, V, ExpansionBuilderImpl<S, O, V>> {
    private ExpansionBuilder.ExpansionFunction<S, O, V> func;
    private String id;
    private String auth;
    private String ver = "1.0";
    private String desc;
    private String url;
    private Class<? extends O> observerClass;
    private Object plugin;
    private Object config;
    private Object listeners;
    private boolean relational = false;
    private Predicate<Expansion<S, O, V>> reload = func -> true;
    private Class<? extends V> returnClass;
    private Class<? extends S> sourceClass;
    private List<String> tokens = new ArrayList<String>();
    private boolean verify = true;

    public static <S, O, V> ExpansionBuilderImpl<S, O, V> builder(Class<? extends S> s, Class<? extends O> o, Class<? extends V> v) {
        return new ExpansionBuilderImpl<S, O, V>(true, s, o, v);
    }

    private static String fix(String id) {
        if ((id = id.toLowerCase().trim()).startsWith("rel_")) {
            id = id.substring(4);
        }
        return id.replace("_", "").replace(" ", "");
    }

    private static <S, O, V> ExpansionBuilderImpl<S, O, V> from(ExpansionBuilderImpl<?, ?, ?> builder, Expansion<S, O, V> exp) {
        if (!exp.verify()) {
            return builder;
        }
        ExpansionBuilderImpl<?, ?, ?> b = builder;
        ExpansionBuilderImpl<S, O, V> n = ExpansionBuilderImpl.unverified(ExpansionBuilderImpl.src(exp, builder), ExpansionBuilderImpl.obs(exp, builder), ExpansionBuilderImpl.val(exp, builder));
        ((ExpansionBuilderImpl)((ExpansionBuilderImpl)((ExpansionBuilderImpl)((ExpansionBuilderImpl)((ExpansionBuilderImpl)((ExpansionBuilderImpl)n.relational(b.relational)).id(b.id)).author(b.auth)).description(b.desc)).config(b.config)).tokens((List)b.tokens)).version(b.ver);
        try {
            n.url(b.url);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (b.plugin != null) {
            n.plugin(b.plugin);
        }
        if (n.config == null) {
            n.config = exp.getConfiguration();
        }
        n.func = exp::parse;
        return n;
    }

    private static <O> Class<? extends O> obs(Expansion<?, O, ?> e, ExpansionBuilderImpl<?, ?, ?> b) {
        if (e.getObserverClass() == null) {
            return b.getObserverClass();
        }
        return e.getObserverClass();
    }

    private static <V> Class<? extends V> val(Expansion<?, ?, V> e, ExpansionBuilderImpl<?, ?, ?> b) {
        if (e.getValueClass() == null) {
            return b.getValueClass();
        }
        return e.getValueClass();
    }

    private static <S> Class<? extends S> src(Expansion<S, ?, ?> e, ExpansionBuilderImpl<?, ?, ?> b) {
        if (e.getSourceClass() == null) {
            return b.getSourceClass();
        }
        return e.getSourceClass();
    }

    private static ExpansionBuilderImpl<?, ?, ?> lfm(Object o, Method m, Object p, boolean rel) {
        Store s = Store.get();
        return super.frommethod(o, m, p);
    }

    public static ExpansionBuilderImpl<?, ?, ?> load(Object src, String id, Object plugin) {
        Method m = Store.find(src, id, false);
        boolean relational = false;
        if (m == null) {
            m = Store.find(src, id, true);
            relational = true;
            if (m == null) {
                throw new IllegalArgumentException("No placeholder exists with that id!");
            }
        }
        return ExpansionBuilderImpl.lfm(src, m, plugin, relational);
    }

    public static List<ExpansionBuilderImpl<?, ?, ?>> loadAll(Object object, Object plugin) {
        Map<Method, Boolean> methods = Store.findAll(object);
        List l = methods.entrySet().stream().map(e -> ExpansionBuilderImpl.lfm(object, (Method)e.getKey(), plugin, (Boolean)e.getValue())).collect(Collectors.toList());
        return l.stream().map(e -> (ExpansionBuilderImpl)e).collect(Collectors.toList());
    }

    public static <S, O, V> ExpansionBuilderImpl<S, O, V> unverified(Class<? extends S> s, Class<? extends O> o, Class<? extends V> v) {
        return new ExpansionBuilderImpl<S, O, V>(false, s, o, v);
    }

    private static boolean verifySource(Class<?> param) {
        return param == null || MessageReceiver.class.isAssignableFrom(param) || Locatable.class.isAssignableFrom(param) || Subject.class.isAssignableFrom(param) || DataHolder.class.isAssignableFrom(param);
    }

    private ExpansionBuilderImpl(boolean verify, Class<? extends S> s, Class<? extends O> o, Class<? extends V> v) {
        this.verify = verify;
        this.sourceClass = s;
        this.returnClass = v;
        this.observerClass = o;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> addTokens(List<String> tokens) {
        if (this.tokens == null) {
            return this.tokens((List)tokens);
        }
        this.tokens.addAll(tokens);
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> author(String author) {
        this.auth = author;
        return this;
    }

    @Override
    public Expansion<S, O, V> build() throws Exception {
        if (this.id == null || this.id.isEmpty()) {
            throw new IllegalStateException("ID must be specified!");
        }
        if (this.func == null) {
            throw new IllegalStateException("Function must be specified!");
        }
        if (this.plugin == null) {
            throw new IllegalStateException("Plugin cannot be null!");
        }
        if (this.verify) {
            Preconditions.checkArgument((boolean)this.verify());
        }
        Expansion exp = new Expansion<S, O, V>(this.id, this.plugin, this.auth, this.desc, this.ver, this.url == null || this.url.isEmpty() ? null : new URL(this.url), this.relational, this.tokens, this.sourceClass, this.observerClass, this.returnClass){

            @Override
            public V parse(S source, O observer, Optional<String> token) throws Exception {
                return ExpansionBuilderImpl.this.func.parse(source, observer, token);
            }

            @Override
            public boolean reload() {
                return ExpansionBuilderImpl.this.reload.test(this);
            }
        };
        if (this.config != null) {
            exp.setConfig(this.config);
        }
        if (this.listeners != null) {
            exp.setReloadListeners(() -> {
                PlaceholderAPIPlugin.getInstance().unregisterListeners(this.listeners);
                PlaceholderAPIPlugin.getInstance().registerListeners(this.listeners, this.plugin);
            });
        }
        this.id = null;
        return exp;
    }

    @Override
    public boolean buildAndRegister() throws Exception {
        IExpansion exp = this.build();
        return Store.get().register((Expansion<?, ?, ?>)exp);
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> config(Object config) {
        this.config = config;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> current() {
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> description(String description) {
        this.desc = description;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> from(Expansion<S, O, V> exp) {
        this.id = exp.id();
        this.auth = exp.author();
        this.desc = exp.description();
        this.ver = exp.version();
        this.url = exp.url().toString();
        this.tokens = exp.tokens();
        this.plugin = exp.getPlugin();
        this.config = exp.getConfiguration();
        this.relational = exp.relational();
        this.func = exp::parse;
        this.sourceClass = exp.getSourceClass();
        this.observerClass = exp.getObserverClass();
        this.returnClass = exp.getValueClass();
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> from(Object obj, String id, Object plugin) {
        Method m = Store.find(obj, id, this.relational);
        if (m == null && (m = Store.find(obj, id, !this.relational)) == null) {
            throw new IllegalArgumentException("No placeholder by that ID found!");
        }
        return this.frommethod(obj, m, plugin);
    }

    private ExpansionBuilderImpl frommethod(Object o, Method m, Object p) {
        Expansion<?, ?, ?> exp = Store.get().createForMethod(m, o, p);
        if (exp == null) {
            return this;
        }
        return ExpansionBuilderImpl.from(((ExpansionBuilderImpl)this.id(exp.id())).plugin(p), exp);
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> fromUnknown(Expansion<?, ?, ?> exp) {
        if (!(exp.getObserverClass().isAssignableFrom(this.getObserverClass()) && exp.getSourceClass().isAssignableFrom(this.getSourceClass()) && this.getValueClass().isAssignableFrom(exp.getValueClass()))) {
            throw new IllegalArgumentException("Expansion types not supported!");
        }
        return this.from((Expansion)exp);
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> function(ExpansionBuilder.ExpansionFunction<S, O, V> exec) {
        this.func = exec;
        return this;
    }

    @Override
    public String getAuthor() {
        return this.auth;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public final Class<? extends O> getObserverClass() {
        return this.observerClass;
    }

    public final Class<? extends S> getSourceClass() {
        return this.sourceClass;
    }

    @Override
    public List<String> getTokens() {
        return this.tokens;
    }

    @Override
    public URL getUrl() throws Exception {
        return new URL(this.url);
    }

    @Override
    public String getUrlString() {
        return this.url;
    }

    public final Class<? extends V> getValueClass() {
        return this.returnClass;
    }

    @Override
    public String getVersion() {
        return this.ver;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> id(String id) {
        this.id = ExpansionBuilderImpl.fix(id);
        return this;
    }

    @Override
    public boolean isRelational() {
        return this.relational;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> listen(Object o) {
        if (o != null) {
            this.listeners = o;
        }
        return this;
    }

    private V parse(S s, O o, Optional<String> t) {
        return null;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> plugin(Object plugin) {
        Optional plox = Sponge.getPluginManager().fromInstance(plugin);
        if (!plox.isPresent()) {
            throw new IllegalArgumentException("Plugin object is not valid!");
        }
        this.plugin = plugin;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> relational(boolean relational) {
        this.relational = relational;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> reloadFunction(Predicate<Expansion<S, O, V>> reload) {
        this.reload = reload == null ? f -> true : reload;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> reset() {
        return ExpansionBuilderImpl.unverified(this.getSourceClass(), this.getObserverClass(), this.getValueClass());
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> tokens(List<String> tokens) {
        this.tokens = tokens;
        return this;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> url(String url) throws Exception {
        this.url = new URL(url).toString();
        return this;
    }

    public boolean verify() {
        boolean out = false;
        try {
            out = ExpansionBuilderImpl.verifySource(this.sourceClass) && ExpansionBuilderImpl.verifySource(this.observerClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out) {
            this.verify = false;
        }
        return out;
    }

    @Override
    public ExpansionBuilderImpl<S, O, V> version(String version) {
        this.ver = version;
        return this;
    }
}

