/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.placeholder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.rojo8399.placeholderapi.Attach;
import me.rojo8399.placeholderapi.Listening;
import me.rojo8399.placeholderapi.NoValueException;
import me.rojo8399.placeholderapi.Observer;
import me.rojo8399.placeholderapi.Placeholder;
import me.rojo8399.placeholderapi.Relational;
import me.rojo8399.placeholderapi.Requires;
import me.rojo8399.placeholderapi.Source;
import me.rojo8399.placeholderapi.Token;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.configs.Messages;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.ExpansionBuilderImpl;
import me.rojo8399.placeholderapi.impl.placeholder.gen.ClassPlaceholderFactory;
import me.rojo8399.placeholderapi.impl.placeholder.gen.DefineableClassLoader;
import me.rojo8399.placeholderapi.impl.placeholder.gen.InternalExpansion;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import ninja.leaping.configurate.ConfigurationNode;
import ninja.leaping.configurate.objectmapping.ObjectMapper;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.spongepowered.api.Platform;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.world.Locatable;

public class Store {
    private static Store instance;
    private final DefineableClassLoader classLoader = new DefineableClassLoader(Sponge.getEventManager().getClass().getClassLoader());
    private final ClassPlaceholderFactory factory = new ClassPlaceholderFactory("me.rojo8399.placeholderapi.placeholder", this.classLoader);
    private Map<String, Expansion<?, ?, ?>> normal = new ConcurrentHashMap();
    private Map<String, Expansion<?, ?, ?>> rel = new ConcurrentHashMap();

    static Method find(Object object, String id, boolean rel) {
        for (Method m : object.getClass().getMethods()) {
            Placeholder p = m.getAnnotation(Placeholder.class);
            if (p == null || !Store.fix(p.id()).equals(Store.fix(id))) continue;
            if (rel) {
                if (!m.isAnnotationPresent(Relational.class)) continue;
                return m;
            }
            return m;
        }
        return null;
    }

    static Map<Method, Boolean> findAll(Object object) {
        Class<?> c = object.getClass();
        if (!Modifier.isPublic(c.getModifiers())) {
            throw new IllegalArgumentException("Class must be public!");
        }
        HashMap<Method, Boolean> out = new HashMap<Method, Boolean>();
        for (Method m : c.getMethods()) {
            if (!Modifier.isPublic(m.getModifiers()) || !m.isAnnotationPresent(Placeholder.class)) continue;
            out.put(m, m.isAnnotationPresent(Relational.class));
        }
        return out;
    }

    private static final String fix(String id) {
        if ((id = id.toLowerCase().trim()).startsWith("rel_")) {
            id = id.substring(4);
        }
        return id.replace("_", "").replace(" ", "");
    }

    public static Store get() {
        if (instance == null) {
            instance = new Store();
        }
        return instance;
    }

    private static boolean verifySource(Parameter param) {
        return MessageReceiver.class.isAssignableFrom(param.getType()) || Locatable.class.isAssignableFrom(param.getType()) || Subject.class.isAssignableFrom(param.getType()) || DataHolder.class.isAssignableFrom(param.getType());
    }

    private Store() {
    }

    public List<String> allIds() {
        return Stream.concat(this.getMap(true).entrySet().stream(), this.getMap(false).entrySet().stream()).filter(e -> ((Expansion)e.getValue()).isEnabled()).map(Map.Entry::getKey).distinct().collect(Collectors.toList());
    }

    Expansion<?, ?, ?> createForMethod(Method m, Object o, Object plugin) {
        Expansion<?, ?, ?> pl;
        Class<?> c = o.getClass();
        boolean l = c.isAnnotationPresent(Listening.class);
        boolean co = c.isAnnotationPresent(ConfigSerializable.class);
        int code = this.verify(o, m);
        if (code > 0) {
            PlaceholderAPIPlugin.getInstance().getLogger().warn("Method " + m.getName() + " in " + o.getClass().getName() + " cannot be loaded!");
            switch (code) {
                case 1: {
                    PlaceholderAPIPlugin.getInstance().getLogger().warn("This should not happen! Please report this bug on GitHub!");
                    break;
                }
                case 5: 
                case 6: {
                    PlaceholderAPIPlugin.getInstance().getLogger().warn("Placeholder already registered!");
                    break;
                }
                case 4: 
                case 7: {
                    PlaceholderAPIPlugin.getInstance().getLogger().warn("Method contains incorrect or extra parameters!");
                    break;
                }
                case 8: {
                    PlaceholderAPIPlugin.getInstance().getLogger().warn("Sponge Version not supported by placeholder!");
                    break;
                }
                case 9: {
                    PlaceholderAPIPlugin.getInstance().getLogger().warn("Missing plugin dependency!");
                }
            }
            return null;
        }
        Placeholder p = m.getAnnotation(Placeholder.class);
        boolean r = m.isAnnotationPresent(Relational.class);
        try {
            pl = this.factory.create(o, m);
        }
        catch (Exception e) {
            PlaceholderAPIPlugin.getInstance().getLogger().warn("An exception occured while creating the placeholder!");
            e.printStackTrace();
            return null;
        }
        if (co) {
            try {
                this.fillExpansionConfig(pl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (l) {
            Object o2 = o;
            pl.setReloadListeners(() -> {
                PlaceholderAPIPlugin.getInstance().unregisterListeners(o2);
                PlaceholderAPIPlugin.getInstance().registerListeners(o2, plugin);
            });
        }
        pl.setId(p.id());
        pl.setRelational(r);
        pl.reloadListeners();
        pl.refresh();
        return pl;
    }

    public void fillExpansionConfig(Expansion<?, ?, ?> exp) throws Exception {
        Class<?> fieldData = Class.forName(ObjectMapper.class.getName() + "$FieldData");
        Class<?> expClass = exp.getConfiguration().getClass();
        ObjectMapper mapper = ObjectMapper.forClass(expClass);
        Field fieldDataMap = mapper.getClass().getDeclaredField("cachedFields");
        fieldDataMap.setAccessible(true);
        Map map = (Map)fieldDataMap.get(mapper);
        for (Map.Entry entry : map.entrySet()) {
            Object fd = entry.getValue();
            Field fx = fieldData.getDeclaredField("field");
            fx.setAccessible(true);
            Field actual = (Field)fx.get(fd);
            actual.setAccessible(true);
            if (actual.isAnnotationPresent(Attach.class) && actual.getAnnotation(Attach.class).value().equalsIgnoreCase(exp.id()) && actual.getAnnotation(Attach.class).relational() == exp.relational()) {
                fieldData.getDeclaredMethod("deserializeFrom", Object.class, ConfigurationNode.class).invoke(fd, exp.getConfiguration(), this.getNode(exp).getNode(new Object[]{entry.getKey()}));
                continue;
            }
            if (actual.isAnnotationPresent(Attach.class)) continue;
            PlaceholderAPIPlugin.getInstance().getLogger().warn("Field " + fx.getName() + " in placeholder id=" + exp.id() + "'s config is not attached to a placeholder!");
        }
    }

    public Optional<Expansion<?, ?, ?>> get(String id, boolean relational) {
        if (!this.has(id, relational)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.getMap(relational).get(id));
    }

    private Map<String, Expansion<?, ?, ?>> getMap(boolean rel) {
        return rel ? this.rel : this.normal;
    }

    public ConfigurationNode getNode(Expansion<?, ?, ?> exp) {
        if (exp.getConfiguration() == null) {
            return null;
        }
        String plid = ((PluginContainer)Sponge.getPluginManager().fromInstance(exp.getPlugin()).get()).getId();
        return PlaceholderAPIPlugin.getInstance().getRootConfig().getNode(new Object[]{"expansions", plid, (exp.relational() ? "rel_" : "") + exp.id(), "data"});
    }

    public Optional<Class<?>> getObserverType(Method m) {
        return this.getType(m, Observer.class);
    }

    public Optional<Class<?>> getSourceType(Method m) {
        return this.getType(m, Source.class);
    }

    public Optional<Class<?>> getTokenType(Method m) {
        return this.getType(m, Token.class);
    }

    private Optional<Class<?>> getType(Method m, Class<? extends Annotation> annotation) {
        List<Parameter> params = Arrays.asList(m.getParameters());
        if (!params.stream().anyMatch(p -> p.isAnnotationPresent(annotation))) {
            return Optional.empty();
        }
        return Optional.of(params.stream().filter(p -> p.isAnnotationPresent(annotation)).findAny().get().getType());
    }

    public boolean has(String id) {
        return this.has(id, true) || this.has(id, false);
    }

    public boolean has(String id, boolean relational) {
        if (id == null) {
            return false;
        }
        return this.getMap(relational).containsKey(Store.fix(id));
    }

    public List<String> ids(boolean relational) {
        return this.getMap(relational).entrySet().stream().filter(e -> ((Expansion)e.getValue()).isEnabled()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public boolean isBoth(String id) {
        return this.isRelational(id) && this.isNormal(id);
    }

    public boolean isNormal(String id) {
        return this.normal.containsKey(Store.fix(id));
    }

    public boolean isRelational(String id) {
        return this.rel.containsKey(Store.fix(id));
    }

    public Object parse(String id, boolean relational, Object src, Object obs, Optional<String> token) throws Exception {
        if (!this.has(id, relational)) {
            return null;
        }
        Expansion<?, ?, ?> exp = this.get(id, relational).get();
        if (!exp.isEnabled()) {
            throw new NoValueException(Messages.get().placeholder.notEnabled.t(new Object[0]));
        }
        try {
            if (src == null || obs == null) {
                if (src != null && exp.getSourceClass().isAssignableFrom(src.getClass())) {
                    return exp.parse(exp.convertSource(src), null, token);
                }
                if (obs != null && exp.getSourceClass().isAssignableFrom(obs.getClass())) {
                    return exp.parse(null, exp.convertObserver(obs), token);
                }
                return exp.parse(null, null, token);
            }
            if (exp.getSourceClass().isAssignableFrom(src.getClass()) && exp.getObserverClass().isAssignableFrom(obs.getClass())) {
                return exp.parse(exp.convertSource(src), exp.convertObserver(obs), token);
            }
        }
        catch (NoValueException e) {
            throw new NoValueException(e.getTextMessage(), e.suggestions().isEmpty() ? exp.getSuggestions(token.orElse(null)) : e.suggestions());
        }
        throw new NoValueException(Messages.get().placeholder.invalidSrcObs.t(new Object[0]));
    }

    public <T> Optional<T> parse(String id, boolean relational, Object src, Object obs, Optional<String> token, Class<T> expected) throws Exception {
        Object o = this.parse(id, relational, src, obs, token);
        return TypeUtils.tryCast(o, expected);
    }

    public boolean register(Expansion<?, ?, ?> expansion) {
        String id = Store.fix(expansion.id());
        if (this.getMap(expansion.relational()).containsKey(id)) {
            return false;
        }
        expansion.populateConfig();
        expansion.reloadListeners();
        this.getMap(expansion.relational()).put(id, expansion);
        return true;
    }

    private boolean reload(Expansion<?, ?, ?> e, String id, boolean rel) {
        if (!e.refresh()) {
            return false;
        }
        boolean out = true;
        if (e instanceof InternalExpansion) {
            Object handle = ((InternalExpansion)e).getHandle();
            this.getMap(rel).remove(id);
            try {
                out = ((ExpansionBuilderImpl)((ExpansionBuilderImpl)ExpansionBuilderImpl.builder(e.getSourceClass(), e.getObserverClass(), e.getValueClass()).fromUnknown((Expansion)e)).from(handle, id, e.getPlugin())).buildAndRegister();
            }
            catch (Exception e1) {
                return false;
            }
        }
        return out;
    }

    public boolean reload(String id) {
        if (!this.has(id)) {
            return false;
        }
        id = Store.fix(id);
        Optional<Expansion<?, ?, ?>> rel = this.get(id, true);
        Optional<Expansion<?, ?, ?>> norm = this.get(id, false);
        boolean out = true;
        if (rel.isPresent()) {
            boolean bl = out = out && this.reload(rel.get(), id, true);
        }
        if (norm.isPresent()) {
            out = out && this.reload(norm.get(), id, false);
        }
        return out;
    }

    public int reloadAll() {
        return Stream.concat(this.getMap(true).keySet().stream(), this.getMap(false).keySet().stream()).distinct().map(this::reload).map(b -> b != false ? 1 : 0).reduce(0, TypeUtils::add);
    }

    public void saveAll() {
        Stream.concat(this.getMap(true).values().stream(), this.getMap(false).values().stream()).forEach(Expansion::saveConfig);
    }

    public void saveExpansionConfig(Expansion<?, ?, ?> exp) throws Exception {
        Class<ObjectMapper> objectMapper = ObjectMapper.class;
        Class<?> fieldData = Class.forName(objectMapper.getName() + "$FieldData");
        Class<?> expClass = exp.getConfiguration().getClass();
        ObjectMapper mapper = ObjectMapper.forClass(expClass);
        Field fieldDataMap = mapper.getClass().getDeclaredField("cachedFields");
        fieldDataMap.setAccessible(true);
        Map map = (Map)fieldDataMap.get(mapper);
        for (Map.Entry entry : map.entrySet()) {
            Object fd = entry.getValue();
            Field fx = fieldData.getDeclaredField("field");
            fx.setAccessible(true);
            Field actual = (Field)fx.get(fd);
            actual.setAccessible(true);
            if (actual.isAnnotationPresent(Attach.class) && actual.getAnnotation(Attach.class).value().equalsIgnoreCase(exp.id()) && actual.getAnnotation(Attach.class).relational() == exp.relational()) {
                fieldData.getDeclaredMethod("serializeTo", Object.class, ConfigurationNode.class).invoke(fd, exp.getConfiguration(), this.getNode(exp).getNode(new Object[]{entry.getKey()}));
                continue;
            }
            if (actual.isAnnotationPresent(Attach.class)) continue;
            PlaceholderAPIPlugin.getInstance().getLogger().warn("Field " + fx.getName() + " in placeholder id=" + exp.id() + "'s config is not attached to a placeholder!");
        }
    }

    private int verify(Object object, Method m) {
        Placeholder p = m.getAnnotation(Placeholder.class);
        if (p != null) {
            String id = Store.fix(p.id());
            List<Parameter> params = Arrays.asList(m.getParameters());
            boolean relational = m.isAnnotationPresent(Relational.class);
            if (relational) {
                if (this.rel.containsKey(id)) {
                    return 5;
                }
            } else if (this.normal.containsKey(id)) {
                return 6;
            }
            if (!params.stream().map(px -> {
                if (px.getAnnotation(Token.class) != null) {
                    return true;
                }
                if (px.getAnnotation(Source.class) != null || px.getAnnotation(Observer.class) != null) {
                    return Store.verifySource(px);
                }
                return false;
            }).reduce(true, TypeUtils::and).booleanValue()) {
                return 7;
            }
            if (params.stream().map(px -> {
                if (px.getAnnotation(Token.class) != null) {
                    return true;
                }
                if (px.getAnnotation(Source.class) != null || px.getAnnotation(Observer.class) != null) {
                    return Store.verifySource(px);
                }
                return false;
            }).filter(px -> px).count() != (long)params.size()) {
                return 4;
            }
            if (m.isAnnotationPresent(Requires.class)) {
                Requires r = m.getAnnotation(Requires.class);
                String spv = Sponge.getPlatform().getContainer(Platform.Component.API).getVersion().orElse("5.1");
                if (!r.spongeVersion().isEmpty() && !TypeUtils.matchVersion(r.spongeVersion(), spv)) {
                    return 8;
                }
                for (String pl : r.plugins()) {
                    if (!pl.contains(":") && !Sponge.getPluginManager().isLoaded(pl)) {
                        return 9;
                    }
                    String pid = pl.split(":")[0];
                    String ver = pl.replace(pid + ":", "");
                    Optional plc = Sponge.getPluginManager().getPlugin(pid);
                    if (plc.isPresent()) {
                        PluginContainer pc = (PluginContainer)plc.get();
                        String pcv = pc.getVersion().orElse(null);
                        if (pcv == null) {
                            return 9;
                        }
                        if (TypeUtils.matchVersion(ver, pcv)) continue;
                        return 9;
                    }
                    return 9;
                }
            }
            return 0;
        }
        return 1;
    }
}

