/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.placeholder.gen;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import me.rojo8399.placeholderapi.NoValueException;
import me.rojo8399.placeholderapi.Observer;
import me.rojo8399.placeholderapi.Placeholder;
import me.rojo8399.placeholderapi.Source;
import me.rojo8399.placeholderapi.Token;
import me.rojo8399.placeholderapi.impl.placeholder.Expansion;
import me.rojo8399.placeholderapi.impl.placeholder.gen.DefineableClassLoader;
import me.rojo8399.placeholderapi.impl.placeholder.gen.InternalExpansion;
import me.rojo8399.placeholderapi.impl.utils.TypeUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.spongepowered.api.world.Locatable;

public class ClassPlaceholderFactory {
    private static final String OBJECT_NAME;
    private static final String OPT_NAME;
    private static final Map<Class<?>, Integer> order;
    private static final String PLACEHOLDER_NAME;
    private static final String STRING_NAME;
    private static final String TLC_SIG;
    private static final String TRIM_SIG;
    private final LoadingCache<Method, Class<? extends Expansion<?, ?, ?>>> cache = CacheBuilder.newBuilder().concurrencyLevel(1).weakValues().build(new CacheLoader<Method, Class<? extends Expansion<?, ?, ?>>>(){

        public Class<? extends Expansion<?, ?, ?>> load(Method method) throws Exception {
            return ClassPlaceholderFactory.this.createClass(method);
        }
    });
    private DefineableClassLoader classLoader;
    private AtomicInteger iid = new AtomicInteger();
    private String targetPackage;

    private static Class<?> boxedPrim(Class<?> primClass) {
        if (primClass.isPrimitive()) {
            if (primClass.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (primClass.equals(Character.TYPE)) {
                return Character.class;
            }
            if (primClass.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (primClass.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (primClass.equals(Long.TYPE)) {
                return Long.class;
            }
            if (primClass.equals(Short.TYPE)) {
                return Short.class;
            }
            if (primClass.equals(Float.TYPE)) {
                return Float.class;
            }
            if (primClass.equals(Double.TYPE)) {
                return Double.class;
            }
        }
        return primClass;
    }

    private static void boxToPrim(MethodVisitor mv, Class<?> p, int varloc) {
        if (!p.isPrimitive()) {
            return;
        }
        String boxName = null;
        String typeName = null;
        String value = Type.getInternalName(p);
        int store = 54;
        int load = 21;
        Consumer<MethodVisitor> converter = mv2 -> {};
        if (p.equals(Integer.TYPE)) {
            boxName = "Integer";
            typeName = "I";
        }
        if (p.equals(Character.TYPE)) {
            boxName = "Character";
            typeName = "C";
            converter = mv2 -> mv2.visitInsn(146);
        }
        if (p.equals(Byte.TYPE)) {
            boxName = "Byte";
            typeName = "B";
            converter = mv2 -> mv2.visitInsn(145);
        }
        if (p.equals(Boolean.TYPE)) {
            boxName = "Boolean";
            typeName = "Z";
            converter = mv2 -> mv2.visitInsn(145);
        }
        if (p.equals(Long.TYPE)) {
            boxName = "Long";
            typeName = "J";
            load = 22;
            store = 55;
        }
        if (p.equals(Short.TYPE)) {
            boxName = "Short";
            typeName = "S";
            converter = mv2 -> mv2.visitInsn(147);
        }
        if (p.equals(Float.TYPE)) {
            boxName = "Float";
            typeName = "F";
            load = 23;
            store = 56;
        }
        if (p.equals(Double.TYPE)) {
            boxName = "Double";
            typeName = "D";
            load = 24;
            store = 57;
        }
        if (typeName == null || boxName == null) {
            return;
        }
        mv.visitMethodInsn(182, "java/lang/" + boxName, value + "Value", "()" + typeName, false);
        mv.visitVarInsn(store, varloc);
        mv.visitVarInsn(load, varloc);
        converter.accept(mv);
    }

    private static int getOrder(Parameter p) {
        for (Annotation a : p.getAnnotations()) {
            if (!order.containsKey(a.annotationType())) continue;
            return order.get(a.annotationType());
        }
        return 0;
    }

    private static void nullCheck(MethodVisitor mv, boolean nullable, Consumer<MethodVisitor> success, boolean throwError) {
        if (nullable) {
            return;
        }
        Label no = new Label();
        mv.visitJumpInsn(199, no);
        if (throwError) {
            mv.visitTypeInsn(187, Type.getInternalName(NoValueException.class));
            mv.visitVarInsn(58, 7);
            mv.visitVarInsn(25, 7);
            mv.visitMethodInsn(183, Type.getInternalName(NoValueException.class), "<init>", "()V", false);
            mv.visitVarInsn(25, 7);
            mv.visitInsn(191);
        } else {
            mv.visitInsn(1);
            mv.visitInsn(176);
        }
        mv.visitLabel(no);
        success.accept(mv);
    }

    private static void returnInsn(MethodVisitor mv, Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Float.TYPE)) {
                mv.visitInsn(174);
                return;
            }
            if (clazz.equals(Long.TYPE)) {
                mv.visitInsn(173);
                return;
            }
            if (clazz.equals(Double.TYPE)) {
                mv.visitInsn(175);
                return;
            }
            mv.visitInsn(172);
            return;
        }
        mv.visitInsn(176);
    }

    private static void skipIfNull(MethodVisitor mv, Consumer<MethodVisitor> success) {
        Label no = new Label();
        mv.visitJumpInsn(198, no);
        success.accept(mv);
        mv.visitLabel(no);
    }

    private static void tryCatch(MethodVisitor mv, Consumer<MethodVisitor> t, Consumer<MethodVisitor> c) {
        Label st = new Label();
        Label et = new Label();
        Label sc = new Label();
        Label ec = new Label();
        mv.visitTryCatchBlock(st, et, sc, "java/lang/Exception");
        mv.visitLabel(st);
        t.accept(mv);
        mv.visitLabel(et);
        mv.visitJumpInsn(167, ec);
        mv.visitLabel(sc);
        c.accept(mv);
        mv.visitLabel(ec);
    }

    private static void unboxFromPrim(MethodVisitor mv, Class<?> p) {
        if (!p.isPrimitive()) {
            return;
        }
        String boxName = null;
        String typeName = null;
        if (p.equals(Integer.TYPE)) {
            boxName = "Integer";
            typeName = "I";
        }
        if (p.equals(Character.TYPE)) {
            boxName = "Character";
            typeName = "C";
        }
        if (p.equals(Byte.TYPE)) {
            boxName = "Byte";
            typeName = "B";
        }
        if (p.equals(Boolean.TYPE)) {
            boxName = "Boolean";
            typeName = "Z";
        }
        if (p.equals(Long.TYPE)) {
            boxName = "Long";
            typeName = "J";
        }
        if (p.equals(Short.TYPE)) {
            boxName = "Short";
            typeName = "S";
        }
        if (p.equals(Float.TYPE)) {
            boxName = "Float";
            typeName = "F";
        }
        if (p.equals(Double.TYPE)) {
            boxName = "Double";
            typeName = "D";
        }
        if (typeName == null || boxName == null) {
            return;
        }
        mv.visitMethodInsn(184, "java/lang/" + boxName, "valueOf", "(" + typeName + ")Ljava/lang/" + boxName + ";", false);
    }

    private static void utilsTryCast(MethodVisitor mv, Class<?> expected, boolean orNull) {
        mv.visitLdcInsn((Object)Type.getType(expected));
        mv.visitFieldInsn(178, "java/lang/Boolean", "TRUE", "Ljava/lang/Boolean;");
        mv.visitMethodInsn(184, Type.getInternalName(TypeUtils.class), "tryCast", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/Boolean;)Ljava/util/Optional;", false);
        if (orNull) {
            mv.visitInsn(1);
            mv.visitMethodInsn(182, OPT_NAME, "orElse", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        }
    }

    public ClassPlaceholderFactory(String targetPackage, DefineableClassLoader loader) {
        Preconditions.checkNotNull((Object)targetPackage, (Object)"targetPackage");
        Preconditions.checkArgument((!targetPackage.isEmpty() ? 1 : 0) != 0, (Object)"targetPackage cannot be empty");
        this.targetPackage = targetPackage + '.';
        this.classLoader = (DefineableClassLoader)Preconditions.checkNotNull((Object)loader, (Object)"classLoader");
    }

    public Expansion<?, ?, ?> create(Object handle, Method method) throws Exception {
        if (!Modifier.isPublic(handle.getClass().getModifiers())) {
            throw new IllegalArgumentException("Class must be public!");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must be public!");
        }
        return (Expansion)((Class)this.cache.get((Object)method)).getConstructor(method.getDeclaringClass()).newInstance(handle);
    }

    Class<? extends Expansion<?, ?, ?>> createClass(Method method) throws Exception {
        Class<?> handle = method.getDeclaringClass();
        if (!Modifier.isPublic(handle.getModifiers())) {
            throw new IllegalArgumentException("Class must be public!");
        }
        if (!Modifier.isPublic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must be public!");
        }
        String id = method.getAnnotation(Placeholder.class).id();
        String name = this.targetPackage + id + "Placeholder_" + handle.getSimpleName() + "_" + method.getName() + this.iid.incrementAndGet();
        byte[] bytes = this.generateClass(name, handle, method);
        return this.classLoader.defineClass(name, bytes);
    }

    private byte[] generateClass(String name, Class<?> handle, Method method) {
        name = name.replace(".", "/");
        String handleName = Type.getInternalName(handle);
        String handleDescriptor = Type.getDescriptor(handle);
        List<Parameter> pm = Arrays.asList(method.getParameters());
        boolean token = pm.stream().anyMatch(p -> p.isAnnotationPresent(Token.class));
        boolean source = pm.stream().anyMatch(p -> p.isAnnotationPresent(Source.class));
        boolean observer = pm.stream().anyMatch(p -> p.isAnnotationPresent(Observer.class));
        boolean srcNullable = pm.stream().filter(p -> p.isAnnotationPresent(Source.class)).anyMatch(p -> p.isAnnotationPresent(Nullable.class));
        boolean optionalTokenType = token && pm.stream().anyMatch(p -> p.getType().equals(Optional.class));
        Optional tokenClass = token ? pm.stream().filter(p -> p.isAnnotationPresent(Token.class)).findAny().map(pr -> {
            if (optionalTokenType) {
                return (Class)((ParameterizedType)pr.getParameterizedType()).getActualTypeArguments()[0];
            }
            return pr.getType();
        }) : Optional.empty();
        token = token && tokenClass.isPresent();
        boolean obsNullable = pm.stream().filter(p -> p.isAnnotationPresent(Observer.class)).anyMatch(p -> p.isAnnotationPresent(Nullable.class));
        boolean tokNullable = token && !optionalTokenType && pm.stream().filter(p -> p.isAnnotationPresent(Token.class)).anyMatch(p -> p.isAnnotationPresent(Nullable.class));
        boolean fixToken = token && pm.stream().filter(p -> p.isAnnotationPresent(Token.class)).map(p -> p.getAnnotation(Token.class)).anyMatch(t -> t.fix());
        Optional<Class> sourceType = pm.stream().filter(p -> p.isAnnotationPresent(Source.class)).findFirst().map(Parameter::getType);
        Optional<Class> observerType = pm.stream().filter(p -> p.isAnnotationPresent(Observer.class)).findFirst().map(Parameter::getType);
        Class<Object> returnType = method.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            returnType = Object.class;
        }
        String retString = Type.getDescriptor(returnType);
        String parseMethodDescriptor = "(L" + Type.getInternalName(sourceType.orElse(Locatable.class)) + ";L" + Type.getInternalName(observerType.orElse(Locatable.class)) + ";L" + OPT_NAME + ";)" + retString;
        String externalParseDescriptor = "(Ljava/lang/Object;Ljava/lang/Object;Ljava/util/Optional;)Ljava/lang/Object;";
        String methodDescriptor = Type.getMethodDescriptor((Method)method);
        ClassWriter cw = new ClassWriter(3);
        cw.visit(52, 49, name, null, PLACEHOLDER_NAME, null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", '(' + handleDescriptor + ")V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)method.getAnnotation(Placeholder.class).id());
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, PLACEHOLDER_NAME, "<init>", "(L" + STRING_NAME + ";L" + OBJECT_NAME + ";)V", false);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "parse", parseMethodDescriptor, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, name, "handle", "L" + OBJECT_NAME + ";");
        mv.visitTypeInsn(192, handleName);
        if (token) {
            if (!String.class.isAssignableFrom((Class)tokenClass.get()) || ((Class)tokenClass.get()).isArray() && String.class.isAssignableFrom(((Class)tokenClass.get()).getComponentType())) {
                mv.visitVarInsn(25, 3);
                mv.visitInsn(1);
                mv.visitMethodInsn(182, OPT_NAME, "orElse", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                if (optionalTokenType) {
                    ClassPlaceholderFactory.utilsTryCast(mv, ClassPlaceholderFactory.boxedPrim((Class)tokenClass.get()), false);
                    mv.visitVarInsn(58, 3);
                } else {
                    mv.visitVarInsn(58, 4);
                    mv.visitVarInsn(25, 4);
                    ClassPlaceholderFactory.skipIfNull(mv, mv2 -> {
                        mv2.visitVarInsn(25, 4);
                        ClassPlaceholderFactory.utilsTryCast(mv2, ClassPlaceholderFactory.boxedPrim((Class)tokenClass.get()), true);
                        mv2.visitVarInsn(58, 4);
                    });
                }
            } else if (!optionalTokenType) {
                mv.visitVarInsn(25, 3);
                mv.visitInsn(1);
                mv.visitMethodInsn(182, OPT_NAME, "orElse", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
                mv.visitVarInsn(58, 4);
                if (fixToken) {
                    mv.visitVarInsn(25, 4);
                    ClassPlaceholderFactory.skipIfNull(mv, mv2 -> {
                        mv2.visitVarInsn(25, 4);
                        mv2.visitTypeInsn(192, STRING_NAME);
                        mv2.visitMethodInsn(182, STRING_NAME, "toLowerCase", TLC_SIG, false);
                        mv2.visitMethodInsn(182, STRING_NAME, "trim", TRIM_SIG, false);
                        mv2.visitVarInsn(58, 4);
                    });
                }
            }
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            int x = 0;
            Parameter p2 = method.getParameters()[i];
            x = ClassPlaceholderFactory.getOrder(p2);
            if (x == 2 && !optionalTokenType) {
                x = 3;
            }
            mv.visitVarInsn(25, x + 1);
            boolean nullable = false;
            switch (x) {
                case 0: {
                    nullable = srcNullable;
                    break;
                }
                case 1: {
                    nullable = obsNullable;
                    break;
                }
                case 3: {
                    nullable = tokNullable;
                }
            }
            int y = x;
            ClassPlaceholderFactory.nullCheck(mv, nullable, mv2 -> mv2.visitVarInsn(25, y + 1), x == 3 && token);
            mv.visitTypeInsn(192, Type.getInternalName(ClassPlaceholderFactory.boxedPrim(p2.getType())));
            ClassPlaceholderFactory.boxToPrim(mv, p2.getType(), y + 1);
        }
        mv.visitMethodInsn(182, handleName, method.getName(), methodDescriptor, false);
        if (method.getReturnType().equals(Void.TYPE)) {
            mv.visitLdcInsn((Object)"");
        }
        if (!retString.startsWith("L")) {
            ClassPlaceholderFactory.returnInsn(mv, returnType);
        } else {
            mv.visitInsn(176);
        }
        mv.visitMaxs(10, 10);
        mv.visitEnd();
        mv = cw.visitMethod(1, "parse", externalParseDescriptor, null, new String[]{"java/lang/Exception"});
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        if (sourceType.isPresent() && source) {
            mv.visitVarInsn(25, 1);
            ClassPlaceholderFactory.tryCatch(mv, mv2 -> mv2.visitTypeInsn(192, Type.getInternalName((Class)((Class)sourceType.get()))), mv2 -> {
                mv2.visitLdcInsn((Object)"");
                mv2.visitInsn(176);
            });
        } else {
            mv.visitInsn(1);
        }
        if (observerType.isPresent() && observer) {
            mv.visitVarInsn(25, 2);
            ClassPlaceholderFactory.tryCatch(mv, mv2 -> mv2.visitTypeInsn(192, Type.getInternalName((Class)((Class)observerType.get()))), mv2 -> {
                mv2.visitLdcInsn((Object)"");
                mv2.visitInsn(176);
            });
        } else {
            mv.visitInsn(1);
        }
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(182, name, "parse", parseMethodDescriptor, false);
        ClassPlaceholderFactory.unboxFromPrim(mv, returnType);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }

    static {
        String f;
        OBJECT_NAME = Type.getInternalName(Object.class);
        OPT_NAME = Type.getInternalName(Optional.class);
        PLACEHOLDER_NAME = Type.getInternalName(InternalExpansion.class);
        STRING_NAME = Type.getInternalName(String.class);
        order = new HashMap();
        order.put(Source.class, 0);
        order.put(Observer.class, 1);
        order.put(Token.class, 2);
        try {
            f = Type.getMethodDescriptor((Method)String.class.getMethod("toLowerCase", new Class[0]));
        }
        catch (Exception e) {
            f = "()Ljava/lang/String;";
        }
        TLC_SIG = f;
        try {
            f = Type.getMethodDescriptor((Method)String.class.getMethod("trim", new Class[0]));
        }
        catch (Exception e) {
            f = "()Ljava/lang/String;";
        }
        TRIM_SIG = f;
    }
}

