/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.LiteralText;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextTemplate;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.ShiftClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextFormat;
import org.spongepowered.api.text.serializer.FormattingCodeTextSerializer;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.text.translation.Translatable;

public class TextUtils {
    private static Text fix(Text to, TextFormat l) {
        return to.toBuilder().format(l.merge(to.getFormat())).build();
    }

    public static List<Text> flatten(Text text) {
        if (text == null || text.isEmpty()) {
            return new ArrayList<Text>();
        }
        ArrayList<Text> out = new ArrayList<Text>();
        ImmutableList children = text.getChildren();
        out.add(text.toBuilder().removeAll().build());
        children.forEach(c -> out.addAll(TextUtils.flatten(c)));
        return out;
    }

    public static TextFormat getLastFormat(Text text) {
        if (text.getChildren().isEmpty()) {
            return text.getFormat();
        }
        return text.getChildren().stream().map(t -> t.getFormat()).reduce((t, t2) -> t.merge(t2)).orElse(text.getFormat());
    }

    private static TextTemplate multi(String p, Pattern pattern, Text t) {
        TextTemplate out = TextTemplate.of();
        Matcher m = pattern.matcher(p);
        m.find();
        String p2 = m.group();
        String ex = m.group(1);
        String pre = p2.substring(0, p2.indexOf(ex));
        String post = p2.substring(p2.indexOf(ex) + ex.length());
        String pt = p.substring(0, p.indexOf(p2));
        String ppt = p.substring(p.indexOf(p2) + p2.length());
        boolean recurse = false;
        if (pattern.matcher(ppt).find()) {
            recurse = true;
        }
        LiteralText.Builder ptt = Text.builder((String)pt).format(t.getFormat());
        LiteralText.Builder pptt = Text.builder((String)ppt).format(t.getFormat());
        t.getClickAction().ifPresent(arg_0 -> TextUtils.lambda$multi$3((Text.Builder)ptt, (Text.Builder)pptt, arg_0));
        t.getShiftClickAction().ifPresent(arg_0 -> TextUtils.lambda$multi$4((Text.Builder)ptt, (Text.Builder)pptt, arg_0));
        t.getHoverAction().ifPresent(arg_0 -> TextUtils.lambda$multi$5((Text.Builder)ptt, (Text.Builder)pptt, arg_0));
        Text pretext = ptt.build();
        Text posttext = pptt.build();
        if (recurse) {
            return out.concat(TextTemplate.of((String)pre, (String)post, (Object[])new Object[]{pretext, TextTemplate.arg((String)ex).format(t.getFormat())})).concat(TextUtils.multi(ppt, pattern, t));
        }
        return out.concat(TextTemplate.of((String)pre, (String)post, (Object[])new Object[]{pretext, TextTemplate.arg((String)ex).format(t.getFormat()), posttext}));
    }

    public static Text ofItem(@Nullable ItemStack item) {
        if (item == null) {
            return Text.EMPTY;
        }
        String q = item.getQuantity() > 1 ? " (" + item.getQuantity() + ")" : "";
        return Text.of((Object[])new Object[]{TextActions.showItem((ItemStackSnapshot)item.createSnapshot()), item.getOrElse(Keys.DISPLAY_NAME, (Object)Text.of((Translatable)item, (Object[])new Object[0])), q});
    }

    public static Text ofItem(@Nullable ItemStackSnapshot item) {
        if (item == null) {
            return Text.EMPTY;
        }
        return Text.of((Object[])new Object[]{TextActions.showItem((ItemStackSnapshot)item), item.getOrElse(Keys.DISPLAY_NAME, (Object)Text.of((Object[])new Object[]{item}))});
    }

    public static TextTemplate parse(String i, Pattern placeholderPattern) {
        TextFormat last;
        String in;
        if (i == null) {
            return null;
        }
        Function<String, Text> parser = arg_0 -> ((FormattingCodeTextSerializer)TextSerializers.FORMATTING_CODE).deserialize(arg_0);
        if (placeholderPattern == null) {
            placeholderPattern = Pattern.compile("[%]([^ %]+)[%]", 2);
        }
        if (!placeholderPattern.matcher(in = i).find()) {
            return TextTemplate.of((Object[])new Object[]{parser.apply(in)});
        }
        String[] textParts = in.split(placeholderPattern.pattern());
        Matcher matcher = placeholderPattern.matcher(in);
        TextTemplate out = textParts.length == 0 ? TextTemplate.of() : TextTemplate.of((Object[])new Object[]{parser.apply(textParts[0])});
        int x = 1;
        TextFormat textFormat = last = textParts.length == 0 ? TextFormat.NONE : TextUtils.getLastFormat(parser.apply(textParts[0]));
        while ((matcher = matcher.reset(in)).find()) {
            String mg = matcher.group().substring(1);
            mg = mg.substring(0, mg.length() - 1);
            if (x <= textParts.length) {
                last = last.merge(TextUtils.getLastFormat(parser.apply(textParts[x - 1])));
            }
            out = out.concat(TextTemplate.of((Object[])new Object[]{TextTemplate.arg((String)mg).format(last)}));
            if (x < textParts.length) {
                out = out.concat(TextTemplate.of((Object[])new Object[]{TextUtils.fix(parser.apply(textParts[x]), last)}));
            }
            in = matcher.replaceFirst("");
            ++x;
        }
        return out;
    }

    public static Text repeat(Text original, int times) {
        Text out = original;
        for (int i = 0; i < times; ++i) {
            out = out.concat(original);
        }
        return out;
    }

    public static Text replace(Text original, String o, String n) {
        List<Text> texts = TextUtils.flatten(original);
        return texts.stream().map(text -> TextUtils.replace(text, o, n, true)).reduce(Text.of(), Text::concat);
    }

    private static Text replace(Text or, String o, String n, boolean priv) {
        if (!(or instanceof LiteralText)) {
            return or;
        }
        LiteralText lt = (LiteralText)or;
        return lt.toBuilder().content(lt.getContent().replace(o, n)).build();
    }

    public static TextTemplate toTemplate(Text text, Pattern pattern) {
        List<Text> flat = TextUtils.flatten(text);
        TextTemplate out = TextTemplate.EMPTY;
        for (Text t : flat) {
            String p = t.toPlain();
            Matcher m = pattern.matcher(p);
            if (m.matches()) {
                String ex = m.group(1);
                String pre = p.substring(0, p.indexOf(ex));
                String post = p.substring(p.indexOf(ex) + ex.length());
                out = out.concat(TextTemplate.of((String)pre, (String)post, (Object[])new Object[]{TextTemplate.arg((String)ex).format(t.getFormat())}));
                continue;
            }
            m = pattern.matcher(p);
            if (m.find()) {
                out = out.concat(TextUtils.multi(p, pattern, t));
                continue;
            }
            out = out.concat(TextTemplate.of((Object[])new Object[]{t}));
        }
        return out;
    }

    public static Text toText(TextTemplate template, Optional<Map<String, Object>> preexisting) {
        Map a = preexisting.orElse(new HashMap());
        template.getArguments().entrySet().stream().filter(e -> !a.containsKey(e.getKey())).forEach(e -> a.put(e.getKey(), template.getOpenArgString() + (String)e.getKey() + template.getCloseArgString()));
        return template.apply(a).build();
    }

    private static /* synthetic */ void lambda$multi$5(Text.Builder ptt, Text.Builder pptt, HoverAction c) {
        ptt.onHover(c);
        pptt.onHover(c);
    }

    private static /* synthetic */ void lambda$multi$4(Text.Builder ptt, Text.Builder pptt, ShiftClickAction c) {
        ptt.onShiftClick(c);
        pptt.onShiftClick(c);
    }

    private static /* synthetic */ void lambda$multi$3(Text.Builder ptt, Text.Builder pptt, ClickAction c) {
        ptt.onClick(c);
        pptt.onClick(c);
    }
}

