/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.utils;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.rojo8399.placeholderapi.impl.PlaceholderAPIPlugin;
import me.rojo8399.placeholderapi.impl.PlaceholderServiceImpl;
import me.rojo8399.placeholderapi.impl.utils.TextUtils;
import me.rojo8399.placeholderapi.impl.utils.Version;
import me.rojo8399.placeholderapi.impl.utils.VersionRange;
import org.apache.commons.lang3.StringUtils;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.serializer.TextSerializers;

public class TypeUtils {
    private static Map<TypeToken<?>, Function<String, ?>> deserializers = new HashMap();
    private static final Pattern STRING_TO_VAL_PATTERN = Pattern.compile("(parse.*)|(valueOf)|(deserialize)|(fromString)|(from)", 2);

    public static int add(int one, int two) {
        return one + two;
    }

    public static boolean and(boolean one, boolean two) {
        return one && two;
    }

    public static boolean closeTo(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.isEmpty() && b.isEmpty()) {
            return true;
        }
        if (a.isEmpty() || b.isEmpty()) {
            return false;
        }
        if (a.equalsIgnoreCase(b)) {
            return true;
        }
        if (StringUtils.getJaroWinklerDistance((CharSequence)(a = a.toLowerCase()), (CharSequence)(b = b.toLowerCase())) > 0.7) {
            return true;
        }
        if (a.contains(b) && b.length() > 1) {
            return true;
        }
        return b.contains(a) && a.length() > 1;
    }

    public static <T> T convertPrimitive(String val, Class<T> primitiveClass) {
        val = val.toLowerCase().trim();
        if (primitiveClass.equals(Character.TYPE) || primitiveClass.equals(Character.class)) {
            return (T)Character.valueOf(val.charAt(0));
        }
        if (primitiveClass.equals(Integer.TYPE) || primitiveClass.equals(Integer.class)) {
            return (T)Integer.valueOf(val);
        }
        if (primitiveClass.equals(Long.TYPE) || primitiveClass.equals(Long.class)) {
            return (T)Long.valueOf(val);
        }
        if (primitiveClass.equals(Short.TYPE) || primitiveClass.equals(Short.class)) {
            return (T)Short.valueOf(val);
        }
        if (primitiveClass.equals(Byte.TYPE) || primitiveClass.equals(Byte.class)) {
            return (T)Byte.valueOf(val);
        }
        if (primitiveClass.equals(Double.TYPE) || primitiveClass.equals(Double.class)) {
            return (T)Double.valueOf(val);
        }
        if (primitiveClass.equals(Float.TYPE) || primitiveClass.equals(Float.class)) {
            return (T)Float.valueOf(val);
        }
        if (primitiveClass.equals(Boolean.TYPE) || primitiveClass.equals(Boolean.class)) {
            return (T)Boolean.valueOf(TypeUtils.isTrue(val));
        }
        throw new IllegalArgumentException("Class is not primitive or a wrapper!");
    }

    public static String formatDuration(Duration duration) {
        long seconds = duration.getSeconds();
        long absSeconds = Math.abs(seconds);
        String positive = String.format("%d h %d m %d s", absSeconds / 3600L, absSeconds % 3600L / 60L, absSeconds % 60L);
        return seconds < 0L ? "-" + positive : positive;
    }

    public static boolean isTrue(String val) {
        switch (val.toLowerCase()) {
            case "t": 
            case "true": 
            case "1": 
            case "y": 
            case "yes": {
                return true;
            }
        }
        return false;
    }

    public static int mult(int one, int two) {
        return one * two;
    }

    public static boolean nand(boolean one, boolean two) {
        return !TypeUtils.and(one, two);
    }

    public static boolean nor(boolean one, boolean two) {
        return !TypeUtils.or(one, two);
    }

    public static boolean or(boolean one, boolean two) {
        return one || two;
    }

    public static boolean matchVersion(String pattern, String actual) {
        VersionRange range = new VersionRange(pattern);
        Version ver = new Version(actual);
        return range.isInRange(ver);
    }

    public static void registerDeserializer(TypeToken<?> token, Function<String, ?> fun) {
        Preconditions.checkNotNull(fun, (Object)"deserializer");
        Preconditions.checkNotNull(token, (Object)"token");
        deserializers.put(token, fun);
    }

    public static int sub(int one, int two) {
        return one - two;
    }

    public static <T> Optional<T> tryCast(Object val, Class<T> expected) {
        if (val == null) {
            return Optional.empty();
        }
        if (expected == null) {
            throw new IllegalArgumentException("Must provide an expected class!");
        }
        if (val instanceof BaseValue && !BaseValue.class.isAssignableFrom(expected)) {
            return TypeUtils.tryCast(((BaseValue)val).get(), expected);
        }
        if (val instanceof Supplier) {
            Supplier fun = (Supplier)val;
            return TypeUtils.tryCast(fun.get(), expected);
        }
        if (Text.class.isAssignableFrom(expected)) {
            if (val instanceof Text) {
                return TypeUtils.tryOptional(() -> expected.cast(val));
            }
            if (val instanceof ItemStack) {
                return TypeUtils.tryOptional(() -> expected.cast(TextUtils.ofItem((ItemStack)val)));
            }
            if (val instanceof Instant) {
                return TypeUtils.tryOptional(() -> expected.cast(TextSerializers.FORMATTING_CODE.deserialize(PlaceholderAPIPlugin.getInstance().formatter().format(LocalDateTime.ofInstant((Instant)val, ZoneId.systemDefault())))));
            }
            if (val instanceof Duration) {
                String dur = TypeUtils.formatDuration((Duration)val);
                return TypeUtils.tryOptional(() -> expected.cast(TextSerializers.FORMATTING_CODE.deserialize(dur)));
            }
            if (val instanceof LocalDateTime) {
                return TypeUtils.tryOptional(() -> expected.cast(TextSerializers.FORMATTING_CODE.deserialize(PlaceholderAPIPlugin.getInstance().formatter().format((LocalDateTime)val))));
            }
            if (val instanceof CommandSource) {
                return TypeUtils.tryOptional(() -> expected.cast(TextSerializers.FORMATTING_CODE.deserialize(String.valueOf(((CommandSource)val).getName()))));
            }
            if (val.getClass().isArray()) {
                List l2 = TypeUtils.unboxPrimitiveArray(val).stream().map(o -> TypeUtils.tryCast(o, expected)).flatMap(TypeUtils.unmapOptional()).collect(Collectors.toList());
                return TypeUtils.tryOptional(() -> expected.cast(Text.joinWith((Text)Text.of((String)", "), (Iterable)l2)));
            }
            if (val instanceof Iterable) {
                final Iterable l = (Iterable)val;
                List l2 = new ArrayList<Object>(){
                    {
                        for (Object o : l) {
                            this.add(o);
                        }
                    }
                }.stream().map(o -> TypeUtils.tryCast(o, expected)).flatMap(TypeUtils.unmapOptional()).collect(Collectors.toList());
                return TypeUtils.tryOptional(() -> expected.cast(Text.joinWith((Text)Text.of((String)", "), (Iterable)l2)));
            }
            return TypeUtils.tryOptional(() -> expected.cast(TextSerializers.FORMATTING_CODE.deserialize(String.valueOf(val))));
        }
        if (val instanceof String) {
            if (String.class.isAssignableFrom(expected)) {
                return TypeUtils.tryOptional(() -> expected.cast(val));
            }
            if (expected.isArray() && String.class.isAssignableFrom(expected.getComponentType())) {
                String v = (String)val;
                if (v.isEmpty()) {
                    return Optional.empty();
                }
                if (!v.contains("_")) {
                    return TypeUtils.tryOptional(() -> expected.cast(new String[]{v}));
                }
                String[] x = v.split("_");
                if (x.length == 0) {
                    return Optional.empty();
                }
                boolean ne = false;
                for (String s : x) {
                    ne = ne || !s.isEmpty();
                }
                if (!ne) {
                    return Optional.empty();
                }
                return TypeUtils.tryOptional(() -> expected.cast(x));
            }
            if (List.class.isAssignableFrom(expected) && String.class.isAssignableFrom(expected.getTypeParameters()[0].getGenericDeclaration())) {
                String v = (String)val;
                if (v.isEmpty()) {
                    return Optional.empty();
                }
                if (!v.contains("_")) {
                    return TypeUtils.tryOptional(() -> expected.cast(Arrays.asList(v)));
                }
                String[] x = v.split("_");
                if (x.length == 0) {
                    return Optional.empty();
                }
                boolean ne = false;
                for (String s : x) {
                    ne = ne || !s.isEmpty();
                }
                if (!ne) {
                    return Optional.empty();
                }
                return TypeUtils.tryOptional(() -> expected.cast(Arrays.asList(x)));
            }
            Optional<Object> opt = TypeUtils.tryOptional(() -> TypeUtils.convertPrimitive((String)val, expected));
            if (opt.isPresent()) {
                return opt;
            }
            opt = deserializers.entrySet().stream().filter(e -> ((TypeToken)e.getKey()).isAssignableFrom((Type)expected)).map(e -> (Function)e.getValue()).map(f -> TypeUtils.tryOptional(() -> f.apply((String)val))).flatMap(TypeUtils.unmapOptional()).findAny().flatMap(o -> TypeUtils.tryOptional(() -> expected.cast(o)));
            if (opt.isPresent()) {
                return opt;
            }
            try {
                Method method = Arrays.asList(expected.getDeclaredMethods()).stream().filter(m -> Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())).filter(m -> Arrays.asList(m.getParameterTypes()).stream().filter(c -> c.equals(String.class)).findAny().isPresent()).filter(m -> m.getReturnType().equals(expected) || m.getReturnType().equals(Optional.class)).filter(m -> STRING_TO_VAL_PATTERN.matcher(m.getName()).find()).findAny().get();
                Object valout = method.invoke(null, (String)val);
                if (valout == null) {
                    return Optional.empty();
                }
                if (expected.isInstance(valout)) {
                    MethodHandle mh = MethodHandles.publicLookup().unreflect(method);
                    PlaceholderServiceImpl.get().registerTypeDeserializer(TypeToken.of(expected), str -> {
                        try {
                            return expected.cast(mh.invokeExact((String)val));
                        }
                        catch (Throwable e1) {
                            throw new RuntimeException(e1);
                        }
                    });
                    return TypeUtils.tryOptional(() -> expected.cast(valout));
                }
                if (valout instanceof Optional) {
                    Optional valopt = (Optional)valout;
                    if (!valopt.isPresent()) {
                        return Optional.empty();
                    }
                    Object v = valopt.get();
                    if (expected.isInstance(v)) {
                        MethodHandle mh = MethodHandles.publicLookup().unreflect(method);
                        PlaceholderServiceImpl.get().registerTypeDeserializer(TypeToken.of(expected), str -> {
                            try {
                                Optional optx = mh.invokeExact((String)val);
                                return expected.cast(optx.get());
                            }
                            catch (Throwable e1) {
                                throw new RuntimeException(e1);
                            }
                        });
                        return TypeUtils.tryOptional(() -> expected.cast(v));
                    }
                    return Optional.empty();
                }
                return Optional.empty();
            }
            catch (Exception e2) {
                return Optional.empty();
            }
        }
        return TypeUtils.tryOptional(() -> expected.cast(val));
    }

    public static <T> Optional<T> tryCast(Object val, Class<T> expected, Boolean fixStrings) {
        if (val instanceof String && fixStrings.booleanValue()) {
            return TypeUtils.tryCast(((String)val).toLowerCase().trim(), expected);
        }
        return TypeUtils.tryCast(val, expected);
    }

    public static <T> Optional<T> tryOptional(Supplier<T> fun) {
        try {
            return Optional.ofNullable(fun.get());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> T tryOrNull(Supplier<T> funct) {
        try {
            return funct.get();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<?> unboxPrimitiveArray(Object primArr) {
        if (primArr.getClass().isArray()) {
            if (primArr.getClass().getComponentType().isPrimitive()) {
                Class<?> primClazz = primArr.getClass().getComponentType();
                if (primClazz.equals(Integer.TYPE)) {
                    int[] a = (int[])primArr;
                    ArrayList<Integer> out = new ArrayList<Integer>();
                    for (int i : a) {
                        out.add(i);
                    }
                    return out;
                }
                if (primClazz.equals(Long.TYPE)) {
                    long[] a = (long[])primArr;
                    ArrayList<Long> out = new ArrayList<Long>();
                    for (long i : a) {
                        out.add(i);
                    }
                    return out;
                }
                if (primClazz.equals(Short.TYPE)) {
                    short[] a = (short[])primArr;
                    ArrayList<Short> out = new ArrayList<Short>();
                    for (short i : a) {
                        out.add(i);
                    }
                    return out;
                }
                if (primClazz.equals(Byte.TYPE)) {
                    byte[] a = (byte[])primArr;
                    ArrayList<Byte> out = new ArrayList<Byte>();
                    for (byte i : a) {
                        out.add(i);
                    }
                    return out;
                }
                if (primClazz.equals(Character.TYPE)) {
                    char[] a = (char[])primArr;
                    ArrayList<Character> out = new ArrayList<Character>();
                    for (char i : a) {
                        out.add(Character.valueOf(i));
                    }
                    return out;
                }
                if (primClazz.equals(Boolean.TYPE)) {
                    boolean[] a = (boolean[])primArr;
                    ArrayList<Boolean> out = new ArrayList<Boolean>();
                    for (boolean i : a) {
                        out.add(i);
                    }
                    return out;
                }
                if (primClazz.equals(Float.TYPE)) {
                    float[] a = (float[])primArr;
                    ArrayList<Float> out = new ArrayList<Float>();
                    for (float i : a) {
                        out.add(Float.valueOf(i));
                    }
                    return out;
                }
                if (primClazz.equals(Double.TYPE)) {
                    double[] a = (double[])primArr;
                    ArrayList<Double> out = new ArrayList<Double>();
                    for (double i : a) {
                        out.add(i);
                    }
                    return out;
                }
            }
            return Arrays.asList((Object[])primArr);
        }
        return Arrays.asList(primArr);
    }

    public static <T> Function<Optional<? extends T>, Stream<? extends T>> unmapOptional() {
        return opt -> Stream.of(opt).filter(Optional::isPresent).map(Optional::get);
    }

    public static <T> Stream<? extends T> unmapOptional(Stream<Optional<? extends T>> stream) {
        return stream.flatMap(TypeUtils.unmapOptional());
    }

    public static boolean xnor(boolean o, boolean t) {
        return o && t || !o && !t;
    }

    public static boolean xor(boolean o, boolean t) {
        return !TypeUtils.xnor(o, t);
    }
}

