/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.utils;

import java.util.ArrayList;
import java.util.List;

public class Version
implements Comparable<Version> {
    private String actual;
    private List<SubVersion> subs;

    public Version(String from) {
        from = from.toLowerCase();
        if (from.contains("v")) {
            from = from.replace("v", "");
        }
        String[] parts = from.split("\\.");
        this.actual = from;
        this.subs = new ArrayList<SubVersion>();
        for (String s : parts) {
            this.subs.add(new SubVersion(s));
        }
    }

    public String toString() {
        return this.actual;
    }

    public boolean equals(Object other) {
        return other instanceof Version && ((Version)other).actual.equals(this.actual);
    }

    @Override
    public int compareTo(Version o) {
        int i;
        List<SubVersion> svx = o.subs;
        for (i = 0; i < this.subs.size(); ++i) {
            SubVersion sv = this.subs.get(i);
            if (svx.size() > i) {
                int dif = sv.intVal - svx.get(i).intVal;
                if (dif == 0) continue;
                return dif;
            }
            return sv.intVal;
        }
        if (svx.size() > this.subs.size()) {
            for (i = this.subs.size(); i < svx.size(); ++i) {
                if (svx.get(i).intVal == 0) continue;
                return -svx.get(i).intVal;
            }
            return 0;
        }
        return 0;
    }

    private static class SubVersion
    implements Comparable<SubVersion> {
        private int intVal;

        public SubVersion(String val) {
            try {
                this.intVal = Integer.parseInt(val);
            }
            catch (Exception e) {
                Character c;
                String top = "";
                char[] cArray = val.toCharArray();
                int n = cArray.length;
                for (int i = 0; i < n && (c = Character.valueOf(cArray[i])).charValue() >= '0' && c.charValue() <= '9'; ++i) {
                    top = top + c.charValue();
                }
                this.intVal = Integer.parseInt(top);
            }
        }

        @Override
        public int compareTo(SubVersion o) {
            return Integer.compare(this.intVal, o.intVal);
        }

        public String toString() {
            return "" + this.intVal;
        }

        public boolean equals(Object other) {
            return other instanceof SubVersion && ((SubVersion)other).intVal == this.intVal;
        }
    }
}

