/*
 * Decompiled with CFR 0.152.
 */
package me.rojo8399.placeholderapi.impl.utils;

import java.util.regex.Pattern;
import me.rojo8399.placeholderapi.impl.utils.Version;

public class VersionRange {
    private String actual;
    private Version leftSide;
    private Version rightSide;
    private boolean leftExc;
    private boolean rightExc;
    private boolean retall = false;
    private static final Pattern VERSION = Pattern.compile("((?:\\d)(?:\\.\\d)*)", 2);

    public VersionRange(String from) {
        this.actual = from;
        if (VERSION.matcher(from).matches()) {
            this.retall = true;
        } else {
            this.leftExc = from.startsWith("(");
            this.rightExc = from.endsWith(")");
            from = this.rightExc ? from.replace(")", "") : from.replace("]", "");
            from = this.leftExc ? from.replace("(", "") : from.replace("[", "");
            if (from.contains(",")) {
                String[] parts = from.split(",");
                if (from.startsWith(",")) {
                    this.rightSide = new Version(from.replace(",", ""));
                } else {
                    this.leftSide = new Version(parts[0]);
                    if (parts.length > 1 && !parts[1].isEmpty()) {
                        this.rightSide = new Version(parts[1]);
                    }
                }
            } else {
                this.leftSide = this.rightSide = new Version(from);
            }
        }
    }

    public String toString() {
        return this.actual;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actual == null ? 0 : this.actual.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionRange)) {
            return false;
        }
        VersionRange other = (VersionRange)obj;
        return !(this.actual == null ? other.actual != null : !this.actual.equals(other.actual));
    }

    public boolean isInRange(Version ver) {
        int rightbound;
        if (this.retall) {
            return true;
        }
        int leftcomp = this.leftSide == null ? -1 : this.leftSide.compareTo(ver);
        int rightcomp = this.rightSide == null ? 1 : this.rightSide.compareTo(ver);
        int leftbound = this.leftExc ? -1 : 0;
        int n = rightbound = this.rightExc ? 1 : 0;
        return !(leftcomp > leftbound && this.leftSide != null || rightcomp < rightbound && this.rightSide != null);
    }
}

