/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.world;

import com.creativemd.creativecore.client.mods.optifine.OptifineHelper;
import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.GL30;

@SideOnly(value=Side.CLIENT)
public class RenderUploader {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static Field vertexCountField = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"count", "field_177364_c"});
    private static Field bufferIdField = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"glBufferId", "field_177365_a"});
    private static Field formatField = ReflectionHelper.findField(VertexBuffer.class, (String[])new String[]{"vertexFormat", "field_177363_b"});
    private static Field arbVboField = ReflectionHelper.findField(OpenGlHelper.class, (String[])new String[]{"arbVbo", "field_176090_Y"});

    public static void uploadRenderData(RenderChunk chunk, List<TileEntityLittleTiles> tiles) {
        if (FMLClientHandler.instance().hasOptifine() && OptifineHelper.isRenderRegions() || !LittleTiles.CONFIG.rendering.uploadToVBODirectly) {
            return;
        }
        try {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                BlockRenderLayer layer = BlockRenderLayer.values()[i];
                int expanded = 0;
                for (TileEntityLittleTiles te : tiles) {
                    BufferBuilder teBufferBuilder;
                    if (te.buffer == null || (teBufferBuilder = te.buffer.getBufferByLayer(layer)) == null) continue;
                    expanded += teBufferBuilder.func_178966_f().limit();
                }
                try {
                    ByteBuffer toUpload;
                    if (expanded <= 0) continue;
                    CompiledChunk compiled = chunk.func_178571_g();
                    VertexBuffer uploadBuffer = chunk.func_178565_b(i);
                    if (uploadBuffer == null) {
                        return;
                    }
                    if (layer == BlockRenderLayer.TRANSLUCENT) {
                        boolean empty = compiled.func_178487_c() == null || compiled.func_178491_b(BlockRenderLayer.TRANSLUCENT);
                        BufferBuilder builder = new BufferBuilder((empty ? 0 : compiled.func_178487_c().func_179013_a().length * 4) + expanded);
                        builder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
                        builder.func_178969_c((double)(-chunk.func_178568_j().func_177958_n()), (double)(-chunk.func_178568_j().func_177956_o()), (double)(-chunk.func_178568_j().func_177952_p()));
                        if (!empty) {
                            builder.func_178993_a(compiled.func_178487_c());
                        }
                        for (TileEntityLittleTiles te : tiles) {
                            BufferBuilder teBufferBuilder;
                            if (te.buffer == null || (teBufferBuilder = te.buffer.getBufferByLayer(layer)) == null) continue;
                            BufferBuilderUtils.addBuffer((BufferBuilder)builder, (BufferBuilder)teBufferBuilder);
                        }
                        Entity entity = mc.func_175606_aa();
                        float x = (float)entity.field_70165_t;
                        float y = (float)entity.field_70163_u + entity.func_70047_e();
                        float z = (float)entity.field_70161_v;
                        builder.func_181674_a(x, y, z);
                        compiled.func_178494_a(builder.func_181672_a());
                        builder.func_178977_d();
                        toUpload = builder.func_178966_f();
                    } else {
                        VertexFormat format = (VertexFormat)formatField.get(uploadBuffer);
                        int uploadedVertexCount = vertexCountField.getInt(uploadBuffer);
                        uploadBuffer.func_177359_a();
                        boolean empty = compiled.func_178491_b(layer);
                        Buffer vanillaBuffer = empty ? null : RenderUploader.glMapBufferRange(OpenGlHelper.field_176089_P, uploadedVertexCount * format.func_177338_f(), 1, null);
                        uploadBuffer.func_177361_b();
                        toUpload = ByteBuffer.allocateDirect((vanillaBuffer != null ? vanillaBuffer.limit() : 0) + expanded);
                        if (vanillaBuffer != null) {
                            toUpload.put((ByteBuffer)vanillaBuffer);
                        }
                        for (TileEntityLittleTiles te : tiles) {
                            BufferBuilder teBufferBuilder;
                            if (te.buffer == null || (teBufferBuilder = te.buffer.getBufferByLayer(layer)) == null) continue;
                            ByteBuffer buffer = teBufferBuilder.func_178966_f();
                            buffer.position(0);
                            toUpload.put(buffer);
                        }
                    }
                    uploadBuffer.func_177362_c();
                    bufferIdField.setInt(uploadBuffer, OpenGlHelper.func_176073_e());
                    toUpload.position(0);
                    uploadBuffer.func_181722_a(toUpload);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (NotSupportedException notSupportedException) {
            // empty catch block
        }
    }

    public static ByteBuffer glMapBufferRange(int target, long length, int access, ByteBuffer old_buffer) throws NotSupportedException {
        try {
            if (arbVboField.getBoolean(null)) {
                return ARBVertexBufferObject.glMapBufferARB((int)target, (int)access, (long)length, (ByteBuffer)old_buffer);
            }
            if (OpenGlHelper.func_176075_f()) {
                return GL30.glMapBufferRange((int)target, (long)0L, (long)length, (int)access, (ByteBuffer)old_buffer);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | IllegalStateException e) {
            if (e instanceof IllegalStateException) {
                throw new NotSupportedException(e);
            }
            e.printStackTrace();
        }
        return null;
    }

    public static class NotSupportedException
    extends Exception {
        public NotSupportedException(Exception e) {
            super(e);
        }
    }
}

