/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.action.block;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.LittleTilesConfig;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionCombined;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.action.block.LittleActionDestroyBoxes;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceAbsolute;
import com.creativemd.littletiles.common.api.ILittleTile;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleAbsoluteBox;
import com.creativemd.littletiles.common.tile.math.box.LittleBoxes;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviews;
import com.creativemd.littletiles.common.tile.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredient;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class LittleActionPlaceStack
extends LittleAction {
    public PlacementHelper.PositionResult position;
    public boolean centered;
    public boolean fixed;
    public PlacementMode mode;
    public LittlePreviews previews;
    public LittlePlaceResult placedTiles;
    public LittleBoxes boxes;
    public LittleAbsolutePreviews destroyed;

    public LittleActionPlaceStack(LittlePreviews previews, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) {
        this.position = position;
        this.centered = centered;
        this.fixed = fixed;
        this.mode = mode;
        this.previews = previews;
    }

    public LittleActionPlaceStack() {
    }

    public void checkMode(LittlePreviews previews) {
        if (previews.hasStructure() && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    public void checkMode(LittleStructure structure) {
        if (structure != null && !this.mode.canPlaceStructures()) {
            System.out.println("Using invalid mode for placing structure. mode=" + this.mode.name);
            this.mode = PlacementMode.getStructureDefault();
        }
    }

    @Override
    public boolean canBeReverted() {
        return true;
    }

    @Override
    public LittleAction revert() {
        this.boxes.convertToSmallest();
        if (this.destroyed != null) {
            this.destroyed.convertToSmallest();
            return new LittleActionCombined(new LittleActionDestroyBoxes(this.boxes), new LittleActionPlaceAbsolute(this.destroyed, PlacementMode.normal, true));
        }
        return new LittleActionDestroyBoxes(this.boxes);
    }

    @Override
    protected boolean action(EntityPlayer player) throws LittleActionException {
        ItemStack stack = player.func_184614_ca();
        World world = player.field_70170_p;
        if (!LittleActionPlaceStack.isAllowedToInteract(world, player, this.position.getPos(), true, EnumFacing.EAST)) {
            LittleActionPlaceStack.sendBlockResetToClient(world, (EntityPlayerMP)player, this.position.getPos());
            return false;
        }
        if (PlacementHelper.getLittleInterface(stack) != null) {
            LittlePlaceResult tiles = this.placeTile(player, stack, player.field_70170_p, this.position, this.centered, this.fixed, this.mode);
            if (!player.field_70170_p.field_72995_K) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
                playerMP.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
            }
            return tiles != null;
        }
        return false;
    }

    public void writeBytes(ByteBuf buf) {
        this.position.writeToBytes(buf);
        buf.writeBoolean(this.centered);
        buf.writeBoolean(this.fixed);
        LittleActionPlaceStack.writePlacementMode(this.mode, buf);
        LittleActionPlaceStack.writePreviews(this.previews, buf);
    }

    public void readBytes(ByteBuf buf) {
        this.position = PlacementHelper.PositionResult.readFromBytes(buf);
        this.centered = buf.readBoolean();
        this.fixed = buf.readBoolean();
        this.mode = LittleActionPlaceStack.readPlacementMode(buf);
        this.previews = LittleActionPlaceStack.readPreviews(buf);
    }

    public LittlePlaceResult placeTile(EntityPlayer player, ItemStack stack, World world, PlacementHelper.PositionResult position, boolean centered, boolean fixed, PlacementMode mode) throws LittleActionException {
        PlacementHelper.PreviewResult result;
        ILittleTile iTile = PlacementHelper.getLittleInterface(stack);
        this.checkMode(this.previews);
        if (this.previews.hasStructure()) {
            this.previews.getStructure().createTilesList();
        }
        if ((result = PlacementHelper.getPreviews(world, this.previews, iTile.getPreviewsContext(stack), stack, position, centered, fixed, false, mode)) == null) {
            return null;
        }
        ArrayList<LittleTile> unplaceableTiles = new ArrayList<LittleTile>();
        ArrayList<LittleTile> removedTiles = new ArrayList<LittleTile>();
        ItemStack toPlace = stack.func_77946_l();
        LittleInventory inventory = new LittleInventory(player);
        if (LittleActionPlaceStack.needIngredients(player) && !iTile.containsIngredients(stack)) {
            LittleActionPlaceStack.canTake(player, inventory, LittleActionPlaceStack.getIngredients(result.previews));
        }
        this.placedTiles = LittleActionPlaceStack.placeTiles(world, player, result.context, result.placePreviews, this.previews.getStructure(), mode, position.getPos(), toPlace, unplaceableTiles, removedTiles, position.facing);
        if (this.placedTiles != null) {
            this.boxes = this.placedTiles.placedBoxes;
            if (LittleActionPlaceStack.needIngredients(player)) {
                LittleActionPlaceStack.giveOrDrop(player, inventory, removedTiles);
                if (iTile.containsIngredients(stack)) {
                    stack.func_190918_g(1);
                    LittleActionPlaceStack.giveOrDrop(player, inventory, unplaceableTiles);
                } else {
                    LittleIngredients ingredients = LittleIngredient.extractStructureOnly(this.previews);
                    ingredients.add(LittleActionPlaceStack.getIngredients(this.placedTiles.placedPreviews));
                    LittleActionPlaceStack.take(player, inventory, ingredients);
                }
            }
            if (!removedTiles.isEmpty()) {
                this.destroyed = new LittleAbsolutePreviews(position.getPos(), result.context);
                for (LittleTile tile : removedTiles) {
                    this.destroyed.addTile(tile);
                }
            }
        } else {
            this.boxes = new LittleBoxes(position.getPos(), result.context);
        }
        return this.placedTiles;
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceStack.placeTiles(world, null, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    public static LittlePlaceResult placeTilesWithoutPlayer(World world, LittleGridContext context, List<PlacePreview> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) {
        try {
            return LittleActionPlaceStack.placeTiles(world, null, context, previews, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    private static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, HashMap<BlockPos, PlacePreviews> splitted, LittleStructure parentStructure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (splitted == null) {
            return null;
        }
        List<BlockPos> coordsToCheck = mode.getCoordsToCheck(splitted, pos);
        if (LittleActionPlaceStack.canPlaceTiles(player, world, splitted, coordsToCheck, mode)) {
            LittlePlaceResult placed = new LittlePlaceResult(pos, context, parentStructure);
            ArrayList soundsToBePlayed = new ArrayList();
            ArrayList<LastPlacedTile> lastPlacedTiles = new ArrayList<LastPlacedTile>();
            for (Map.Entry<BlockPos, PlacePreviews> entry : splitted.entrySet()) {
                TileEntityLittleTiles te;
                BlockPos coord = entry.getKey();
                PlacePreviews placeTiles = entry.getValue();
                boolean hascollideBlock = false;
                int i = 0;
                while (i < placeTiles.size()) {
                    if (((PlacePreview)placeTiles.get(i)).needsCollisionTest()) {
                        hascollideBlock = true;
                        ++i;
                        continue;
                    }
                    lastPlacedTiles.add(new LastPlacedTile((PlacePreview)placeTiles.get(i), coord, placeTiles.context));
                    placeTiles.remove(i);
                }
                if (!hascollideBlock) continue;
                boolean requiresCollisionTest = true;
                if (!(world.func_180495_p(coord).func_177230_c() instanceof BlockTile) && world.func_180495_p(coord).func_185904_a().func_76222_j()) {
                    requiresCollisionTest = false;
                    world.func_175656_a(coord, BlockTile.getState(false, false));
                }
                if ((te = LittleActionPlaceStack.loadTe(player, world, coord, mode.shouldConvertBlock())) == null) continue;
                if (te.isEmpty()) {
                    requiresCollisionTest = false;
                }
                boolean collsionTest = requiresCollisionTest;
                placeTiles.ensureBothAreEqual(te);
                te.updateTilesSecretly(x -> {
                    for (PlacePreview placeTile : placeTiles) {
                        for (LittleTile LT : placeTile.placeTile(player, stack, coord, te.getContext(), te, (TileList)x, unplaceableTiles, removedTiles, mode, facing, collsionTest)) {
                            if (!soundsToBePlayed.contains(LT.getSound())) {
                                soundsToBePlayed.add(LT.getSound());
                            }
                            if (placeTile.structurePreview != null) {
                                if (!placeTile.structurePreview.getStructure().hasMainTile()) {
                                    placeTile.structurePreview.getStructure().setMainTile(LT);
                                } else {
                                    LT.connection = placeTile.structurePreview.getStructure().getStructureLink(LT);
                                    LT.connection.setLoadedStructure(placeTile.structurePreview.getStructure());
                                    placeTile.structurePreview.getStructure().add(LT);
                                }
                            }
                            LT.place((TileList)x);
                            LT.onPlaced(player, stack, facing);
                            placed.addPlacedTile(LT);
                        }
                    }
                });
            }
            int j = 0;
            while (j < placed.tileEntities.size()) {
                TileEntityLittleTiles te = placed.tileEntities.get(j);
                if (parentStructure == null) {
                    boolean changed = te.combineTiles();
                    if (te.size() == 1 && te.convertBlockToVanilla()) {
                        placed.tileEntities.remove(j);
                        continue;
                    }
                    if (!changed) {
                        te.updateTiles();
                    }
                } else if (!te.combineTiles(parentStructure)) {
                    te.updateTiles();
                }
                ++j;
            }
            for (LastPlacedTile lastPlacedTile : lastPlacedTiles) {
                for (LittleTile tile : lastPlacedTile.tile.placeTile(player, stack, lastPlacedTile.pos, lastPlacedTile.context, null, null, unplaceableTiles, removedTiles, mode, facing, true)) {
                    if (tile == null) continue;
                    placed.addPlacedTile(tile);
                }
            }
            if (parentStructure != null) {
                if (parentStructure.getMainTile() == null) {
                    throw new LittleActionException("Missing maintile of structure. Placed " + placed.placedPreviews.size() + " tile(s).");
                }
                parentStructure.placedStructure(stack);
            }
            for (int i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_184133_a((EntityPlayer)null, pos, ((SoundType)soundsToBePlayed.get(i)).func_185841_e(), SoundCategory.BLOCKS, (((SoundType)soundsToBePlayed.get(i)).func_185843_a() + 1.0f) / 2.0f, ((SoundType)soundsToBePlayed.get(i)).func_185847_b() * 0.8f);
            }
            return placed;
        }
        return null;
    }

    public static LittlePlaceResult placeTiles(World world, EntityPlayer player, LittleGridContext context, List<PlacePreview> previews, LittleStructure structure, PlacementMode mode, BlockPos pos, ItemStack stack, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, @Nullable EnumFacing facing) throws LittleActionException {
        if (player != null) {
            if (LittleTiles.CONFIG.isPlaceLimited(player) && LittleActionPlaceStack.getVolume(context, previews) > (double)LittleTiles.CONFIG.survival.maxPlaceBlocks) {
                throw new LittleTilesConfig.NotAllowedToPlaceException();
            }
            if (LittleTiles.CONFIG.isTransparencyRestricted(player)) {
                for (PlacePreview placePreview : previews) {
                    LittleActionPlaceStack.isAllowedToPlacePreview(player, placePreview.preview);
                }
            }
        }
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(context, previews, pos);
        if (player != null && !world.field_72995_K) {
            ArrayList<BlockSnapshot> snaps = new ArrayList<BlockSnapshot>();
            for (BlockPos snapPos : splitted.keySet()) {
                snaps.add(new BlockSnapshot(world, snapPos, BlockTile.getState(false, false)));
            }
            BlockEvent.MultiPlaceEvent event = new BlockEvent.MultiPlaceEvent(snaps, world.func_180495_p(facing == null ? pos : pos.func_177972_a(facing)), player, EnumHand.MAIN_HAND);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                for (BlockPos snapPos : splitted.keySet()) {
                    LittleActionPlaceStack.sendBlockResetToClient(world, (EntityPlayerMP)player, pos);
                }
                return null;
            }
        }
        return LittleActionPlaceStack.placeTiles(world, player, context, splitted, structure, mode, pos, stack, unplaceableTiles, removedTiles, facing);
    }

    public static double getVolume(LittleGridContext context, List<PlacePreview> tiles) {
        double volume = 0.0;
        for (PlacePreview preview : tiles) {
            volume += preview.box.getPercentVolume(context);
        }
        return volume;
    }

    public static HashMap<BlockPos, PlacePreviews> getSplittedTiles(LittleGridContext context, List<PlacePreview> tiles, BlockPos pos) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split(context, (HashMapList<BlockPos, PlacePreview>)splitted, pos)) continue;
            return null;
        }
        HashMap<BlockPos, PlacePreviews> previews = new HashMap<BlockPos, PlacePreviews>();
        for (Map.Entry entry : splitted.entrySet()) {
            previews.put((BlockPos)entry.getKey(), new PlacePreviews(context, (List)entry.getValue()));
        }
        return previews;
    }

    public static boolean canPlaceTiles(EntityPlayer player, World world, HashMap<BlockPos, PlacePreviews> splitted, List<BlockPos> coordsToCheck, PlacementMode mode) {
        return LittleActionPlaceStack.canPlaceTiles(player, world, splitted, coordsToCheck, mode, null, false);
    }

    public static boolean canPlaceTiles(EntityPlayer player, World world, HashMap<BlockPos, PlacePreviews> splitted, List<BlockPos> coordsToCheck, PlacementMode mode, Predicate<LittleTile> predicate, boolean includeWorldBoundaries) {
        for (BlockPos pos : splitted.keySet()) {
            if (LittleActionPlaceStack.isAllowedToInteract(world, player, pos, true, EnumFacing.EAST)) continue;
            LittleActionPlaceStack.sendBlockResetToClient(world, (EntityPlayerMP)player, pos);
            return false;
        }
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacePreviews tiles = splitted.get(pos);
                if (tiles == null || tiles.isEmpty()) continue;
                boolean needsCollisionCheck = false;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreview)tiles.get(j)).needsCollisionTest()) continue;
                    needsCollisionCheck = true;
                    break;
                }
                if (!needsCollisionCheck) continue;
                if (includeWorldBoundaries && (pos.func_177956_o() < 0 || pos.func_177956_o() >= 256)) {
                    return false;
                }
                TileEntityLittleTiles te = LittleActionPlaceStack.loadTe(player, world, pos, false);
                if (te != null) {
                    LittleGridContext contextBefore = te.getContext();
                    tiles.ensureBothAreEqual(te);
                    for (int j = 0; j < tiles.size(); ++j) {
                        if (!((PlacePreview)tiles.get(j)).needsCollisionTest()) continue;
                        if (mode.checkAll()) {
                            if (te.isSpaceForLittleTile(((PlacePreview)tiles.get((int)j)).box, predicate)) continue;
                            if (te.getContext() != contextBefore) {
                                te.convertTo(contextBefore);
                            }
                            return false;
                        }
                        if (te.isSpaceForLittleTileStructure(((PlacePreview)tiles.get((int)j)).box, predicate)) continue;
                        if (te.getContext() != contextBefore) {
                            te.convertTo(contextBefore);
                        }
                        return false;
                    }
                    continue;
                }
                IBlockState state = world.func_180495_p(pos);
                if (state.func_185904_a().func_76222_j()) {
                    return false;
                }
                if (state.func_177230_c() instanceof BlockTile || !mode.checkAll() && LittleActionPlaceStack.isBlockValid(state) && LittleActionPlaceStack.canConvertBlock(player, world, pos, state)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LittleAction flip(EnumFacing.Axis axis, LittleAbsoluteBox box) {
        if (this.placedTiles == null) {
            return null;
        }
        return new LittleActionPlaceAbsolute(this.placedTiles.placedPreviews.copy(), this.mode);
    }

    public static class LittlePlaceResult {
        public final LittleAbsolutePreviews placedPreviews;
        public final LittleBoxes placedBoxes;
        private BlockPos lastPos = null;
        public final List<TileEntityLittleTiles> tileEntities = new ArrayList<TileEntityLittleTiles>();
        public final LittleStructure parentStructure;

        public LittlePlaceResult(BlockPos pos, LittleGridContext context, LittleStructure parentStructure) {
            this.placedPreviews = new LittleAbsolutePreviews(pos, context);
            this.placedBoxes = new LittleBoxes(pos, context);
            this.parentStructure = parentStructure;
        }

        public void addPlacedTile(LittleTile tile) {
            if (this.lastPos == null || !this.lastPos.equals((Object)tile.te.func_174877_v())) {
                this.lastPos = tile.te.func_174877_v();
                this.tileEntities.add(tile.te);
            }
            this.placedPreviews.addTile(tile);
            this.placedBoxes.addBox(tile);
        }
    }

    public static class LastPlacedTile {
        public final PlacePreview tile;
        public final BlockPos pos;
        public final LittleGridContext context;

        public LastPlacedTile(PlacePreview tile, BlockPos pos, LittleGridContext context) {
            this.tile = tile;
            this.pos = pos;
            this.context = context;
        }
    }
}

