/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.world.CreativeWorld;
import com.creativemd.creativecore.common.world.FakeWorld;
import com.creativemd.littletiles.client.render.world.LittleRenderChunkSuppilier;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.entity.EntityAnimationController;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureRegistry;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.LittleFixedStructure;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.place.PlacePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tile.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.util.animation.AnimationState;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.vec.LittleTransformation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AnimationPreview {
    public final EntityAnimation animation;
    public final LittlePreviews previews;
    public final LittleBox entireBox;
    public final LittleGridContext context;
    public final AxisAlignedBB box;

    public AnimationPreview(LittlePreviews previews) {
        this.previews = previews;
        BlockPos pos = new BlockPos(0, 75, 0);
        FakeWorld fakeWorld = FakeWorld.createFakeWorld((String)"animationViewer", (boolean)true);
        fakeWorld.renderChunkSupplier = new LittleRenderChunkSuppilier();
        if (!previews.hasStructure()) {
            NBTTagCompound nbt = new NBTTagCompound();
            new LittleFixedStructure(LittleStructureRegistry.getStructureType(LittleFixedStructure.class)).writeToNBT(nbt);
            LittlePreviewsStructure newPreviews = new LittlePreviewsStructure(nbt, previews.context);
            newPreviews.assign(previews);
            previews = newPreviews;
        }
        ArrayList<PlacePreview> placePreviews = new ArrayList<PlacePreview>();
        previews.getPlacePreviews(placePreviews, null, true, LittleVec.ZERO);
        previews.deleteCachedStructure();
        HashMap<BlockPos, PlacePreviews> splitted = LittleActionPlaceStack.getSplittedTiles(previews.context, placePreviews, pos);
        LittleStructure structure = previews.getStructure();
        LittleActionPlaceStack.placeTilesWithoutPlayer((World)fakeWorld, previews.context, splitted, structure, PlacementMode.all, pos, null, null, null, null);
        this.entireBox = previews.getSurroundingBox();
        this.context = previews.context;
        this.box = this.entireBox.getBox(this.context);
        this.animation = new EntityAnimation((World)fakeWorld, (CreativeWorld)fakeWorld, (EntityAnimationController)new EntityAnimationController(){

            @Override
            protected void writeToNBTExtra(NBTTagCompound nbt) {
            }

            @Override
            protected void readFromNBT(NBTTagCompound nbt) {
            }

            @Override
            public void transform(LittleTransformation transformation) {
            }
        }.addStateAndSelect("nothing", new AnimationState()), pos, UUID.randomUUID(), new StructureAbsolute(pos, this.entireBox, previews.context), structure == null ? null : structure.getAbsoluteIdentifier());
        previews.deleteCachedStructure();
    }
}

