/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.creativecore.common.utils.mc.WorldUtils;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureConnector;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.identifier.LittleIdentifierStructureAbsolute;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public abstract class StructureLinkBaseAbsolute<T>
extends LittleIdentifierStructureAbsolute
implements IStructureConnector<T> {
    protected LittleStructure connectedStructure;
    protected final T parent;

    public StructureLinkBaseAbsolute(LittleTile tile, int attribute, T parent) {
        super(tile, attribute);
        this.parent = parent;
    }

    public StructureLinkBaseAbsolute(TileEntity te, LittleGridContext context, int[] identifier, int attribute, T parent) {
        super(te, context, identifier, attribute);
        this.parent = parent;
    }

    public StructureLinkBaseAbsolute(BlockPos pos, LittleGridContext context, int[] identifier, int attribute, T parent) {
        super(pos, context, identifier, attribute);
        this.parent = parent;
    }

    public StructureLinkBaseAbsolute(NBTTagCompound nbt, T parent) {
        super(nbt);
        this.parent = parent;
    }

    protected abstract void connect(World var1, LittleTile var2);

    protected abstract void failedConnect(World var1);

    @Override
    public BlockPos getStructurePosition() {
        return this.pos;
    }

    @Override
    public LittleStructure getStructureWithoutLoading() {
        return this.connectedStructure;
    }

    protected World getWorld(World world) {
        return world;
    }

    @Override
    public boolean isConnected(World world) {
        if (this.connectedStructure != null) {
            return true;
        }
        if ((world = this.getWorld(world)) == null) {
            return false;
        }
        BlockPos absoluteCoord = this.getStructurePosition();
        Chunk chunk = world.func_175726_f(absoluteCoord);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk)) {
            LittleTile tile;
            TileEntity te = world.func_175625_s(absoluteCoord);
            if (te instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)te).getTile(this.context, this.identifier)) != null && tile.isChildOfStructure() && !tile.connection.isLink()) {
                this.connect(world, tile);
            }
            if (this.connectedStructure == null && !world.field_72995_K) {
                this.failedConnect(world);
            }
            return this.connectedStructure != null;
        }
        return false;
    }

    @Override
    public LittleStructure getStructure(World world) {
        if (this.isConnected(world)) {
            return this.connectedStructure;
        }
        return null;
    }

    @Override
    public void setLoadedStructure(LittleStructure structure) {
        this.connectedStructure = structure;
        this.attribute = structure.getAttribute();
    }

    @Override
    public void reset() {
        this.connectedStructure = null;
    }

    @Override
    public boolean isLink() {
        return true;
    }

    @Override
    public boolean is(LittleTile mainTile) {
        return mainTile.is(this.context, this.identifier);
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }
}

