/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.connection.IStructureChildConnector;
import com.creativemd.littletiles.common.structure.connection.StructureLinkBaseAbsolute;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class StructureLinkToSubWorld
extends StructureLinkBaseAbsolute<LittleStructure>
implements IStructureChildConnector<LittleStructure> {
    public final UUID entityUUID;
    public final int childID;

    public StructureLinkToSubWorld(LittleTile tile, int attribute, LittleStructure parent, int childID, UUID entityUUID) {
        super(tile, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(TileEntity te, LittleGridContext context, int[] identifier, int attribute, LittleStructure parent, int childID, UUID entityUUID) {
        super(te, context, identifier, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(BlockPos pos, LittleGridContext context, int[] identifier, int attribute, LittleStructure parent, int childID, UUID entityUUID) {
        super(pos, context, identifier, attribute, parent);
        this.childID = childID;
        this.entityUUID = entityUUID;
    }

    public StructureLinkToSubWorld(NBTTagCompound nbt, LittleStructure parent) {
        super(nbt, parent);
        this.childID = nbt.func_74762_e("childID");
        this.entityUUID = UUID.fromString(nbt.func_74779_i("entity"));
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt = super.writeToNBT(nbt);
        nbt.func_74768_a("childID", this.childID);
        nbt.func_74778_a("entity", this.entityUUID.toString());
        return nbt;
    }

    @Override
    protected World getWorld(World world) {
        EntityAnimation animation = WorldAnimationHandler.getHandler(world).findAnimation(this.entityUUID);
        if (animation != null) {
            return animation.fakeWorld;
        }
        return null;
    }

    @Override
    protected void connect(World world, LittleTile mainTile) {
        this.connectedStructure = mainTile.connection.getStructureWithoutLoading();
        this.connectedStructure.parent.setLoadedStructure((LittleStructure)this.parent);
    }

    @Override
    protected void failedConnect(World world) {
        new RuntimeException("Failed to connect to parent/ child structure! coord=" + this + "").printStackTrace();
    }

    public StructureLinkToSubWorld copy(LittleStructure parent) {
        return new StructureLinkToSubWorld(this.pos, this.context, (int[])this.identifier.clone(), this.attribute, parent, this.childID, this.entityUUID);
    }

    @Override
    public boolean isChild() {
        return false;
    }

    @Override
    public int getChildID() {
        return this.childID;
    }

    @Override
    public void destroyStructure() {
        this.connectedStructure.onStructureDestroyed();
        EntityAnimation animation = WorldAnimationHandler.getHandler(this.connectedStructure.getWorld()).findAnimation(this.entityUUID);
        if (animation != null) {
            animation.markRemoved();
        }
        for (IStructureChildConnector child : this.connectedStructure.children) {
            child.destroyStructure();
        }
    }

    @Override
    public boolean isLinkToAnotherWorld() {
        return true;
    }

    @Override
    public EntityAnimation getAnimation() {
        return null;
    }
}

