/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.registry;

import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.creativecore.common.utils.type.PairList;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.premade.LittleStructurePremade;
import com.creativemd.littletiles.common.structure.registry.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.structure.type.LittleChair;
import com.creativemd.littletiles.common.structure.type.LittleFixedStructure;
import com.creativemd.littletiles.common.structure.type.LittleLadder;
import com.creativemd.littletiles.common.structure.type.LittleNoClipStructure;
import com.creativemd.littletiles.common.structure.type.LittleStorage;
import com.creativemd.littletiles.common.structure.type.door.LittleDoorBase;
import com.creativemd.littletiles.common.util.animation.AnimationGuiHandler;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class LittleStructureRegistry {
    private static HashMap<String, LittleStructureType> structures = new LinkedHashMap<String, LittleStructureType>();
    private static HashMap<Class<? extends LittleStructure>, LittleStructureType> structuresClass = new LinkedHashMap<Class<? extends LittleStructure>, LittleStructureType>();
    private static PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> craftables = new PairList();

    public static LittleStructureType registerStructureType(String id, String category, Class<? extends LittleStructure> classStructure, int attribute, Class<? extends LittleStructureGuiParser> parser) {
        return LittleStructureRegistry.registerStructureType(id, new LittleStructureType(id, category, classStructure, attribute), parser);
    }

    public static void registerGuiParser(String id, String category, Class<? extends LittleStructureGuiParser> parser) {
        category = "structure.category." + category;
        PairList categoryList = (PairList)craftables.getValue((Object)category);
        if (categoryList == null) {
            categoryList = new PairList();
            craftables.add((Object)category, (Object)categoryList);
        }
        categoryList.add((Object)("structure." + id + ".name"), parser);
    }

    public static PairList<String, PairList<String, Class<? extends LittleStructureGuiParser>>> getCraftables() {
        return craftables;
    }

    public static Class<? extends LittleStructureGuiParser> getParserClass(String id) {
        for (Pair pair : craftables) {
            Class parser = (Class)((PairList)pair.value).getValue((Object)id);
            if (parser == null) continue;
            return parser;
        }
        return null;
    }

    public static LittleStructureGuiParser getParser(GuiParent parent, AnimationGuiHandler handler, Class<? extends LittleStructureGuiParser> clazz) {
        try {
            if (clazz == null) {
                return null;
            }
            return clazz.getConstructor(GuiParent.class, AnimationGuiHandler.class).newInstance(parent, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleStructureGuiParser getParser(GuiParent parent, AnimationGuiHandler handler, String id) {
        try {
            Class<? extends LittleStructureGuiParser> clazz = LittleStructureRegistry.getParserClass(id);
            if (clazz == null) {
                return null;
            }
            return clazz.getConstructor(GuiParent.class, AnimationGuiHandler.class).newInstance(parent, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static LittleStructureType registerStructureType(String id, LittleStructureType entry, Class<? extends LittleStructureGuiParser> parser) {
        if (structures.containsKey(id)) {
            throw new RuntimeException("ID is already taken! id=" + id);
        }
        if (parser != null) {
            LittleStructureRegistry.registerGuiParser(id, entry.category, parser);
        }
        structures.put(id, entry);
        structuresClass.put(entry.structureClass, entry);
        return entry;
    }

    public static String getStructureId(Class<? extends LittleStructure> classStructure) {
        LittleStructureType entry = structuresClass.get(classStructure);
        if (entry != null) {
            return entry.id;
        }
        return null;
    }

    public static Class<? extends LittleStructure> getStructureClass(String id) {
        LittleStructureType entry = structures.get(id);
        if (entry != null) {
            return entry.structureClass;
        }
        return null;
    }

    public static LittleStructureType getStructureType(String id) {
        return structures.get(id);
    }

    public static LittleStructureType getStructureType(Class<? extends LittleStructure> classStructure) {
        return structuresClass.get(classStructure);
    }

    public static void initStructures() {
        LittleStructureRegistry.registerStructureType("fixed", "simple", LittleFixedStructure.class, 0, LittleFixedStructure.LittleFixedStructureParser.class);
        LittleStructureRegistry.registerStructureType("ladder", "simple", LittleLadder.class, 1, LittleLadder.LittleLadderParser.class);
        LittleStructureRegistry.registerStructureType("bed", "simple", LittleBed.class, 0, LittleBed.LittleBedParser.class);
        LittleStructureRegistry.registerStructureType("chair", "simple", LittleChair.class, 0, LittleChair.LittleChairParser.class);
        LittleStructureRegistry.registerStructureType("storage", "simple", LittleStorage.class, 0, LittleStorage.LittleStorageParser.class);
        LittleStructureRegistry.registerStructureType("noclip", "simple", LittleNoClipStructure.class, 2, LittleNoClipStructure.LittleNoClipStructureParser.class);
        LittleDoorBase.initDoors();
        LittleStructurePremade.initPremadeStructures();
    }
}

