/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.relative;

import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleAbsoluteVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.math.vec.LittleVecContext;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import javax.vecmath.Vector3d;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class StructureAbsolute
extends StructureRelative {
    public final LittleVecContext inBlockOffset;
    public final BlockPos baseOffset;
    public final BlockPos chunkOffset;
    public final BlockPos inChunkOffset;
    public final Vector3d rotationCenter;
    public final Vector3d rotationCenterInsideBlock;

    public static int intFloorDiv(int coord, int bucketSize) {
        return coord < 0 ? -((-coord - 1) / bucketSize) - 1 : coord / bucketSize;
    }

    public StructureAbsolute(BlockPos pos, LittleBox box, LittleGridContext context) {
        super(box, context);
        LittleVecContext minVec = this.getMinVec();
        BlockPos minPosOffset = minVec.getBlockPos();
        this.sub(minPosOffset);
        this.inBlockOffset = minVec;
        this.baseOffset = pos.func_177971_a((Vec3i)minPosOffset);
        this.chunkOffset = new BlockPos(this.baseOffset.func_177958_n() >> 4, this.baseOffset.func_177956_o() >> 4, this.baseOffset.func_177952_p() >> 4);
        int chunkX = StructureAbsolute.intFloorDiv(this.baseOffset.func_177958_n(), 16);
        int chunkY = StructureAbsolute.intFloorDiv(this.baseOffset.func_177956_o(), 16);
        int chunkZ = StructureAbsolute.intFloorDiv(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
        this.rotationCenterInsideBlock = this.getCenter();
        this.rotationCenter = new Vector3d(this.rotationCenterInsideBlock);
        this.rotationCenter.x += (double)this.baseOffset.func_177958_n();
        this.rotationCenter.y += (double)this.baseOffset.func_177956_o();
        this.rotationCenter.z += (double)this.baseOffset.func_177952_p();
    }

    public StructureAbsolute(LittleAbsoluteVec pos, LittleBox box, LittleGridContext context) {
        super(box, context);
        this.add(pos.getVecContext());
        LittleVecContext minVec = this.getMinVec();
        BlockPos minPosOffset = minVec.getBlockPos();
        this.sub(minPosOffset);
        minVec.sub(minPosOffset);
        this.inBlockOffset = minVec;
        this.baseOffset = pos.getPos().func_177971_a((Vec3i)minPosOffset);
        this.chunkOffset = new BlockPos(this.baseOffset.func_177958_n() >> 4, this.baseOffset.func_177956_o() >> 4, this.baseOffset.func_177952_p() >> 4);
        int chunkX = StructureAbsolute.intFloorDiv(this.baseOffset.func_177958_n(), 16);
        int chunkY = StructureAbsolute.intFloorDiv(this.baseOffset.func_177956_o(), 16);
        int chunkZ = StructureAbsolute.intFloorDiv(this.baseOffset.func_177952_p(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.func_177958_n() - chunkX * 16, this.baseOffset.func_177956_o() - chunkY * 16, this.baseOffset.func_177952_p() - chunkZ * 16);
        this.rotationCenterInsideBlock = this.getCenter();
        this.rotationCenter = new Vector3d(this.rotationCenterInsideBlock);
        this.rotationCenter.x += (double)this.baseOffset.func_177958_n();
        this.rotationCenter.y += (double)this.baseOffset.func_177956_o();
        this.rotationCenter.z += (double)this.baseOffset.func_177952_p();
    }

    public StructureAbsolute(LittleAbsoluteVec pos, StructureRelative relative) {
        this(pos, relative.box.copy(), relative.context);
    }

    public StructureAbsolute(String name, NBTTagCompound nbt) {
        this(StructureAbsolute.getPos(nbt.func_74759_k(name + "_pos")), LittleBox.createBox(nbt.func_74759_k(name + "_box")), LittleGridContext.get(nbt.func_74762_e(name + "_grid")));
    }

    public StructureAbsolute(LittleAbsoluteVec axis, LittleVec additional) {
        this(axis.getPos(), StructureAbsolute.convertAxisToBox(axis.getVecContext(), additional), axis.getContext());
    }

    @Override
    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74783_a(name + "_pos", new int[]{this.baseOffset.func_177958_n(), this.baseOffset.func_177956_o(), this.baseOffset.func_177952_p()});
        nbt.func_74768_a(name + "_grid", this.context.size);
        nbt.func_74783_a(name + "_box", this.box.getArray());
    }

    @Override
    public LittleVec getDoubledCenterVec() {
        return new LittleVec((this.box.maxX * 2 - this.box.minX * 2) / 2, (this.box.maxY * 2 - this.box.minY * 2) / 2, (this.box.maxZ * 2 - this.box.minZ * 2) / 2);
    }

    private static BlockPos getPos(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static LittleBox convertAxisToBox(LittleVecContext vec, LittleVec additional) {
        if (additional.x == 0) {
            return new LittleBox(vec.getVec().x - 1, vec.getVec().y - 1, vec.getVec().z - 1, vec.getVec().x + 1, vec.getVec().y + 1, vec.getVec().z + 1);
        }
        return new LittleBox(additional.x > 0 ? vec.getVec().x : vec.getVec().x - 1, additional.y > 0 ? vec.getVec().y : vec.getVec().y - 1, additional.z > 0 ? vec.getVec().z : vec.getVec().z - 1, additional.x > 0 ? vec.getVec().x + 1 : vec.getVec().x, additional.y > 0 ? vec.getVec().y + 1 : vec.getVec().y, additional.z > 0 ? vec.getVec().z + 1 : vec.getVec().z);
    }
}

