/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.math.box;

import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.util.grid.IGridBased;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleAbsoluteBox
implements IGridBased {
    public BlockPos pos;
    public LittleGridContext context;
    public LittleBox box;

    public LittleAbsoluteBox(BlockPos pos) {
        this.pos = pos;
        this.context = LittleGridContext.getMin();
        this.box = new LittleBox(0, 0, 0, this.context.size, this.context.size, this.context.size);
    }

    public LittleAbsoluteBox(BlockPos pos, LittleBox box, LittleGridContext context) {
        this.pos = pos;
        this.box = box;
        this.context = context;
    }

    @Override
    public LittleGridContext getContext() {
        return this.context;
    }

    @Override
    public void convertTo(LittleGridContext to) {
        this.box.convertTo(this.context, to);
        this.context = to;
    }

    @Override
    public void convertToSmallest() {
        int size = this.box.getSmallestContext(this.context);
        if (size < this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public LittleVec getDoubledCenter(BlockPos pos) {
        LittleVec vec = this.box.getCenter();
        vec.add(this.pos.func_177973_b((Vec3i)pos), this.context);
        vec.scale(2);
        return vec;
    }
}

