/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.place;

import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.client.render.tile.LittleRenderingCube;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tileentity.TileList;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PlacePreview {
    public static final Vec3d white = new Vec3d(1.0, 1.0, 1.0);
    public LittleBox box;
    public LittlePreview preview;
    public LittlePreviews structurePreview;

    public PlacePreview(LittleBox box, LittlePreview preview, LittlePreviews previews) {
        this.box = box;
        this.preview = preview;
        if (previews != null && previews.hasStructure()) {
            this.structurePreview = previews;
        }
    }

    public PlacePreview copy() {
        return new PlacePreview(this.box.copy(), this.preview.copy(), this.structurePreview);
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public List<LittleRenderingCube> getPreviews(LittleGridContext context) {
        ArrayList<LittleRenderingCube> previews = new ArrayList<LittleRenderingCube>();
        previews.add(this.box.getRenderingCube(context, null, 0));
        return previews;
    }

    public List<LittleTile> placeTile(@Nullable EntityPlayer player, @Nullable ItemStack stack, BlockPos pos, LittleGridContext context, TileEntityLittleTiles te, TileList list, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, PlacementMode mode, @Nullable EnumFacing facing, boolean requiresCollisionTest) {
        LittleTile LT = this.preview.getLittleTile(te);
        if (LT == null) {
            return Collections.EMPTY_LIST;
        }
        LT.box = this.box.copy();
        return mode.placeTile(te, LT, unplaceableTiles, removedTiles, requiresCollisionTest);
    }

    public PlacePreview copyWithBox(LittleBox box) {
        PlacePreview tile = this.copy();
        tile.box = box;
        return tile;
    }

    public boolean split(LittleGridContext context, HashMapList<BlockPos, PlacePreview> tiles, BlockPos pos) {
        if (!this.requiresSplit()) {
            tiles.add((Object)pos, (Object)this);
            return true;
        }
        HashMapList boxes = new HashMapList();
        this.box.split(context, pos, (HashMapList<BlockPos, LittleBox>)boxes);
        for (Map.Entry entry : boxes.entrySet()) {
            for (LittleBox box : (ArrayList)entry.getValue()) {
                tiles.add(entry.getKey(), (Object)this.copyWithBox(box));
            }
        }
        return true;
    }

    public boolean requiresSplit() {
        return true;
    }

    public void add(LittleVec vec) {
        this.box.add(vec);
    }

    public void convertTo(LittleGridContext context, LittleGridContext to) {
        this.box.convertTo(context, to);
    }

    public int getSmallestContext(LittleGridContext context) {
        return this.box.getSmallestContext(context);
    }
}

