/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.preview;

import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.preview.LittlePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleAbsolutePreviews
extends LittlePreviews {
    public BlockPos pos;

    public LittleAbsolutePreviews(BlockPos pos, LittleGridContext context) {
        super(context);
        this.pos = pos;
    }

    protected LittleAbsolutePreviews(LittleAbsolutePreviews previews) {
        super(previews);
        this.pos = previews.pos;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public LittleAbsolutePreviews copy() {
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(this.pos, this.context);
        previews.previews.addAll(this.previews);
        previews.children.addAll(this.children);
        return previews;
    }

    @Override
    public LittlePreview addPreview(BlockPos pos, LittlePreview preview, LittleGridContext context) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        preview.box.add(new LittleVec(context, (Vec3i)pos.func_177973_b((Vec3i)this.pos)));
        this.previews.add(preview);
        return preview;
    }

    @Override
    public LittlePreview addTile(LittleTile tile) {
        LittlePreview preview = this.getPreview(tile);
        preview.box.add(new LittleVec(this.context, (Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)this.pos)));
        this.previews.add(preview);
        return preview;
    }

    @Override
    public LittlePreview addTile(LittleTile tile, LittleVec offset) {
        LittlePreview preview = this.getPreview(tile);
        preview.box.add(new LittleVec(this.context, (Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)this.pos)));
        preview.box.add(offset);
        this.previews.add(preview);
        return preview;
    }
}

