/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tileentity;

import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.world.IOrientatedWorld;
import com.creativemd.littletiles.common.item.ItemLittleWrench;
import com.creativemd.littletiles.common.particle.LittleParticleType;
import com.creativemd.littletiles.common.tile.LittleTile;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.vecmath.Vector3d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityParticle
extends TileEntityCreative
implements ITickable {
    public LittleTile tile;
    public LittleParticleType particle = LittleParticleType.smoke;
    public float par1 = 0.0f;
    public float par2 = 0.0f;
    public float par3 = 0.0f;
    public float ageModifier = 1.0f;
    public float speed = 1.0f;
    public int ticksToWait = 0;
    public boolean randomize = false;
    @SideOnly(value=Side.CLIENT)
    private Method spawnParticle0;
    @SideOnly(value=Side.CLIENT)
    private Field particleMaxAge;

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.receiveUpdatePacket(compound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.getDescriptionNBT(compound);
        return compound;
    }

    public void getDescriptionNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("particle", this.particle.name());
        nbt.func_74776_a("par1", this.par1);
        nbt.func_74776_a("par2", this.par2);
        nbt.func_74776_a("par3", this.par3);
        nbt.func_74776_a("speed", this.speed);
        nbt.func_74757_a("randomize", this.randomize);
        nbt.func_74776_a("age", this.ageModifier);
    }

    public void receiveUpdatePacket(NBTTagCompound nbt) {
        this.particle = LittleParticleType.byName(nbt.func_74779_i("particle"));
        this.par1 = nbt.func_74760_g("par1");
        this.par2 = nbt.func_74760_g("par2");
        this.par3 = nbt.func_74760_g("par3");
        this.speed = nbt.func_74760_g("speed");
        this.ticksToWait = 0;
        this.randomize = nbt.func_74767_n("randomize");
        this.ageModifier = Math.max(0.1f, nbt.func_74760_g("age"));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldSpawnParticles() {
        return !(Minecraft.func_71410_x().field_71439_g.func_184614_ca().func_77973_b() instanceof ItemLittleWrench) && !(Minecraft.func_71410_x().field_71439_g.func_184592_cb().func_77973_b() instanceof ItemLittleWrench);
    }

    public void func_73660_a() {
        if (this.isClientSide()) {
            Vec3d offset = new Vec3d(0.5, 1.0, 0.5);
            if (this.tile != null) {
                offset = this.tile.box.getMinVec().getVec(this.tile.getContext()).func_72441_c(this.tile.getContext().pixelSize / 2.0, this.particle.spawnBelow ? -this.tile.getContext().pixelSize * 2.0 : this.tile.getContext().pixelSize, this.tile.getContext().pixelSize / 2.0);
            }
            if (this.speed >= 1.0f) {
                if (this.shouldSpawnParticles()) {
                    int i = 0;
                    while ((float)i < this.speed) {
                        this.spawnParticle(offset);
                        ++i;
                    }
                }
            } else if (this.ticksToWait == 0) {
                if (this.shouldSpawnParticles()) {
                    this.spawnParticle(offset);
                }
                this.ticksToWait = (int)Math.ceil(1.0f / this.speed);
            } else {
                --this.ticksToWait;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void spawnParticle(Vec3d offset) {
        Vec3d additional = new Vec3d((double)this.par1, (double)this.par2, (double)this.par3);
        if (this.randomize) {
            additional = this.particle.type.randomize(this.par1, this.par2, this.par3);
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (this.spawnParticle0 == null) {
            this.spawnParticle0 = ReflectionHelper.findMethod(RenderGlobal.class, (String)"spawnParticle0", (String)"func_190571_b", (Class[])new Class[]{Integer.TYPE, Boolean.TYPE, Boolean.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, int[].class});
        }
        if (this.particleMaxAge == null) {
            this.particleMaxAge = ReflectionHelper.findField(Particle.class, (String[])new String[]{"particleMaxAge", "field_70547_e"});
        }
        try {
            Particle particleEntity;
            Vector3d pos = new Vector3d((double)this.func_174877_v().func_177958_n() + offset.field_72450_a, (double)this.func_174877_v().func_177956_o() + offset.field_72448_b, (double)this.func_174877_v().func_177952_p() + offset.field_72449_c);
            if (this.field_145850_b instanceof IOrientatedWorld) {
                ((IOrientatedWorld)this.field_145850_b).getOrigin().transformPointToWorld(pos);
            }
            if (this.particle.isModded) {
                particleEntity = this.particle.factory.func_178902_a(0, (World)mc.field_71441_e, pos.x, pos.y, pos.z, additional.field_72450_a, additional.field_72448_b, additional.field_72449_c, new int[0]);
                mc.field_71452_i.func_78873_a(particleEntity);
            } else {
                particleEntity = (Particle)this.spawnParticle0.invoke((Object)mc.field_71438_f, this.particle.particleType.func_179348_c(), true, false, pos.x, pos.y, pos.z, additional.field_72450_a, additional.field_72448_b, additional.field_72449_c, new int[0]);
            }
            if (particleEntity != null) {
                particleEntity.func_187114_a(Math.max(1, (int)((float)this.particleMaxAge.getInt(particleEntity) * this.ageModifier)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

