/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.util.place;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.place.PlacePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.place.PlaceModeAll;
import com.creativemd.littletiles.common.util.place.PlaceModeFill;
import com.creativemd.littletiles.common.util.place.PlaceModeNormal;
import com.creativemd.littletiles.common.util.place.PlaceModeOverwrite;
import com.creativemd.littletiles.common.util.place.PlaceModeReplace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class PlacementMode {
    private static LinkedHashMap<String, PlacementMode> modes = new LinkedHashMap();
    public static PlacementMode normal = new PlaceModeNormal("placement.mode.default", PreviewMode.PREVIEWS, false);
    public static PlacementMode fill = new PlaceModeFill("placement.mode.fill", PreviewMode.PREVIEWS);
    public static PlacementMode all = new PlaceModeAll("placement.mode.all", PreviewMode.PREVIEWS);
    public static PlacementMode overwrite = new PlaceModeOverwrite("placement.mode.overwrite", PreviewMode.PREVIEWS);
    public static PlacementMode replace = new PlaceModeReplace("placement.mode.replace", PreviewMode.LINES);
    public final String name;
    public final boolean placeInside;
    private final PreviewMode mode;

    public static PlacementMode getDefault() {
        return normal;
    }

    public static PlacementMode getStructureDefault() {
        return all;
    }

    public static PlacementMode getModeOrDefault(String name) {
        PlacementMode mode = PlacementMode.getMode(name);
        if (mode != null) {
            return mode;
        }
        return PlacementMode.getDefault();
    }

    public static PlacementMode getMode(String name) {
        return modes.get(name);
    }

    public static Collection<String> getModeNames() {
        return modes.keySet();
    }

    public static List<String> getLocalizedModeNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (String mode : PlacementMode.getModeNames()) {
            names.add(I18n.func_74838_a((String)mode));
        }
        return names;
    }

    public PlacementMode(String name, PreviewMode mode, boolean placeInside) {
        this.name = name;
        this.mode = mode;
        this.placeInside = placeInside;
        modes.put(name, this);
    }

    public PreviewMode getPreviewMode() {
        if (LittleTiles.CONFIG.rendering.previewLines) {
            return PreviewMode.LINES;
        }
        return this.mode;
    }

    public abstract List<BlockPos> getCoordsToCheck(HashMap<BlockPos, PlacePreviews> var1, BlockPos var2);

    public abstract List<LittleTile> placeTile(TileEntityLittleTiles var1, LittleTile var2, List<LittleTile> var3, List<LittleTile> var4, boolean var5);

    @SideOnly(value=Side.CLIENT)
    public PlacementMode place() {
        return this;
    }

    public boolean canPlaceStructures() {
        return false;
    }

    public boolean checkAll() {
        return true;
    }

    public boolean shouldConvertBlock() {
        return false;
    }

    public static enum PreviewMode {
        LINES,
        PREVIEWS;

    }
}

