/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.tile.multiblock;

import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IToggleButton;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleToggleSwitch;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiblockMachine;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiBattery;

public class TileMultiPowerProducer
extends TileMultiBlock
implements IToggleButton,
IModularInventory,
INetworkMachine {
    protected MultiBattery batteries = new MultiBattery();
    protected boolean enabled = false;
    private ModuleToggleSwitch toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", this, TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());

    public boolean getMachineEnabled() {
        return this.enabled;
    }

    public void setMachineEnabled(boolean enabled) {
        this.enabled = enabled;
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            this.setMachineEnabled(nbt.func_74767_n("enabled"));
            this.toggleSwitch.setToggleState(this.getMachineEnabled());
            if (!this.field_145850_b.field_72995_K) {
                PacketHandler.sendToNearby(new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()), this.field_145850_b.field_73011_w.getDimension(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), 64.0);
            }
        }
    }

    @Override
    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            out.writeBoolean(this.enabled);
        }
    }

    @Override
    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()) {
            nbt.func_74757_a("enabled", in.readBoolean());
        }
    }

    @Override
    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.setMachineEnabled(this.toggleSwitch.getState());
            PacketHandler.sendToServer(new PacketMachine(this, (byte)TileMultiblockMachine.NetworkPackets.TOGGLE.ordinal()));
        }
    }

    public MultiBattery getBatteries() {
        return this.batteries;
    }

    @Override
    public void stateUpdated(ModuleBase module) {
        if (module == this.toggleSwitch) {
            this.setMachineEnabled(this.toggleSwitch.getState());
        }
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add(new ModulePower(18, 20, this.getBatteries()));
        this.toggleSwitch = new ModuleToggleSwitch(160, 5, 0, "", this, TextureResources.buttonToggleImage, 11, 26, this.getMachineEnabled());
        modules.add(this.toggleSwitch);
        return modules;
    }

    public void producePower(int amt) {
        this.batteries.acceptEnergy(amt, false);
    }

    @Override
    public String getModularInventoryName() {
        return this.getMachineName();
    }

    @Override
    public boolean canInteractWithContainer(EntityPlayer entity) {
        return this.isComplete();
    }

    @Override
    public void resetCache() {
        this.batteries.clear();
        super.resetCache();
    }

    @Override
    protected void integrateTile(TileEntity tile) {
        super.integrateTile(tile);
        for (BlockMeta block : TileMultiBlock.getMapping('p')) {
            if (block.getBlock() != this.field_145850_b.func_180495_p(tile.func_174877_v()).func_177230_c()) continue;
            this.batteries.addBattery((IUniversalEnergy)tile);
        }
    }

    @Override
    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74757_a("enabled", this.enabled);
    }

    @Override
    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.enabled = nbt.func_74767_n("enabled");
    }
}

