/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests;

import java.util.UUID;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.config.Trigger;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.task.impl.VisitTask;
import online.pixelbuilt.pbquests.utils.Util;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.entity.InteractEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.cause.Root;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class Listeners {
    @Listener
    public void onMove(MoveEntityEvent event, @Getter(value="getTargetEntity") Player player) {
        if (PixelBuiltQuests.playersBusy.contains(player.getUniqueId())) {
            event.setCancelled(true);
            return;
        }
        if (PixelBuiltQuests.runningQuests.contains(player.getUniqueId())) {
            return;
        }
        Location from = event.getFromTransform().getLocation();
        Location to = event.getToTransform().getLocation();
        if (from.getBlockPosition().equals((Object)to.getBlockPosition())) {
            return;
        }
        Location location = to.sub(0.0, 1.0, 0.0);
        Trigger trigger = PixelBuiltQuests.getStorage().getTriggerAt((Location<World>)location);
        if (trigger != null && trigger.onWalk && player.hasPermission("pbq.run")) {
            Tuple<Quest, QuestLine> quest = trigger.getQuest();
            if (quest != null) {
                ((Quest)quest.getFirst()).getExecutor().execute((Quest)quest.getFirst(), (QuestLine)quest.getSecond(), ((Quest)quest.getFirst()).getId(), player);
            } else if (player.hasPermission("pbq.admin")) {
                player.sendMessage(Util.toText(ConfigManager.getConfig().messages.noQuest));
            }
        }
        VisitTask.locations.keys().stream().filter(l -> {
            Location<World> loc = l.getLocation();
            if (loc.equals((Object)to)) {
                return true;
            }
            return ((World)loc.getExtent()).equals(to.getExtent()) && loc.getPosition().distanceSquared(to.getPosition()) <= (double)l.visitRadius;
        }).findFirst().ifPresent(entry -> VisitTask.locations.put(entry, (Object)UUID.randomUUID()));
    }

    @Listener(order=Order.FIRST, beforeModifications=true)
    public void onInteractEntitySecondary(InteractEntityEvent.Secondary.MainHand event, @Root Player p) {
        if (PixelBuiltQuests.runningQuests.contains(p.getUniqueId())) {
            return;
        }
        Entity npc = event.getTargetEntity();
        Tuple<Quest, QuestLine> info = PixelBuiltQuests.getStorage().getQuest(npc);
        if (info != null && p.hasPermission("pbq.run")) {
            event.setCancelled(true);
            ((Quest)info.getFirst()).getExecutor().execute((Quest)info.getFirst(), (QuestLine)info.getSecond(), ((Quest)info.getFirst()).getId(), p);
        }
    }
}

