/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.inject.Inject;
import java.io.File;
import java.util.List;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializers;
import online.pixelbuilt.pbquests.Listeners;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.config.serialization.ValueWrapper;
import online.pixelbuilt.pbquests.quest.executor.QuestExecutorType;
import online.pixelbuilt.pbquests.quest.executor.QuestExecutorTypeRegistryModule;
import online.pixelbuilt.pbquests.reward.RewardRegistryModule;
import online.pixelbuilt.pbquests.reward.RewardType;
import online.pixelbuilt.pbquests.storage.FileStorage;
import online.pixelbuilt.pbquests.storage.SQLStorage;
import online.pixelbuilt.pbquests.storage.StorageModule;
import online.pixelbuilt.pbquests.task.TaskRegistryModule;
import online.pixelbuilt.pbquests.task.TaskType;
import online.pixelbuilt.pbquests.task.impl.ByteItemTask;
import online.pixelbuilt.pbquests.utils.CommandManager;
import org.slf4j.Logger;
import org.spongepowered.api.CatalogType;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.game.GameRegistryEvent;
import org.spongepowered.api.event.game.GameReloadEvent;
import org.spongepowered.api.event.game.state.GamePostInitializationEvent;
import org.spongepowered.api.event.game.state.GamePreInitializationEvent;
import org.spongepowered.api.event.game.state.GameStartedServerEvent;
import org.spongepowered.api.plugin.Dependency;
import org.spongepowered.api.plugin.Plugin;
import org.spongepowered.api.registry.CatalogRegistryModule;

@Plugin(name="PixelBuiltQuests", description="Quests plugin made for the PixelBuilt server", id="pixelbuilt-quests", authors={"Eufranio"}, dependencies={@Dependency(id="byte-items", optional=true)})
public class PixelBuiltQuests {
    public static PixelBuiltQuests instance = null;
    public static List<UUID> playersBusy = Lists.newArrayList();
    public static List<UUID> runningQuests = Lists.newArrayList();
    private StorageModule storage;
    @Inject
    @ConfigDir(sharedRoot=false)
    public File configDir;
    @Inject
    public Logger logger;

    @Listener
    public void onPreInit(GamePreInitializationEvent e) {
        instance = this;
        Sponge.getRegistry().registerModule(TaskType.class, (CatalogRegistryModule)new TaskRegistryModule());
        Sponge.getRegistry().registerModule(RewardType.class, (CatalogRegistryModule)new RewardRegistryModule());
        Sponge.getRegistry().registerModule(QuestExecutorType.class, (CatalogRegistryModule)new QuestExecutorTypeRegistryModule());
        TypeSerializers.getDefaultSerializers().registerType(TypeToken.of(ValueWrapper.class), (TypeSerializer)new ValueWrapper.ValueWrapperTypeSerializer());
    }

    @Listener
    public void onStarted(GameStartedServerEvent event) {
        ConfigManager.init();
        this.initStorage();
        this.logger.warn("PixelBuilt - Quests is starting!");
        CommandManager.registerCommands();
        Sponge.getEventManager().registerListeners((Object)this, (Object)new Listeners());
    }

    @Listener
    public void onRegisterTask(GameRegistryEvent.Register<TaskType> event) {
        if (Sponge.getPluginManager().isLoaded("byte-items")) {
            event.register((CatalogType)new TaskType("byteitem", "ByteItem", ByteItemTask.class));
        }
    }

    @Listener
    public void onInit(GamePostInitializationEvent e) {
        ConfigManager.loadCatalogs();
    }

    @Listener
    public void onReload(GameReloadEvent e) {
        ConfigManager.reload();
        this.storage.shutdown();
        this.initStorage();
    }

    private void initStorage() {
        switch (ConfigManager.getConfig().storage) {
            case 1: {
                this.storage = new FileStorage();
                break;
            }
            case 2: {
                this.storage = new SQLStorage();
                break;
            }
            default: {
                this.storage = new FileStorage();
            }
        }
        this.storage.init(this);
    }

    public static StorageModule getStorage() {
        return PixelBuiltQuests.instance.storage;
    }

    public static PixelBuiltQuests getInstance() {
        return instance;
    }

    public Logger getLogger() {
        return this.logger;
    }
}

