/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import online.pixelbuilt.pbquests.PixelBuiltQuests;
import online.pixelbuilt.pbquests.config.Config;
import online.pixelbuilt.pbquests.config.ConfigCategory;
import online.pixelbuilt.pbquests.config.QuestLinesCategory;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import online.pixelbuilt.pbquests.reward.BaseReward;
import online.pixelbuilt.pbquests.reward.RewardType;
import online.pixelbuilt.pbquests.task.BaseTask;
import online.pixelbuilt.pbquests.task.TaskType;
import org.spongepowered.api.Sponge;

public class ConfigManager {
    private static Map<Class<?>, Object> mapping = Maps.newHashMap();
    private static List<Quest> quests = Lists.newArrayList();
    private static List<QuestLine> questLines = Lists.newArrayList();
    private static Config<ConfigCategory> config;
    private static Path configDir;
    private static Path questsDir;
    private static Path rewardsDir;
    private static Path tasksDir;

    public static void init() {
        config = new Config<ConfigCategory>(ConfigCategory.class, "PBQuests.conf", configDir);
        ConfigManager.loadResources();
    }

    public static void reload() {
        mapping.clear();
        quests.clear();
        questLines.clear();
        ConfigManager.loadResources();
        ConfigManager.loadCatalogs();
    }

    private static void loadResources() {
        Config<QuestLinesCategory> lines = new Config<QuestLinesCategory>(QuestLinesCategory.class, "QuestLines.conf", configDir);
        questLines.addAll(lines.get().questLines);
        config = new Config<ConfigCategory>(ConfigCategory.class, "PBQuests.conf", configDir);
    }

    public static void loadCatalogs() {
        try {
            for (RewardType reward : Sponge.getRegistry().getAllOf(RewardType.class)) {
                new Config<BaseReward>(reward.getValueClass(), reward.getId().replace("pbq:", "") + ".conf", rewardsDir);
            }
            for (TaskType task : Sponge.getRegistry().getAllOf(TaskType.class)) {
                new Config<BaseTask>(task.getValueClass(), task.getId().replace("pbq:", "") + ".conf", tasksDir);
            }
            if (!Files.exists(questsDir, new LinkOption[0])) {
                questsDir.toFile().mkdirs();
            }
            try (Stream<Path> paths = Files.walk(questsDir, new FileVisitOption[0]);){
                paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(path -> {
                    Quest quest = new Config<Quest>(Quest.class, path.toFile().getName(), questsDir).get();
                    quest.setId(Integer.parseInt(path.toFile().getName().replace(".conf", "")));
                    return quest;
                }).forEach(quests::add);
            }
            if (quests.isEmpty()) {
                quests.add(new Config<Quest>(Quest.class, "0.conf", questsDir).get());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Quest getQuest(int questId) {
        return quests.stream().filter(q -> q.getId() == questId).findFirst().orElse(null);
    }

    public static List<Quest> getQuests() {
        return quests;
    }

    public static QuestLine getLine(String name) {
        return questLines.stream().filter(q -> q.getName().equals(name)).findFirst().orElse(null);
    }

    public static List<QuestLine> getLines() {
        return questLines;
    }

    public static ConfigCategory getConfig() {
        return config.get();
    }

    static {
        configDir = PixelBuiltQuests.getInstance().configDir.toPath();
        questsDir = configDir.resolve("quests");
        rewardsDir = configDir.resolve("rewards");
        tasksDir = configDir.resolve("tasks");
    }
}

