/*
 * Decompiled with CFR 0.152.
 */
package online.pixelbuilt.pbquests.config;

import com.flowpowered.math.vector.Vector3i;
import java.util.UUID;
import ninja.leaping.configurate.objectmapping.Setting;
import ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import online.pixelbuilt.pbquests.config.ConfigManager;
import online.pixelbuilt.pbquests.quest.Quest;
import online.pixelbuilt.pbquests.quest.QuestLine;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.util.Tuple;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.extent.Extent;

@ConfigSerializable
public class Trigger {
    @Setting
    public int x;
    @Setting
    public int y;
    @Setting
    public int z;
    @Setting
    public UUID worldUUID;
    @Setting
    private String questLine;
    @Setting
    private int questId;
    @Setting
    public boolean onWalk = true;
    private Location<World> location;
    private Vector3i blockPosition;

    public Trigger() {
    }

    public Vector3i getPosition() {
        if (this.blockPosition == null) {
            this.blockPosition = new Vector3i(this.x, this.y, this.z);
        }
        return this.blockPosition;
    }

    public Location<World> getLocation() {
        if (this.location == null) {
            this.location = new Location((Extent)Sponge.getServer().loadWorld(this.worldUUID).get(), this.getPosition());
        }
        return this.location;
    }

    public Trigger(int x, int y, int z, UUID world, String line, int id, boolean onWalk) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldUUID = world;
        this.questId = id;
        this.questLine = line;
        this.onWalk = onWalk;
    }

    public Trigger(Location<World> loc, String line, int id, boolean onWalk) {
        this(loc.getBlockX(), loc.getBlockY(), loc.getBlockZ(), ((World)loc.getExtent()).getUniqueId(), line, id, onWalk);
    }

    public Trigger(Location<World> loc, Quest quest, QuestLine line, Type type) {
        this(loc, line.getName(), quest.getId(), type == Type.WALK);
    }

    public Tuple<Quest, QuestLine> getQuest() {
        return new Tuple((Object)ConfigManager.getQuest(this.questId), (Object)ConfigManager.getLine(this.questLine));
    }

    public static enum Type {
        WALK,
        CLICK;

    }
}

